/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.JavaIdentifierNormalizer;
import com.semarchy.xdi.elasticsearch.common.Messages;
import com.semarchy.xdi.elasticsearch.common.ReflectUtil;
import com.semarchy.xdi.elasticsearch.json.SpringDataKeyword;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;

public class JsonSchemaParser {
    public static final String ROOT_FIELD_NAME = "JsonSchema";
    private Map<String, Class<?>> parsedJsonSchema;
    private final Map<String, Class<?>> arraysTypes = new HashMap();
    private ClassLoader classLoader;
    private final Set<String> rootFields = new HashSet<String>();
    private final Map<Class<?>, Map<String, String>> fieldsElasticJava = new HashMap();
    public static final String PACKAGE_SEPARATOR = ".";
    protected static final String REGEX_PACKAGE_SEPARATOR = "\\" + ".";
    public static final String TYPE = "type";
    public static final String ITEMS = "items";
    public static final String PROPERTIES = "properties";
    public static final String BOOLEAN = "boolean";
    public static final String STRING = "string";
    public static final String NUMBER = "number";
    public static final String ARRAY = "array";
    public static final String OBJECT = "object";

    public JsonSchemaParser(ClassLoader classLoader, String rawJsonSchema) throws ElasticSearchException {
        this.classLoader = classLoader;
        try {
            JsonNode jsonSchema = ReflectUtil.MAPPER.readTree(rawJsonSchema);
            Class<?> parsedSchema = this.parseSchema("", jsonSchema);
            this.parsedJsonSchema = ReflectUtil.getFieldsTypes(parsedSchema);
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    public Map<String, Class<?>> getParsedJsonSchema() {
        return this.parsedJsonSchema;
    }

    public Map<String, Class<?>> getArraysTypes() {
        return this.arraysTypes;
    }

    public Map<Class<?>, Map<String, String>> getFieldsElasticJava() {
        return this.fieldsElasticJava;
    }

    private Class<?> parseSchema(String fieldName, JsonNode jsonNode) throws ElasticSearchException {
        Class objectClass;
        block23: {
            String pathInError;
            block21: {
                String fieldType;
                String objectName;
                String nextPackageName;
                if ((fieldName = this.renameKeyWordFields(fieldName)).isEmpty()) {
                    nextPackageName = fieldName;
                    objectName = ROOT_FIELD_NAME;
                    pathInError = ROOT_FIELD_NAME;
                } else {
                    nextPackageName = fieldName + PACKAGE_SEPARATOR;
                    objectName = fieldName;
                    pathInError = String.join((CharSequence)PACKAGE_SEPARATOR, ROOT_FIELD_NAME, fieldName);
                }
                String string = fieldType = jsonNode.has(TYPE) ? jsonNode.get(TYPE).asText() : null;
                if (fieldType == null) break block21;
                switch (fieldType) {
                    case "boolean": {
                        objectClass = Boolean.class;
                        break block23;
                    }
                    case "string": {
                        objectClass = String.class;
                        break block23;
                    }
                    case "number": {
                        objectClass = Number.class;
                        break block23;
                    }
                    case "array": {
                        objectClass = this.parseSchemaArray(jsonNode, nextPackageName);
                        break block23;
                    }
                    case "object": {
                        objectClass = this.parseSchemaObject(jsonNode, objectName, nextPackageName);
                        break block23;
                    }
                    default: {
                        throw new ElasticSearchException(String.format(Messages.getString("UNKNOWN_TYPE"), fieldType, pathInError));
                    }
                }
            }
            throw new ElasticSearchException(String.format(Messages.getString("NO_TYPE"), pathInError));
        }
        return objectClass;
    }

    private String renameKeyWordFields(String fieldName) {
        String lastFieldName;
        String[] splittedFieldName = fieldName.split(REGEX_PACKAGE_SEPARATOR);
        int level = splittedFieldName.length;
        if (1 == level && SpringDataKeyword.contains(lastFieldName = splittedFieldName[0])) {
            int offset = 0;
            String originalFieldName = lastFieldName;
            lastFieldName = originalFieldName + offset;
            while (this.rootFields.contains(lastFieldName)) {
                lastFieldName = originalFieldName + ++offset;
            }
            fieldName = fieldName + offset;
        }
        return fieldName;
    }

    private Class<?> parseSchemaArray(JsonNode jsonNode, String nextPackageName) throws ElasticSearchException {
        Class<List> objectClass = List.class;
        if (jsonNode.has(ITEMS)) {
            JsonNode items = jsonNode.get(ITEMS);
            String itemFieldName = nextPackageName + ITEMS;
            Class<?> arrayType = this.parseSchema(itemFieldName, items);
            this.arraysTypes.put(itemFieldName, arrayType);
        }
        return objectClass;
    }

    private Class<?> parseSchemaObject(JsonNode jsonNode, String objectName, String nextPackageName) throws ElasticSearchException {
        Map<Object, Object> elasticJavaFields = Collections.emptyMap();
        DynamicType.Builder objectBuilder = new ByteBuddy().subclass(Object.class).name(objectName);
        if (jsonNode.has(PROPERTIES)) {
            JsonNode fieldProperties = jsonNode.get(PROPERTIES);
            HashSet<String> elasticFields = new HashSet<String>();
            fieldProperties.fieldNames().forEachRemaining(elasticFields::add);
            elasticJavaFields = JavaIdentifierNormalizer.normalizeJavaFieldsNames(elasticFields);
            Iterator subNodesIterator = fieldProperties.fields();
            while (subNodesIterator.hasNext()) {
                Map.Entry subNodeEntry = (Map.Entry)subNodesIterator.next();
                String elasticField = (String)subNodeEntry.getKey();
                String javaField = (String)elasticJavaFields.get(elasticField);
                AnnotationDescription fieldAnnotation = JavaIdentifierNormalizer.FIELD_BUILDER.define("name", elasticField).build();
                String subFieldName = nextPackageName + javaField;
                JsonNode subNode = (JsonNode)subNodeEntry.getValue();
                Class<?> subNodeClass = this.parseSchema(subFieldName, subNode);
                objectBuilder = objectBuilder.defineField(javaField, subNodeClass, new ModifierContributor.ForField[]{Visibility.PUBLIC}).annotateField(new AnnotationDescription[]{fieldAnnotation});
            }
        }
        DynamicType.Unloaded unloadedObject = objectBuilder.make();
        DynamicType.Loaded loadedObject = unloadedObject.load(this.classLoader);
        Class javaClass = loadedObject.getLoaded();
        this.fieldsElasticJava.put(javaClass, elasticJavaFields);
        return javaClass;
    }
}

