/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.json;

import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.StoredScriptId;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldType;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.RescoreQuery;
import co.elastic.clients.elasticsearch.core.search.ScoreMode;
import co.elastic.clients.elasticsearch.core.search.Suggester;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.Messages;
import jakarta.json.Json;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.NativeQueryBuilder;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptData;
import org.springframework.data.elasticsearch.core.query.ScriptType;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.data.elasticsearch.core.query.highlight.Highlight;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightFieldParameters;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightParameters;

public class QueryParser {
    private static final String DAY = "d";
    private static final String HOUR = "h";
    private static final String MINUTE = "m";
    private static final String SECOND = "s";
    private static final String MILLI_SECOND = "ms";
    private static final String MICRO_SECOND = "micros";
    private static final String NANO_SECOND = "nanos";
    private static final JsonpMapper JSON_MAPPER = new JacksonJsonpMapper();
    private SearchRequest searchRequest;
    private NativeQueryBuilder nativeQueryBuilder = NativeQuery.builder();
    private org.springframework.data.elasticsearch.core.query.Query query;

    public QueryParser(String rawQueryAsString) throws ElasticSearchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JsonParser jsonParser = Json.createParser((Reader)new StringReader(rawQueryAsString));){
            this.searchRequest = (SearchRequest)SearchRequest._DESERIALIZER.deserialize(jsonParser, JSON_MAPPER);
            this.query();
            this.pageable();
            this.suggester();
            this.sort();
            this.aggregations();
            this.scriptedField();
            this.searchExtensions();
            this.filter();
            this.fieldCollapse();
            this.trackScores();
            this.minScore();
            this.preference();
            this.fields();
            this.route();
            this.indicesBoost();
            this.storedFields();
            this.searchType();
            this.trackTotalHits();
            this.explain();
            this.searchAfter();
            this.requestCache();
            this.runtimeFields();
            this.indicesOptions();
            this.highlightQuery();
            this.timeout();
            this.scrollTime();
            this.rescorerQueries();
            this.query = this.nativeQueryBuilder.build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public org.springframework.data.elasticsearch.core.query.Query getQuery() {
        return this.query;
    }

    private void query() {
        Query dslQuery = this.searchRequest.query();
        if (dslQuery != null) {
            this.nativeQueryBuilder.withQuery(this.searchRequest.query());
        }
    }

    private void pageable() {
        Integer from = this.searchRequest.from();
        Integer requestSize = this.searchRequest.size();
        if (requestSize != null) {
            int size = requestSize;
            PageRequest pageRequest = from == null ? PageRequest.ofSize((int)size) : PageRequest.of((int)from, (int)size);
            this.nativeQueryBuilder.withPageable((Pageable)pageRequest);
        }
    }

    private void suggester() {
        Suggester suggest = this.searchRequest.suggest();
        if (suggest != null) {
            this.nativeQueryBuilder.withSuggester(suggest);
        }
    }

    private void sort() {
        List sort = this.searchRequest.sort();
        if (!sort.isEmpty()) {
            this.nativeQueryBuilder.withSort(sort);
        }
    }

    private void aggregations() {
        Map aggregations = this.searchRequest.aggregations();
        if (!aggregations.isEmpty()) {
            for (Map.Entry aggregationEntry : aggregations.entrySet()) {
                this.nativeQueryBuilder.withAggregation((String)aggregationEntry.getKey(), (Aggregation)aggregationEntry.getValue());
            }
        }
    }

    private void scriptedField() {
        Map scriptFields = this.searchRequest.scriptFields();
        if (!scriptFields.isEmpty()) {
            for (Map.Entry scriptFieldEntry : scriptFields.entrySet()) {
                ScriptData scriptData;
                String name = (String)scriptFieldEntry.getKey();
                ScriptField script = (ScriptField)scriptFieldEntry.getValue();
                if (script == null || (scriptData = QueryParser.scriptData(name, script.script())) == null) continue;
                this.nativeQueryBuilder.withScriptedField(new ScriptedField(name, scriptData));
            }
        }
    }

    private static ScriptData scriptData(String name, Script script) {
        ScriptData scriptData = null;
        ScriptType scriptType = null;
        String lang = null;
        String source = null;
        HashMap<String, Object> objectParams = new HashMap<String, Object>();
        InlineScript scriptBase = null;
        if (script.isInline()) {
            scriptType = ScriptType.INLINE;
            InlineScript inlineScript = script.inline();
            lang = inlineScript.lang();
            source = inlineScript.source();
            scriptBase = inlineScript;
        } else if (script.isStored()) {
            scriptType = ScriptType.STORED;
            StoredScriptId storedScriptId = script.stored();
            source = storedScriptId.id();
            scriptBase = storedScriptId;
        }
        if (scriptBase != null) {
            Map jsonParams = scriptBase.params();
            for (Map.Entry jsonParam : jsonParams.entrySet()) {
                objectParams.put((String)jsonParam.getKey(), QueryParser.getValue((JsonData)jsonParam.getValue()));
            }
        }
        if (scriptType != null) {
            scriptData = new ScriptData(scriptType, lang, source, name, objectParams);
        }
        return scriptData;
    }

    private static Object getValue(JsonData data) {
        Object value = null;
        JsonValue.ValueType valueType = data.toJson(JSON_MAPPER).getValueType();
        switch (valueType) {
            case ARRAY: {
                value = data.to(List.class, JSON_MAPPER);
                break;
            }
            case OBJECT: {
                value = data.to(Object.class, JSON_MAPPER);
                break;
            }
            case STRING: {
                value = data.to(String.class, JSON_MAPPER);
                break;
            }
            case NUMBER: {
                value = data.to(Integer.class, JSON_MAPPER);
                break;
            }
            case TRUE: {
                value = true;
                break;
            }
            case FALSE: {
                value = false;
            }
        }
        return value;
    }

    private void searchExtensions() {
        Map ext = this.searchRequest.ext();
        if (!ext.isEmpty()) {
            this.nativeQueryBuilder.withSearchExtensions(ext);
        }
    }

    private void filter() {
        Query filter = this.searchRequest.postFilter();
        if (filter != null) {
            this.nativeQueryBuilder.withFilter(filter);
        }
    }

    private void fieldCollapse() {
        FieldCollapse fieldCollapse = this.searchRequest.collapse();
        if (fieldCollapse != null) {
            this.nativeQueryBuilder.withFieldCollapse(fieldCollapse);
        }
    }

    private void trackScores() {
        Boolean trackScores = this.searchRequest.trackScores();
        if (trackScores != null) {
            this.nativeQueryBuilder.withTrackScores(trackScores.booleanValue());
        }
    }

    private void minScore() {
        Double minScore = this.searchRequest.minScore();
        if (minScore != null) {
            this.nativeQueryBuilder.withMinScore(minScore.floatValue());
        }
    }

    private void preference() {
        String preference = this.searchRequest.preference();
        if (preference != null) {
            this.nativeQueryBuilder.withPreference(preference);
        }
    }

    private void fields() {
        List fields = this.searchRequest.fields();
        if (!fields.isEmpty()) {
            HashSet<String> fieldsNames = new HashSet<String>();
            for (FieldAndFormat field : fields) {
                if (field == null) continue;
                fieldsNames.add(field.field());
            }
            this.nativeQueryBuilder.withFields(fieldsNames);
        }
    }

    private void route() {
        String routing = this.searchRequest.routing();
        if (routing != null) {
            this.nativeQueryBuilder.withRoute(routing);
        }
    }

    private void indicesBoost() {
        List indicesBoostListMap = this.searchRequest.indicesBoost();
        if (!indicesBoostListMap.isEmpty()) {
            for (Map indicesBoostMap : indicesBoostListMap) {
                ArrayList<IndexBoost> indicesBoostList = new ArrayList<IndexBoost>();
                for (Map.Entry indexEntry : indicesBoostMap.entrySet()) {
                    Double boost = (Double)indexEntry.getValue();
                    if (boost == null) continue;
                    IndexBoost indexBoost = new IndexBoost((String)indexEntry.getKey(), boost.floatValue());
                    indicesBoostList.add(indexBoost);
                }
                if (indicesBoostList.isEmpty()) continue;
                this.nativeQueryBuilder.withIndicesBoost(indicesBoostList);
            }
        }
    }

    private void storedFields() {
        List storedFields = this.searchRequest.storedFields();
        if (!storedFields.isEmpty()) {
            this.nativeQueryBuilder.withStoredFields(storedFields);
        }
    }

    private void searchType() {
        SearchType requestSearchType = this.searchRequest.searchType();
        if (requestSearchType != null) {
            Query.SearchType querySearchType = switch (requestSearchType) {
                case SearchType.QueryThenFetch -> Query.SearchType.QUERY_THEN_FETCH;
                case SearchType.DfsQueryThenFetch -> Query.SearchType.DFS_QUERY_THEN_FETCH;
                default -> throw new MatchException(null, null);
            };
            this.nativeQueryBuilder.withSearchType(querySearchType);
        }
    }

    private void trackTotalHits() {
        TrackHits trackTotalHits = this.searchRequest.trackTotalHits();
        if (trackTotalHits != null) {
            if (TrackHits.Kind.Count.equals((Object)trackTotalHits._kind())) {
                this.nativeQueryBuilder.withTrackTotalHitsUpTo(trackTotalHits.count());
            } else {
                this.nativeQueryBuilder.withTrackTotalHits(trackTotalHits.enabled());
            }
        }
    }

    private void explain() {
        Boolean explain = this.searchRequest.explain();
        if (explain != null) {
            this.nativeQueryBuilder.withExplain(explain.booleanValue());
        }
    }

    private void searchAfter() {
        List searchAfterRequest = this.searchRequest.searchAfter();
        if (!searchAfterRequest.isEmpty()) {
            ArrayList searchAfterQuery = new ArrayList();
            searchAfterQuery.addAll(searchAfterRequest);
            this.nativeQueryBuilder.withSearchAfter(searchAfterQuery);
        }
    }

    private void requestCache() {
        Boolean requestCache = this.searchRequest.requestCache();
        if (requestCache != null) {
            this.nativeQueryBuilder.withRequestCache(requestCache);
        }
    }

    private void runtimeFields() {
        Map runtimeMappings = this.searchRequest.runtimeMappings();
        if (!runtimeMappings.isEmpty()) {
            ArrayList<org.springframework.data.elasticsearch.core.query.RuntimeField> runtimeFields = new ArrayList<org.springframework.data.elasticsearch.core.query.RuntimeField>();
            for (RuntimeField requestRuntimeField : runtimeMappings.values()) {
                String queryScript;
                if (requestRuntimeField == null) continue;
                RuntimeFieldType rawType = requestRuntimeField.type();
                Script requestScript = requestRuntimeField.script();
                String string = queryScript = requestScript == null ? null : (String)requestScript._get();
                if (queryScript == null) continue;
                org.springframework.data.elasticsearch.core.query.RuntimeField runtimeField = new org.springframework.data.elasticsearch.core.query.RuntimeField(requestRuntimeField.format(), rawType.jsonValue(), queryScript);
                runtimeFields.add(runtimeField);
            }
            this.nativeQueryBuilder.withRuntimeFields(runtimeFields);
        }
    }

    private void indicesOptions() {
        boolean allowNoIndices = this.allowNoIndices();
        boolean ignoreUnavailable = this.ignoreUnavailable();
        boolean ignoreThrottled = this.ignoreThrottled();
        EnumSet<IndicesOptions.Option> options = QueryParser.options(allowNoIndices, ignoreUnavailable, ignoreThrottled);
        this.expandWildcards(options);
    }

    private boolean allowNoIndices() {
        Boolean allowNoIndicesObject = this.searchRequest.allowNoIndices();
        boolean allowNoIndices = false;
        if (allowNoIndicesObject != null) {
            allowNoIndices = allowNoIndicesObject;
        }
        return allowNoIndices;
    }

    private boolean ignoreUnavailable() {
        Boolean ignoreUnavailableObject = this.searchRequest.ignoreUnavailable();
        boolean ignoreUnavailable = false;
        if (ignoreUnavailableObject != null) {
            ignoreUnavailable = ignoreUnavailableObject;
        }
        return ignoreUnavailable;
    }

    private boolean ignoreThrottled() {
        Boolean ignoreThrottledObject = this.searchRequest.ignoreThrottled();
        boolean ignoreThrottled = false;
        if (ignoreThrottledObject != null) {
            ignoreThrottled = ignoreThrottledObject;
        }
        return ignoreThrottled;
    }

    private static EnumSet<IndicesOptions.Option> options(boolean allowNoIndices, boolean ignoreUnavailable, boolean ignoreThrottled) {
        EnumSet<IndicesOptions.Option> options = EnumSet.noneOf(IndicesOptions.Option.class);
        if (allowNoIndices) {
            options = ignoreUnavailable ? (ignoreThrottled ? EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_THROTTLED) : EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE)) : (ignoreThrottled ? EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_THROTTLED) : EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES));
        } else if (ignoreUnavailable) {
            options = ignoreThrottled ? EnumSet.of(IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_THROTTLED) : EnumSet.of(IndicesOptions.Option.IGNORE_UNAVAILABLE);
        } else if (ignoreThrottled) {
            options = EnumSet.of(IndicesOptions.Option.IGNORE_THROTTLED);
        }
        return options;
    }

    private void expandWildcards(EnumSet<IndicesOptions.Option> options) {
        List expandWildcards = this.searchRequest.expandWildcards();
        if (!expandWildcards.isEmpty()) {
            for (ExpandWildcard expandWildcard : expandWildcards) {
                EnumSet<IndicesOptions.WildcardStates> wildcardStates = EnumSet.noneOf(IndicesOptions.WildcardStates.class);
                switch (expandWildcard) {
                    case Open: {
                        wildcardStates = EnumSet.of(IndicesOptions.WildcardStates.OPEN);
                        break;
                    }
                    case Closed: {
                        wildcardStates = EnumSet.of(IndicesOptions.WildcardStates.CLOSED);
                        break;
                    }
                    case Hidden: {
                        wildcardStates = EnumSet.of(IndicesOptions.WildcardStates.HIDDEN);
                        break;
                    }
                    case All: {
                        wildcardStates = EnumSet.of(IndicesOptions.WildcardStates.ALL);
                    }
                }
                IndicesOptions queryIndicesOptions = new IndicesOptions(options, wildcardStates);
                this.nativeQueryBuilder.withIndicesOptions(queryIndicesOptions);
            }
        }
    }

    private void highlightQuery() {
        co.elastic.clients.elasticsearch.core.search.Highlight requestHighlight = this.searchRequest.highlight();
        if (requestHighlight != null) {
            HighlightParameters highlightParameters = QueryParser.encoder(requestHighlight);
            Map requestFields = requestHighlight.fields();
            ArrayList<HighlightField> highlightFields = new ArrayList<HighlightField>();
            if (!requestFields.isEmpty()) {
                for (Map.Entry highlightFieldEntry : requestFields.entrySet()) {
                    co.elastic.clients.elasticsearch.core.search.HighlightField requestHighlightField = (co.elastic.clients.elasticsearch.core.search.HighlightField)highlightFieldEntry.getValue();
                    if (requestHighlightField == null) continue;
                    HighlightFieldParameters.HighlightFieldParametersBuilder highlightFieldParametersBuilder = HighlightFieldParameters.builder();
                    QueryParser.fragmentOffset(requestHighlightField, highlightFieldParametersBuilder);
                    QueryParser.matchedFields(requestHighlightField, highlightFieldParametersBuilder);
                    HighlightFieldParameters highlightFieldParameters = highlightFieldParametersBuilder.build();
                    HighlightField queryHighlightField = new HighlightField((String)highlightFieldEntry.getKey(), highlightFieldParameters);
                    highlightFields.add(queryHighlightField);
                }
            }
            Highlight queryHighlight = new Highlight(highlightParameters, highlightFields);
            HighlightQuery highlightQuery = new HighlightQuery(queryHighlight, null);
            this.nativeQueryBuilder.withHighlightQuery(highlightQuery);
        }
    }

    private static HighlightParameters encoder(co.elastic.clients.elasticsearch.core.search.Highlight highlight) {
        HighlighterEncoder rawEncoder = highlight.encoder();
        HighlightParameters.HighlightParametersBuilder highlightParametersBuilder = HighlightParameters.builder();
        if (rawEncoder != null) {
            highlightParametersBuilder.withEncoder(rawEncoder.jsonValue());
        }
        return highlightParametersBuilder.build();
    }

    private static HighlightFieldParameters.HighlightFieldParametersBuilder fragmentOffset(co.elastic.clients.elasticsearch.core.search.HighlightField highlightField, HighlightFieldParameters.HighlightFieldParametersBuilder highlightFieldParametersBuilder) {
        Integer fragmentOffset = highlightField.fragmentOffset();
        if (fragmentOffset != null) {
            highlightFieldParametersBuilder.withFragmentOffset(fragmentOffset.intValue());
        }
        return highlightFieldParametersBuilder;
    }

    private static HighlightFieldParameters.HighlightFieldParametersBuilder matchedFields(co.elastic.clients.elasticsearch.core.search.HighlightField highlightField, HighlightFieldParameters.HighlightFieldParametersBuilder highlightFieldParametersBuilder) {
        List requestMatchedFields = highlightField.matchedFields();
        if (!requestMatchedFields.isEmpty()) {
            highlightFieldParametersBuilder.withMatchedFields((String[])requestMatchedFields.toArray(String[]::new));
        }
        return highlightFieldParametersBuilder;
    }

    private void timeout() throws ElasticSearchException {
        String rawTimeout = this.searchRequest.timeout();
        if (rawTimeout != null) {
            Duration parsedTimeout = QueryParser.duration(rawTimeout);
            this.nativeQueryBuilder.withTimeout(parsedTimeout);
        }
    }

    private static Duration duration(String durationWithUnit) throws ElasticSearchException {
        Long value = null;
        Duration duration = null;
        if (durationWithUnit.endsWith(DAY)) {
            value = QueryParser.removeUnit(durationWithUnit, DAY);
            duration = Duration.ofDays(value);
        } else if (durationWithUnit.endsWith(HOUR)) {
            value = QueryParser.removeUnit(durationWithUnit, HOUR);
            duration = Duration.ofHours(value);
        } else if (durationWithUnit.endsWith(MINUTE)) {
            value = QueryParser.removeUnit(durationWithUnit, MINUTE);
            duration = Duration.ofMinutes(value);
        } else if (durationWithUnit.endsWith(MILLI_SECOND)) {
            value = QueryParser.removeUnit(durationWithUnit, MILLI_SECOND);
            duration = Duration.ofMillis(value);
        } else if (durationWithUnit.endsWith(MICRO_SECOND)) {
            value = QueryParser.removeUnit(durationWithUnit, MICRO_SECOND);
            duration = Duration.ofNanos(value * 1000L);
        } else if (durationWithUnit.endsWith(NANO_SECOND)) {
            value = QueryParser.removeUnit(durationWithUnit, NANO_SECOND);
            duration = Duration.ofNanos(value);
        } else if (durationWithUnit.endsWith(SECOND)) {
            value = QueryParser.removeUnit(durationWithUnit, SECOND);
            duration = Duration.ofSeconds(value);
        } else {
            throw new ElasticSearchException(Messages.getString("INCONSISTENT_UNIT"));
        }
        return duration;
    }

    private static long removeUnit(String valueWithUnit, String unit) {
        String rawValue = valueWithUnit.substring(0, valueWithUnit.indexOf(unit));
        return Long.parseLong(rawValue);
    }

    private void scrollTime() throws ElasticSearchException {
        Time scrollTime = this.searchRequest.scroll();
        if (scrollTime != null) {
            Duration parsedScroll = QueryParser.duration(scrollTime._toJsonString());
            this.nativeQueryBuilder.withScrollTime(parsedScroll);
        }
    }

    private void rescorerQueries() throws ElasticSearchException {
        List requestRescores = this.searchRequest.rescore();
        if (!requestRescores.isEmpty()) {
            ArrayList<RescorerQuery> rescorerQueries = new ArrayList<RescorerQuery>();
            for (Rescore rescore : requestRescores) {
                RescoreQuery rescoreQuery = rescore.query();
                Query lowLevelQuery = rescoreQuery.query();
                String rawQuery = lowLevelQuery.toString().substring(7);
                org.springframework.data.elasticsearch.core.query.Query springQuery = new QueryParser(rawQuery).getQuery();
                RescorerQuery rescorerQuery = new RescorerQuery(springQuery);
                QueryParser.windowSize(rescore, rescorerQuery);
                QueryParser.queryWeight(rescoreQuery, rescorerQuery);
                QueryParser.rescoreQueryWeight(rescoreQuery, rescorerQuery);
                QueryParser.scoreMode(rescoreQuery, rescorerQuery);
                rescorerQueries.add(rescorerQuery);
            }
            this.nativeQueryBuilder.withRescorerQueries(rescorerQueries);
        }
    }

    private static RescorerQuery windowSize(Rescore rescore, RescorerQuery rescorerQuery) {
        Integer requestWindowSize = rescore.windowSize();
        if (requestWindowSize != null) {
            rescorerQuery.withWindowSize(requestWindowSize.intValue());
        }
        return rescorerQuery;
    }

    private static RescorerQuery queryWeight(RescoreQuery rescoreQuery, RescorerQuery rescorerQuery) {
        Double queryWeight = rescoreQuery.queryWeight();
        if (queryWeight != null) {
            rescorerQuery.withQueryWeight(queryWeight.floatValue());
        }
        return rescorerQuery;
    }

    private static RescorerQuery rescoreQueryWeight(RescoreQuery rescoreQuery, RescorerQuery rescorerQuery) {
        Double rescoreQueryWeight = rescoreQuery.rescoreQueryWeight();
        if (rescoreQueryWeight != null) {
            rescorerQuery.withRescoreQueryWeight(rescoreQueryWeight.floatValue());
        }
        return rescorerQuery;
    }

    private static RescorerQuery scoreMode(RescoreQuery rescoreQuery, RescorerQuery rescorerQuery) {
        ScoreMode requestScoreMode = rescoreQuery.scoreMode();
        RescorerQuery.ScoreMode queryScoreMode = RescorerQuery.ScoreMode.Default;
        if (requestScoreMode != null) {
            switch (requestScoreMode) {
                case Avg: {
                    queryScoreMode = RescorerQuery.ScoreMode.Avg;
                    break;
                }
                case Max: {
                    queryScoreMode = RescorerQuery.ScoreMode.Max;
                    break;
                }
                case Min: {
                    queryScoreMode = RescorerQuery.ScoreMode.Min;
                    break;
                }
                case Multiply: {
                    queryScoreMode = RescorerQuery.ScoreMode.Multiply;
                    break;
                }
                case Total: {
                    queryScoreMode = RescorerQuery.ScoreMode.Total;
                }
            }
        }
        rescorerQuery.withScoreMode(queryScoreMode);
        return rescorerQuery;
    }
}

