/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.springdata;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.semarchy.xdi.elasticsearch.common.Authentication;
import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.springdata.SpringDataDocumentModel;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.Query;

public class ElasticSearchConfiguration {
    public static final String HOST_PORT_SEPARATOR = ":";
    public static final String HTTP = "http";
    public static final String HTTPS = "http" + "s";
    private static final String CREDENTIAL_SEPARATOR = ":";
    private static final String API_KEY_PREFIX = "ApiKey ";
    private static final String CREDENTIAL_HEADER = "Authorization";
    private ElasticsearchOperations elasticsearchOperations;
    private ElasticsearchClient elasticsearchClient;

    public ElasticSearchConfiguration(String httpUrl, Authentication authentication, SSLContext sslContext) throws ElasticSearchException {
        try {
            URL url = new URL(httpUrl);
            String host = url.getHost();
            int port = url.getPort();
            String path = url.getPath();
            HashSet<Header> defaultHeaders = new HashSet<Header>();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            boolean useApiKey = ElasticSearchConfiguration.setAuthentication(authentication, defaultHeaders, (CredentialsProvider)credentialsProvider);
            HttpHost httpHost = new HttpHost(host, port, sslContext == null ? HTTP : HTTPS);
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchConfiguration.lambda$0(sslContext, authentication, useApiKey, defaultHeaders, (CredentialsProvider)credentialsProvider, arg_0));
            if (!path.isEmpty()) {
                restClientBuilder = restClientBuilder.setPathPrefix(path);
            }
            RestClient restClient = restClientBuilder.build();
            RestClientTransport elasticsearchTransport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            this.elasticsearchClient = new ElasticsearchClient((ElasticsearchTransport)elasticsearchTransport);
            this.elasticsearchOperations = new ElasticsearchTemplate(this.elasticsearchClient);
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    private static boolean setAuthentication(Authentication authentication, Set<Header> defaultHeaders, CredentialsProvider credentialsProvider) {
        boolean useApiKey;
        if (authentication != null) {
            useApiKey = authentication.useApiKey();
            String id = authentication.id();
            String secret = authentication.secret();
            if (useApiKey) {
                String credential = id + ":" + secret;
                String apiKeyAuth = Base64.getEncoder().encodeToString(credential.getBytes(StandardCharsets.UTF_8));
                String headerValue = API_KEY_PREFIX + apiKeyAuth;
                defaultHeaders.add((Header)new BasicHeader(CREDENTIAL_HEADER, headerValue));
            } else {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(id, secret));
            }
        } else {
            useApiKey = false;
        }
        return useApiKey;
    }

    private static HttpAsyncClientBuilder setHttpClientConfigCallback(HttpAsyncClientBuilder httpClientBuilder, SSLContext sslContext, Authentication authentication, boolean useApiKey, Set<Header> defaultHeaders, CredentialsProvider credentialsProvider) {
        if (sslContext != null) {
            httpClientBuilder = httpClientBuilder.setSSLContext(sslContext);
        }
        if (authentication != null) {
            httpClientBuilder = useApiKey ? httpClientBuilder.setDefaultHeaders(defaultHeaders) : httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        return httpClientBuilder;
    }

    public ElasticsearchClient getElasticsearchClient() {
        return this.elasticsearchClient;
    }

    public Iterable<SearchHit<SpringDataDocumentModel>> search(Query query, Map<String, Class<? extends SpringDataDocumentModel>> indexDocumentAssociation, Iterable<String> indexNames) {
        ArrayList results = null;
        if (query != null && indexDocumentAssociation != null && indexNames != null) {
            results = new ArrayList();
            for (String indexName : indexNames) {
                Class<? extends SpringDataDocumentModel> documentClass = indexDocumentAssociation.get(indexName);
                SearchHits searchHits = this.elasticsearchOperations.search(query, documentClass);
                results.addAll(searchHits.getSearchHits());
            }
        }
        return results;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$0(SSLContext sSLContext, Authentication authentication, boolean bl, Set set, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return ElasticSearchConfiguration.setHttpClientConfigCallback(httpClientBuilder, sSLContext, authentication, bl, set, credentialsProvider);
    }
}

