/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.elasticsearch.transformer;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.semarchy.xdi.elasticsearch.common.Authentication;
import com.semarchy.xdi.elasticsearch.common.ElasticSearchException;
import com.semarchy.xdi.elasticsearch.common.Operator;
import com.semarchy.xdi.elasticsearch.common.SslStore;
import com.semarchy.xdi.elasticsearch.integrator.ElasticSearchOutputStreamIntegratorV8;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElasticSearchOutputStreamTransformerV8
extends OutputStreamTransformer {
    public static final ClassLoader ES8_CLASS_LOADER = ElasticSearchOutputStreamTransformerV8.class.getClassLoader();
    private static final Logger logger = LogManager.getLogger(ElasticSearchOutputStreamTransformerV8.class);

    public void transform(InputStream inputStream, OutputStream outputStream) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        try {
            try {
                currentThread.setContextClassLoader(ES8_CLASS_LOADER);
                String rawIndices = this.getProperty("indexes");
                String[] indices = rawIndices.split(",");
                String rawJsonSchema = this.getProperty("jsonSchema");
                String httpUrl = this.getProperty("httpUrl");
                String rawOperator = this.getProperty("operator");
                Operator operator = Operator.fromString(rawOperator);
                String rawQuery = this.getProperty("query");
                String authenticationMethod = this.getProperty("authenticationMethod");
                boolean useApiKey = "API Key".equals(authenticationMethod);
                String idMarkup = useApiKey ? "apiKeyId" : "httpUser";
                String secretMarkup = useApiKey ? "apiKeySecret" : "httpPassword";
                String id = this.getProperty(idMarkup);
                String secret = this.getProperty(secretMarkup);
                Authentication authentication = new Authentication(useApiKey, id, secret);
                String keystoreFilepath = this.getProperty("keystoreFilepath");
                String keystoreType = this.getProperty("keystoreType");
                String keystorePassword = this.getProperty("keystorePassword");
                SslStore.Store keyStore = new SslStore.Store(keystoreFilepath, keystoreType, keystorePassword);
                String truststoreFilepath = this.getProperty("truststoreFilepath");
                String truststoreType = this.getProperty("truststoreType");
                String truststorePassword = this.getProperty("truststorePassword");
                SslStore.Store trustStore = new SslStore.Store(truststoreFilepath, truststoreType, truststorePassword);
                boolean enableCertificateValidation = Boolean.parseBoolean(this.getProperty("enableCertificateValidation"));
                SslStore sslStore = keystoreFilepath.isEmpty() && keystoreType.isEmpty() && keystorePassword.isEmpty() && truststoreFilepath.isEmpty() && truststoreType.isEmpty() && truststorePassword.isEmpty() ? null : new SslStore(keyStore, trustStore, enableCertificateValidation);
                ElasticSearchOutputStreamIntegratorV8 elasticSearchOutputStreamIntegratorV8 = new ElasticSearchOutputStreamIntegratorV8(httpUrl, authentication, sslStore, indices);
                if (operator.isCrud()) {
                    elasticSearchOutputStreamIntegratorV8.integrateCrud(rawJsonSchema, operator, inputStream, outputStream);
                } else {
                    elasticSearchOutputStreamIntegratorV8.integrateSearch(rawJsonSchema, rawQuery, inputStream, outputStream);
                }
                Map<String, Long> statistics = elasticSearchOutputStreamIntegratorV8.getStatistics();
                OutputStreamTransformer.OutputStreamTransformerStatisticHandler statHandler = this.getStatisticHandler();
                for (Map.Entry<String, Long> statistic : statistics.entrySet()) {
                    statHandler.handle(statistic.getKey(), statistic.getValue().longValue());
                }
            }
            catch (ElasticSearchException e) {
                logger.error((Object)e);
                throw e;
            }
        }
        finally {
            currentThread.setContextClassLoader(currentClassLoader);
        }
    }
}

