/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.elasticsearch.action;

import com.indy.addons.elasticsearch.Messages;
import com.indy.addons.json.JSONReverser;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.runtime.json.JsonNode;
import com.semarchy.xdi.designer.core.SSLContextFactory;
import com.semarchy.xdi.designer.core.http.ApacheHttpClient;
import com.semarchy.xdi.designer.core.utils.EnvironmentVariableHelper;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdFactoryHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocAction
implements IExecute {
    private static final Logger logger = LogManager.getLogger(ReverseDocAction.class);

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        ReverseDocAction.reverse(node);
        return null;
    }

    public static void reverse(MdNode node) throws ExecuteException {
        ReverseDocAction.reverse(node, null);
    }

    private static void reverseType(MdNode index, MdNode originalIndex, String indexName, String typeName, String strUrl, String uuid, SSLContext sslContext) throws Exception {
        String reverseFrom;
        MdNode type = MdFactoryHelper.createMdNode((String)"com.stambia.elasticsearch.type");
        type.setSubstituteContainer((EObject)index);
        type.setName(indexName);
        if (originalIndex != null) {
            for (MdNode node : originalIndex.getNode()) {
                if (!node.getDefType().equals("com.stambia.elasticsearch.type")) continue;
                if (uuid != null) {
                    if (!node.getId().equals(uuid)) continue;
                    type.setName(node.getName());
                    break;
                }
                type.setName(node.getName());
                break;
            }
        }
        type.setAttribute("physicalName", typeName, false);
        String reverseSize = index.evaluate("ancestor-or-self::server/@reverseSize");
        if (reverseSize == null || reverseSize.isEmpty()) {
            reverseSize = "100";
        }
        if ((reverseFrom = index.evaluate("ancestor-or-self::server/@reverseFrom")) == null || reverseFrom.isEmpty()) {
            reverseFrom = "0";
        }
        type.setName(indexName);
        type.setAttribute("physicalName", "_doc", false);
        String url = strUrl + "/" + indexName + "/_search?size=" + reverseSize + "&from=" + reverseFrom;
        Credential credential = ReverseDocAction.getCredential(originalIndex);
        JSONReverser jr = new JSONReverser();
        jr.setParentNode(type);
        HttpClientResponseHandler handler = r -> {
            int i = 1;
            MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
            exchattr.setName("index");
            type.getNode().add((Object)exchattr);
            exchattr.setAttribute("type", "string", false);
            exchattr.setPosition(BigInteger.valueOf(i++));
            exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
            exchattr.setName("type");
            type.getNode().add((Object)exchattr);
            exchattr.setAttribute("type", "string", false);
            exchattr.setPosition(BigInteger.valueOf(i++));
            exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
            exchattr.setName("id");
            type.getNode().add((Object)exchattr);
            exchattr.setAttribute("type", "string", false);
            exchattr.setPosition(BigInteger.valueOf(i++));
            exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
            exchattr.setName("parent");
            type.getNode().add((Object)exchattr);
            exchattr.setAttribute("type", "string", false);
            exchattr.setPosition(BigInteger.valueOf(i++));
            String charsetAsString = StandardCharsets.UTF_8.name();
            try {
                String contentType = r.getEntity().getContentType();
                Charset charset = ContentType.parseLenient((CharSequence)contentType).getCharset();
                if (charset != null) {
                    charsetAsString = charset.name();
                }
            }
            catch (Exception e) {
                logger.debug("Cannot parse content type", (Throwable)e);
            }
            try {
                MdNode doc = jr.reverse(r.getEntity().getContent(), charsetAsString);
                MdNode hitsO = doc.getNodeByName("com.stambia.json.object", "hits");
                MdNode hitsA = hitsO.getNodeByName("com.stambia.json.array", "hits");
                MdNode item = hitsA.getNodeByName("com.stambia.json.object", "item");
                if (item != null) {
                    MdNode source = item.getNodeByName("com.stambia.json.object", "_source");
                    source.setPosition(BigInteger.valueOf(i++));
                    source.setName("document");
                    type.getNode().add((Object)source);
                    index.getNode().add((Object)type);
                }
                exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
                exchattr.setName("version");
                type.getNode().add((Object)exchattr);
                exchattr.setAttribute("type", "number", false);
                exchattr.setPosition(BigInteger.valueOf(i++));
                exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
                exchattr.setName("found");
                type.getNode().add((Object)exchattr);
                exchattr.setAttribute("type", "boolean", false);
                exchattr.setPosition(BigInteger.valueOf(i++));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
            exchattr.setName("created");
            type.getNode().add((Object)exchattr);
            exchattr.setAttribute("type", "boolean", false);
            exchattr.setPosition(BigInteger.valueOf(i));
            return null;
        };
        ReverseDocAction.httpGet(url, credential, sslContext, handler);
    }

    private static <T> T httpGet(String url, Credential credential, SSLContext sslContext, HttpClientResponseHandler<T> responseHandler) throws IOException {
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        Credentials credentials = null;
        if (credential.useApiKey) {
            String encoded = DatatypeConverter.printBase64Binary((byte[])(credential.id + ":" + credential.secret).getBytes());
            headers.put("Authorization", (CallSite)((Object)("ApiKey " + encoded)));
        } else {
            credentials = ApacheHttpClient.createBasicAuthCredentials((String)credential.id, (char[])credential.secret.toCharArray());
        }
        ApacheHttpClient client = ApacheHttpClient.build((ApacheHttpClient.SslConfig)new ApacheHttpClient.SslConfig(sslContext));
        return (T)client.get(url, Collections.emptyMap(), headers, credentials, credentials != null, responseHandler);
    }

    public static List<MdNode> getReversedNodes(RelevantNodes relevant, String data, SSLContext sslContext) throws ExecuteException {
        try {
            MdNode doc = relevant.getDocNode();
            MdNode index = relevant.getIndexNode();
            MdNode node = relevant.getCurrentNode();
            String urlStr = node.evaluate("ancestor-or-self::*/@httpUrl");
            if (urlStr == null || urlStr.isEmpty()) {
                throw new ExecuteException(Messages.ReverseDocAction_58);
            }
            HttpClientResponseHandler handler = r -> {
                try {
                    String charsetAsString = StandardCharsets.UTF_8.name();
                    try {
                        String contentType = r.getEntity().getContentType();
                        Charset charset = ContentType.parseLenient((CharSequence)contentType).getCharset();
                        if (charset != null) {
                            charsetAsString = charset.name();
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Cannot parse content type", (Throwable)e);
                    }
                    JsonNode jsnode = JsonNode.parse((InputStream)r.getEntity().getContent(), (String)charsetAsString);
                    ArrayList<MdNode> nodes = new ArrayList<MdNode>();
                    HashSet<String> docTypeAlreadyDone = new HashSet<String>();
                    HashMap<String, ArrayList<String>> aliasesMap = new HashMap<String, ArrayList<String>>();
                    if (jsnode.isObject()) {
                        for (String key : jsnode.keys()) {
                            JsonNode mappings;
                            JsonNode currentIndex;
                            String indexName;
                            MdNode nodeIndex = null;
                            JsonNode currentNode = jsnode.get(key);
                            HashSet aliases = new HashSet();
                            JsonNode currentAliases = currentNode.get("aliases");
                            if (currentAliases != null && currentAliases.isObject()) {
                                aliases.addAll(currentAliases.keys());
                            }
                            String string2 = indexName = index != null ? index.evaluate("if (@physicalName!='') then @physicalName else @name") : "__No__Index__";
                            if (index == null || aliases.contains(indexName) || indexName.equals(key)) {
                                nodeIndex = MdFactoryHelper.createMdNode((String)"com.stambia.elasticsearch.index");
                                nodeIndex.setSubstituteContainer((EObject)node);
                                nodeIndex.setName(index.getName());
                                nodeIndex.setAttribute("physicalName", indexName, false);
                                if (aliases.contains(indexName)) {
                                    ArrayList<String> list = (ArrayList<String>)aliasesMap.get(indexName);
                                    if (list == null) {
                                        list = new ArrayList<String>();
                                        aliasesMap.put(indexName, list);
                                    }
                                    list.add(key);
                                }
                                nodes.add(nodeIndex);
                            }
                            if (nodeIndex == null || !(currentIndex = jsnode.get(key)).isObject() || !(mappings = currentIndex.get("mappings")).isObject()) continue;
                            for (String keyType : mappings.keys()) {
                                if (docTypeAlreadyDone.contains(keyType)) continue;
                                String docName = doc != null ? doc.evaluate("if (@physicalName!='') then @physicalName else @name") : "__No__DOC__";
                                ReverseDocAction.reverseType(nodeIndex, index, key, Messages.ReverseDocAction_1, urlStr, doc != null ? doc.getId() : null, sslContext);
                                docTypeAlreadyDone.add(docName);
                            }
                        }
                        if (!nodes.isEmpty() && !aliasesMap.isEmpty()) {
                            for (MdNode ___node : nodes) {
                                List list = (List)aliasesMap.get(___node.getName());
                                if (list == null) continue;
                                ReverseDocAction.addUnboudedStringAttribute(___node, "indexes", list);
                            }
                        }
                    }
                    return nodes;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            return (List)ReverseDocAction.httpGet(urlStr + "/_all", ReverseDocAction.getCredential(node), sslContext, handler);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    protected static Credential getCredential(MdNode node) throws ExecuteException {
        Credential credential = new Credential();
        try {
            String authenticationMethod = node.evaluate("ancestor-or-self::server/@authenticationMethod");
            credential.useApiKey = "API Key".equals(authenticationMethod);
            String idMarkup = credential.useApiKey ? "apiKeyId" : "httpUser";
            credential.id = node.evaluate("ancestor-or-self::server/@" + idMarkup);
            String secretMarkup = credential.useApiKey ? "apiKeySecret" : "httpPassword";
            String encryptedstorePassword = node.evaluate("ancestor-or-self::server/@" + secretMarkup);
            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            credential.secret = semaphoreManager.getStringAsciiInfo(encryptedstorePassword);
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
        return credential;
    }

    public static void reverse(MdNode node, String data) throws ExecuteException {
        try {
            MdNode doc;
            Object object = doc = node.getDefType().contains("type") ? node : null;
            Object index = doc != null ? (MdNode)doc.eContainer() : (node.getDefType().contains("index") ? node : null);
            MdNode server = index != null ? (MdNode)index.eContainer() : node;
            RelevantNodes relevant = new RelevantNodes(doc, (MdNode)index, server, node);
            SSLContext sslContext = ReverseDocAction.getSslContext(server);
            List<MdNode> nodes = ReverseDocAction.getReversedNodes(relevant, data, sslContext);
            MdNode newlyReversedNode = null;
            MdNode rootCandidateNode = nodes.get(0);
            if (rootCandidateNode.getName().equals(node.getName()) && rootCandidateNode.getDefType().equals(node.getDefType()) && "com.stambia.elasticsearch.index".equals(node.getDefType())) {
                newlyReversedNode = rootCandidateNode;
            } else {
                for (MdNode candidateNode : rootCandidateNode.getNode()) {
                    if (!candidateNode.getName().equals(node.getName()) || !candidateNode.getDefType().equals(node.getDefType()) || !"com.stambia.elasticsearch.type".equals(node.getDefType())) continue;
                    newlyReversedNode = candidateNode;
                    break;
                }
            }
            HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
            reverseNodes.put(newlyReversedNode, node);
            nodes.get(0).getDefType();
            nodes.get(0).getNode();
            IncrementalReverser ir = new IncrementalReverser((EObject)server, reverseNodes, Collections.emptyList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    private static void addUnboudedStringAttribute(MdNode node, String code, List<String> values) {
        Attribute attr = MdFactoryHelper.createAttribute((String)(node.getDefType() + "." + code));
        node.getAttribute().add((Object)attr);
        attr.getValues().addAll(values);
    }

    protected static SSLContext getSslContext(MdNode server) throws ExecuteException {
        try {
            String[] keyStore = ReverseDocAction.getSingleStore(server, "keystore");
            String[] trustStore = ReverseDocAction.getSingleStore(server, "truststore");
            String rawEnableCertificateValidation = server.evaluate("@enableCertificateValidation");
            boolean enableCertificateValidation = Boolean.parseBoolean(rawEnableCertificateValidation);
            return SSLContextFactory.createSSLContext((SSLContextFactory.SSLContextParameters)new SSLContextFactory.SSLContextParameters(null, keyStore[1], keyStore[0], keyStore[2] != null ? keyStore[2].toCharArray() : null, trustStore[1], trustStore[0], trustStore[2] != null ? trustStore[2].toCharArray() : null, null, enableCertificateValidation));
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    private static String[] getSingleStore(MdNode server, String storeName) throws ExecuteException {
        try {
            Attribute storeAttribute = server.getAttributeByShortCode(storeName);
            if (storeAttribute != null) {
                MdNode storeNode = (MdNode)storeAttribute.getRef();
                String rawStoreFilepath = storeNode.getAttributeValueByShortCode("filePath");
                String resolvedStoreFilepath = EnvironmentVariableHelper.resolveEnvironmentVariables((String)rawStoreFilepath, (EnvironmentVariableHelper.Mode)EnvironmentVariableHelper.Mode.MdModel);
                String storeType = storeNode.getAttributeValueByShortCode("type");
                String encryptedstorePassword = storeNode.getAttributeValueByShortCode("password");
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                String clearstorePassword = semaphoreManager.getStringAsciiInfo(encryptedstorePassword);
                return new String[]{resolvedStoreFilepath, storeType, clearstorePassword};
            }
            return new String[3];
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    protected static class Credential {
        boolean useApiKey;
        String id;
        String secret;

        protected Credential() {
        }
    }

    public static class RelevantNodes {
        private MdNode docNode;
        private MdNode indexNode;
        private MdNode serverNode;
        private MdNode currentNode;

        public RelevantNodes(MdNode docNode, MdNode indexNode, MdNode serverNode, MdNode currentNode) {
            this.docNode = docNode;
            this.indexNode = indexNode;
            this.serverNode = serverNode;
            this.currentNode = currentNode;
        }

        public MdNode getDocNode() {
            return this.docNode;
        }

        public MdNode getIndexNode() {
            return this.indexNode;
        }

        public MdNode getServerNode() {
            return this.serverNode;
        }

        public MdNode getCurrentNode() {
            return this.currentNode;
        }
    }
}

