/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.snowflake.reverse;

import com.indy.addons.json.composite.JSonReverseComposite;
import com.indy.addons.snowflake.reverse.Messages;
import com.indy.md.ui.editor.ui.XPathAction;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.Version;
import com.stambia.md.custom.Util;
import com.stambia.tech.XpathExpression;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.log.LogService;

class JsonToSchemaConverter {
    private static final String XPATH_JSON_DATA_TO_SCHEMA = "TO_JSON_SCHEMA";
    private static final String DEFTYPE_JSON_SCHEMA = "com.stambia.json.schema";
    private static final String DEFTYPE_JSON_ROOT_OBJECT = "com.stambia.json.rootObject";
    private static final String JSON_TECH_UUID = "UUID_TECH_JSON1";
    private static final String TEMPORARY_MD_PATH = "global/__reverseJsonStructure.md";

    JsonToSchemaConverter() {
    }

    public String convertJsonDataToSchema() throws IOException {
        Resource resource = null;
        try {
            MdNode dummyRoot = this.createDummyJsonMD();
            resource = dummyRoot.eResource();
            JsonReverseDialog dialog = new JsonReverseDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dummyRoot);
            if (dialog.open() == 0) {
                dummyRoot = dialog.rootNode;
                String string = dialog.res;
                return string;
            }
        }
        finally {
            try {
                if (resource != null) {
                    resource.delete(new HashMap());
                }
            }
            catch (IOException e) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(this.getClass()).error(Messages.JsonToSchemaConverter_4);
            }
        }
        return null;
    }

    private MdNode createDummyJsonMD() throws IOException {
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)MdPackage.eINSTANCE);
        EReference eStructuralFeature = MdPackage.eINSTANCE.getDocumentRoot_Node();
        DocumentRoot rootObject = (DocumentRoot)MdFactory.eINSTANCE.create(eClass);
        rootObject.eSet((EStructuralFeature)eStructuralFeature, (Object)EcoreUtil.create((EClass)((EClass)eStructuralFeature.getEType())));
        rootObject.getNode().setInternalVersion(Version.V100);
        rootObject.getNode().setDefType(DEFTYPE_JSON_SCHEMA);
        AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)proxy).eSetProxyURI(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(JSON_TECH_UUID).appendFragment(String.format("%s?fileId=%s?", JSON_TECH_UUID, JSON_TECH_UUID)));
        rootObject.getNode().setRef((EObject)proxy);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter());
        URI fileURI = URI.createPlatformResourceURI((String)TEMPORARY_MD_PATH, (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)rootObject);
        resource.save(new HashMap());
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        domain.getResourceSet().setURIConverter((URIConverter)new InternalResourceURIConverter());
        resource = domain.getResourceSet().getResource(resource.getURI(), true);
        MdNode main = MdFactory.eINSTANCE.createMdNode();
        main.setDefType(DEFTYPE_JSON_ROOT_OBJECT);
        domain.getCommandStack().execute((Command)new AddCommand((EditingDomain)domain, (EObject)((DocumentRoot)resource.getContents().get(0)).getNode(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)main));
        return main;
    }

    class JsonReverseDialog
    extends Dialog {
        JSonReverseComposite composite;
        Text jsonStructure;
        MdNode rootNode;
        String res;

        protected JsonReverseDialog(Shell parentShell, MdNode rootNode) {
            super(parentShell);
            this.rootNode = rootNode;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }

        protected Control createDialogArea(Composite parent) {
            this.composite = new JSonReverseComposite(parent, 0){

                protected void createFooter(Composite composite) {
                    JsonReverseDialog.this.jsonStructure = new Text(composite, 2624);
                    JsonReverseDialog.this.jsonStructure.setEditable(false);
                    GridData gd = new GridData(4, 1, true, true);
                    JsonReverseDialog.this.jsonStructure.setLayoutData((Object)gd);
                    gd.heightHint = 200;
                }

                public boolean isComplete() {
                    return this.jSonReverseNode != null;
                }

                public void handleMessage(String message) {
                    try {
                        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)JsonReverseDialog.this.rootNode);
                        CompoundCommand cc = new CompoundCommand();
                        cc.append((Command)new AddCommand((EditingDomain)domain, JsonReverseDialog.this.rootNode.eContainer(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)JsonReverseDialog.this.composite.jSonReverseNode));
                        cc.append((Command)new RemoveCommand((EditingDomain)domain, JsonReverseDialog.this.rootNode.eContainer(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)JsonReverseDialog.this.rootNode));
                        domain.getCommandStack().execute((Command)cc);
                        JsonReverseDialog.this.rootNode = JsonReverseDialog.this.composite.jSonReverseNode;
                        JsonReverseDialog.this.rootNode.eResource().eSetDeliver(false);
                        JsonReverseDialog.this.rootNode.eResource().save(new HashMap());
                        JsonReverseDialog.this.rootNode.eResource().eSetDeliver(true);
                        XpathExpression expr = Util.findXpathExpressions((Configuration)JsonReverseDialog.this.rootNode, (String)JsonToSchemaConverter.XPATH_JSON_DATA_TO_SCHEMA);
                        XPathAction action = new XPathAction(JsonReverseDialog.this.rootNode, expr, XPathAction.transformName((String)JsonToSchemaConverter.XPATH_JSON_DATA_TO_SCHEMA), XPathAction.transformName((String)JsonToSchemaConverter.XPATH_JSON_DATA_TO_SCHEMA));
                        action.run();
                        JsonReverseDialog.this.res = action.getLastResult();
                        JsonReverseDialog.this.jsonStructure.setText(JsonReverseDialog.this.res);
                    }
                    catch (Exception e) {
                        JsonReverseDialog.this.res = null;
                        JsonReverseDialog.this.jsonStructure.setText(e.getMessage());
                    }
                }

                public void handleIsComplete(boolean complete) {
                    JsonReverseDialog.this.getButton(0).setEnabled(complete);
                }

                public void handleErrorMessage(String message) {
                    JsonReverseDialog.this.getButton(0).setEnabled(message == null);
                    JsonReverseDialog.this.jsonStructure.setText(message == null ? "" : message);
                }

                public MdNode getRoot() {
                    return JsonReverseDialog.this.rootNode;
                }
            };
            this.composite.setLayoutData((Object)new GridData(1808));
            return this.composite;
        }
    }
}

