/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.kafka;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.UtilsService;
import com.semarchy.xdi.component.kafka.Constants;
import com.semarchy.xdi.component.kafka.KafkaAdminClient;
import com.semarchy.xdi.component.kafka.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.logging.log4j.LogManager;

public class KafkaResetOffsetsActionCode
extends ActionCodeTypeI {
    String resetMode;
    Long shiftBy;
    String partitionsIdsList;
    String serverProperties;
    String topicNamesList;
    String consumerGroupName;
    List<Integer> partitionsIds;
    List<String> topicNames;
    UnaryOperator<String> resolveExtValue = t -> {
        try {
            return new SecretValueImpl(t, arg_0 -> ((ISecretService)UtilsService.getSecretService()).decryptString(arg_0), arg_0 -> ((ISecretService)UtilsService.getSecretService()).encryptString(arg_0)).resolveStringSecretValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    };

    public KafkaResetOffsetsActionCode() {
        super(KafkaResetOffsetsActionCode.class.getName(), true);
        this.actionClassName = KafkaResetOffsetsActionCode.class.getName();
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        this.resetMode = this.getLocalStringParameter("RESET_MODE", "To Earliest");
        this.shiftBy = this.getLocalLongParameter("SHIFT_BY", Constants.SHIFT_BY_DEFAULT);
        this.partitionsIdsList = this.getLocalStringParameter("PARTITION_ID", "");
        this.consumerGroupName = this.getLocalStringParameter("CONSUMER_GROUP_NAME", "");
        this.topicNamesList = this.getLocalStringParameter("TOPIC_NAME", "");
        this.serverProperties = (String)this.resolveExtValue.apply(this.getLocalStringParameter("SERVER_PROPERTIES", "").replace("\\", "\\\\"));
        if (this.consumerGroupName.isEmpty()) {
            throw new EngineExceptionI(Messages.getString("KafkaResetOffsetsAction.0"));
        }
        this.partitionsIds = new ArrayList<Integer>();
        if (!this.partitionsIdsList.equals("")) {
            this.partitionsIds = Arrays.asList(this.partitionsIdsList.split(",")).stream().map(s -> Integer.valueOf(s.strip())).collect(Collectors.toList());
        }
        if (!this.topicNamesList.equals("")) {
            this.topicNames = Arrays.asList(this.topicNamesList.split(",")).stream().map(String::strip).collect(Collectors.toList());
        }
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(this.serverProperties.getBytes()));
        }
        catch (IOException e) {
            this.logger.warn(Messages.getString("KafkaResetOffsetsAction.2"), (Throwable)e);
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (KafkaAdminClient client = new KafkaAdminClient(props);){
            Map<TopicPartition, OffsetAndMetadata> updatedOffsets = client.resetOffsets(this.consumerGroupName, this.topicNames, this.partitionsIds, this.resetMode, this.shiftBy);
            this.publishVariable("UPDATED_OFFSETS", updatedOffsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OffsetAndMetadata)entry.getValue()).offset())).toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return 0;
    }
}

