/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.kafka.producer.impl;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.stambia.kafka.producer.KafkaProducerMetaData;
import com.stambia.kafka.producer.KafkaTopicExchange;
import com.stambia.kafka.producer.impl.KafkaTopicInvokerImpl;
import java.util.HashMap;
import java.util.Map;

public class KafkaTopicProducerImpl
implements JavaRealObjectHandler<KafkaTopicExchange, KafkaProducerMetaData> {
    private KafkaTopicInvokerImpl webServiceInvoker;

    public void init(KafkaProducerMetaData metadata, JavaObjectHandler.InitHandler iHandler) throws Exception {
        this.webServiceInvoker = new KafkaTopicInvokerImpl(metadata);
        for (Map.Entry<String, String> entry : this.getContentPathSerializers(metadata).entrySet()) {
            iHandler.addProperty("addContentPathSerializer", entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getContentPathSerializers(KafkaProducerMetaData metadata) {
        HashMap<String, String> map = new HashMap<String, String>();
        String currentPath = "root/e";
        if (metadata.topic.key != null && metadata.topic.key.contentType != null) {
            map.put(currentPath + "/keyField", "json");
        }
        if (metadata.topic.value != null && metadata.topic.value.contentType != null) {
            map.put(currentPath + "/valueField", "json");
        }
        return map;
    }

    public void handleObject(KafkaTopicExchange exchange, KafkaProducerMetaData metadata, OutputStreamTransformer.StatisticHandler sh) throws Exception {
        String str = this.webServiceInvoker.handleRequest(metadata, exchange);
        sh.handle("KAFKA_PRODUCE", 1L);
    }

    public int batchSize() {
        return 1;
    }

    public void close() throws Exception {
        this.webServiceInvoker.close();
    }
}

