/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.delivery.repository.google.cloud.storage.impl;

import com.google.api.gax.paging.Page;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.delivery.repository.google.cloud.storage.impl.GoogleCloudStorage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class GoogleCloudStorageRepository
implements IDeliveryRepositoryPlugin {
    private final GoogleCloudStorage store;
    protected File cacheFolder = null;
    protected final Map<String, DeliveryInfoWrapper> deliveriesInfo = Collections.synchronizedMap(new HashMap());
    protected static final String FILE_EXTENSION = ".deliv";
    protected static final String PATH_SEPARATOR = "/";
    private long lastRefreshTime = 0L;

    public GoogleCloudStorageRepository(IPluginFactory.IPluginConfiguration configuration) throws Exception {
        this.store = this.createStorage(configuration);
    }

    public File getDeliveryContent(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        if (deliveryInfo.getFile() == null) {
            String deliveryName = deliveryInfo.getName();
            deliveryInfo = this.getDeliveryInfo(deliveryName);
        }
        return deliveryInfo.getFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getFile(Blob b) throws IOException {
        String fileName = b.getName();
        File f = new File(this.cacheFolder, fileName);
        f.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(Channels.newInputStream((ReadableByteChannel)b.reader(new Blob.BlobSourceOption[0])));
            try {
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                if (is == null) return f;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return f;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        if (refresh && System.currentTimeMillis() - this.lastRefreshTime > this.store.getRefreshDelay()) {
            this.lastRefreshTime = System.currentTimeMillis();
            HashMap<Object, DeliveryInfoWrapper> currInfos = new HashMap<Object, DeliveryInfoWrapper>();
            Page<Blob> blobs = this.store.getList();
            for (Blob b : blobs.iterateAll()) {
                if (!b.getName().endsWith(FILE_EXTENSION)) continue;
                String deliveryName = this.getDeliveryNameFromBlob(b);
                IDeliveryRepositoryPlugin.DeliveryInfo info = this.createDeliveryInfo(b);
                currInfos.put(deliveryName, new DeliveryInfoWrapper(info, b.getUpdateTimeOffsetDateTime().toInstant().toEpochMilli()));
            }
            ImmutableSet keys = Sets.difference(this.deliveriesInfo.keySet(), currInfos.keySet()).immutableCopy();
            for (String key : keys) {
                this.deliveriesInfo.remove(key);
            }
            Map<String, DeliveryInfoWrapper> map = this.deliveriesInfo;
            synchronized (map) {
                for (Map.Entry entry : currInfos.entrySet()) {
                    String key = (String)entry.getKey();
                    DeliveryInfoWrapper currInfo = (DeliveryInfoWrapper)currInfos.get(key);
                    DeliveryInfoWrapper oldInfo = this.deliveriesInfo.get(key);
                    if (oldInfo != null && oldInfo.getLastUpdateTimestamp().equals(currInfo.getLastUpdateTimestamp())) continue;
                    this.deliveriesInfo.put(key, currInfo);
                }
            }
        }
        return this.getDeliveriesInfoUnwrapped(this.deliveriesInfo);
    }

    private String getDeliveryNameFromBlob(Blob b) {
        return b.getName().substring(this.store.getPath().length(), b.getName().lastIndexOf("."));
    }

    private Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfoUnwrapped(Map<String, DeliveryInfoWrapper> infos) {
        return infos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DeliveryInfoWrapper)e.getValue()).getInfo()));
    }

    private IDeliveryRepositoryPlugin.DeliveryInfo createDeliveryInfo(Blob b) throws IOException {
        IDeliveryRepositoryPlugin.DeliveryInfo info = new IDeliveryRepositoryPlugin.DeliveryInfo();
        int idx = b.getGeneratedId().lastIndexOf(PATH_SEPARATOR);
        String id = b.getGeneratedId().substring(idx + 1);
        String deliveryName = this.getDeliveryNameFromBlob(b);
        info.setId(id);
        info.setName(deliveryName);
        info.setFile(this.getFile(b));
        return info;
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        this.getDeliveriesInfo(true);
        DeliveryInfoWrapper wrapper = this.deliveriesInfo.get(deliveryName);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getInfo();
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String deliveryName) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo info = null;
        StringBuilder blobFileName = new StringBuilder(deliveryName);
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            blobFileName.append(FILE_EXTENSION);
        }
        Blob b = this.store.createDelivery(blobFileName.toString(), inputStream);
        info = this.createDeliveryInfo(b);
        return info;
    }

    protected GoogleCloudStorage createStorage(IPluginFactory.IPluginConfiguration conf) throws IOException {
        return new GoogleCloudStorage(conf, GoogleCredentials.getApplicationDefault());
    }

    public void removeDelivery(String deliveryName) throws Exception {
        StringBuilder sb = new StringBuilder(deliveryName);
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            sb.append(FILE_EXTENSION);
        }
        this.store.removeDelivery(sb.toString());
        this.deliveriesInfo.remove(deliveryName);
    }

    public IDeliveryRepositoryInfo getInfos() {
        return this.store;
    }

    public void setCacheFolder(File cacheFolder) {
        this.cacheFolder = cacheFolder;
    }

    private class DeliveryInfoWrapper {
        private IDeliveryRepositoryPlugin.DeliveryInfo info;
        private long lastUpdateTimestamp;

        public DeliveryInfoWrapper(IDeliveryRepositoryPlugin.DeliveryInfo info, long timestamp) {
            this.info = info;
            this.lastUpdateTimestamp = timestamp;
        }

        public IDeliveryRepositoryPlugin.DeliveryInfo getInfo() {
            return this.info;
        }

        public Long getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }
    }
}

