/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.file.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.indy.addons.file.avro.Messages;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdFactoryHelper;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.json.JSONArray;
import org.json.JSONObject;

public class AVROReverser {
    private static final String EXPLICIT_NAMESPACE = "explicit_namespace";
    private static final String IMPLICIT_NAMESPACE = "implicit_namespace";
    private Schema avroRootSchema;
    private MdNode stambiaBaseNode;
    private MdNode schemasNode;
    private Map<String, MdNode> referenceableNodes = new HashMap<String, MdNode>();
    private Map<String, MdNode> referencedNodes = new HashMap<String, MdNode>();
    private Map<String, Integer> recursivityCounter = new HashMap<String, Integer>();
    private int maxRecursionLevel = 5;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public AVROReverser(Schema rootSchema, MdNode stambiaBaseNode) {
        this.avroRootSchema = rootSchema;
        this.stambiaBaseNode = stambiaBaseNode;
        try {
            String rawMaxRecursionLevel = stambiaBaseNode.evaluate("@maxRecursionLevel");
            this.maxRecursionLevel = Integer.valueOf(rawMaxRecursionLevel);
        }
        catch (XPathExpressionException e) {
            this.logger.warn("Cannot read @maxRecursionLevel attribute, using default value", (Throwable)e);
        }
    }

    protected MdNode createMdNode(String type) {
        return MdFactoryHelper.createMdNode((String)type);
    }

    public MdNode reverse() throws XPathExpressionException, ExecuteException {
        this.schemasNode = this.createMdNode("com.stambia.avro.schemas");
        this.schemasNode.setSubstituteContainer(this.stambiaBaseNode.eContainer());
        this.reverse(this.schemasNode, this.avroRootSchema, null, BigInteger.valueOf(0L));
        return this.schemasNode;
    }

    private void reverse(MdNode stambiaParentNode, Schema avroSchema, String parentNamespace, BigInteger positionInParentSchema) throws XPathExpressionException, ExecuteException {
        block37: {
            try {
                if (avroSchema == null) break block37;
                Map<String, String> namespaceMap = null;
                Map objectProperties = avroSchema.getObjectProps();
                Schema.Type avroSchemaType = avroSchema.getType();
                String avroSchemaName = avroSchema.getName();
                switch (avroSchemaType) {
                    case RECORD: {
                        boolean recordRecursivtyLevelOk;
                        String recordFullName = avroSchema.getFullName();
                        boolean bl = recordRecursivtyLevelOk = this.recursivityCounter.getOrDefault(recordFullName, 0) < this.maxRecursionLevel;
                        if (recordRecursivtyLevelOk) {
                            int recordRecursivtyLevel = this.recursivityCounter.getOrDefault(recordFullName, 0);
                            this.recursivityCounter.put(recordFullName, ++recordRecursivtyLevel);
                            MdNode stambiaRecord = this.createNamedNode(stambiaParentNode, avroSchemaName, "com.stambia.avro.record");
                            this.reverseReference(avroSchema, stambiaRecord);
                            namespaceMap = this.getImplicitAndExplicitNamespace(parentNamespace, avroSchema);
                            AVROReverser.setAttribute(stambiaRecord, "namespace", namespaceMap.get(IMPLICIT_NAMESPACE));
                            AVROReverser.setAttribute(stambiaRecord, "doc", avroSchema.getDoc());
                            stambiaRecord.setPosition(positionInParentSchema);
                            Set recordAliases = avroSchema.getAliases();
                            if (recordAliases != null) {
                                for (String recordAlias : recordAliases) {
                                    AVROReverser.setAttribute(stambiaRecord, "aliases", recordAlias);
                                }
                            }
                            this.createObjectProperties(stambiaRecord, avroSchema.getObjectProps());
                            List avroFields = avroSchema.getFields();
                            if (avroFields != null) {
                                for (Schema.Field avroField : avroFields) {
                                    Set fieldAliases;
                                    MdNode stambiaField = this.createNamedNode(stambiaRecord, avroField.name(), "com.stambia.avro.field");
                                    stambiaField.setPosition(BigInteger.valueOf(avroFields.indexOf(avroField)));
                                    this.reverse(stambiaField, avroField.schema(), namespaceMap.get(EXPLICIT_NAMESPACE), BigInteger.valueOf(0L));
                                    AVROReverser.setAttribute(stambiaField, "doc", avroField.doc());
                                    Object fieldDefault = avroField.defaultVal();
                                    if (fieldDefault != null) {
                                        String stringFieldDefault = null;
                                        if (fieldDefault instanceof Collection) {
                                            Collection collection = (Collection)fieldDefault;
                                            JSONArray jsonArray = new JSONArray(collection);
                                            stringFieldDefault = jsonArray.toString();
                                        } else if (fieldDefault instanceof Map) {
                                            Map map = (Map)fieldDefault;
                                            JSONObject jsonObject = new JSONObject(map);
                                            stringFieldDefault = jsonObject.toString();
                                        } else {
                                            stringFieldDefault = fieldDefault instanceof JsonProperties.Null ? "null" : fieldDefault.toString();
                                        }
                                        AVROReverser.setAttribute(stambiaField, "default", stringFieldDefault);
                                    }
                                    if ((fieldAliases = avroField.aliases()) != null) {
                                        for (String fieldAlias : fieldAliases) {
                                            AVROReverser.setAttribute(stambiaField, "aliases", fieldAlias);
                                        }
                                    }
                                    this.createObjectProperties(stambiaField, avroField.getObjectProps());
                                }
                            }
                            this.recursivityCounter.put(recordFullName, --recordRecursivtyLevel);
                        }
                        break;
                    }
                    case ARRAY: {
                        MdNode stambiaArray = this.createUnamedNode(stambiaParentNode, "com.stambia.avro.array");
                        MdNode stambiaIndex = this.createUnamedNode(stambiaArray, "com.stambia.avro.index");
                        namespaceMap = this.getImplicitAndExplicitNamespace(parentNamespace, avroSchema);
                        this.reverse(stambiaIndex, avroSchema.getElementType(), namespaceMap.get(EXPLICIT_NAMESPACE), BigInteger.valueOf(0L));
                        this.createObjectProperties(stambiaArray, avroSchema.getObjectProps());
                        stambiaArray.setPosition(positionInParentSchema);
                        break;
                    }
                    case MAP: {
                        MdNode stambiaMap = this.createUnamedNode(stambiaParentNode, "com.stambia.avro.map");
                        MdNode stambiaKey = this.createUnamedNode(stambiaMap, "com.stambia.avro.mapkey");
                        namespaceMap = this.getImplicitAndExplicitNamespace(parentNamespace, avroSchema);
                        this.reverse(stambiaKey, avroSchema.getValueType(), namespaceMap.get(EXPLICIT_NAMESPACE), BigInteger.valueOf(0L));
                        this.createObjectProperties(stambiaMap, avroSchema.getObjectProps());
                        stambiaMap.setPosition(positionInParentSchema);
                        break;
                    }
                    case ENUM: {
                        List enumSymbols;
                        MdNode stambiaEnum = this.createNamedNode(stambiaParentNode, avroSchemaName, "com.stambia.avro.enum");
                        this.reverseReference(avroSchema, stambiaEnum);
                        namespaceMap = this.getImplicitAndExplicitNamespace(parentNamespace, avroSchema);
                        AVROReverser.setAttribute(stambiaEnum, "namespace", namespaceMap.get(IMPLICIT_NAMESPACE));
                        AVROReverser.setAttribute(stambiaEnum, "doc", avroSchema.getDoc());
                        String enumDefault = avroSchema.getEnumDefault();
                        AVROReverser.setAttribute(stambiaEnum, "default", enumDefault);
                        Set enumAliases = avroSchema.getAliases();
                        if (enumAliases != null) {
                            for (String enumAlias : enumAliases) {
                                AVROReverser.setAttribute(stambiaEnum, "aliases", enumAlias);
                            }
                        }
                        if ((enumSymbols = avroSchema.getEnumSymbols()) != null) {
                            for (String enumSymbol : enumSymbols) {
                                AVROReverser.setAttribute(stambiaEnum, "symbols", enumSymbol);
                            }
                        }
                        this.createObjectProperties(stambiaEnum, avroSchema.getObjectProps());
                        stambiaEnum.setPosition(positionInParentSchema);
                        break;
                    }
                    case FIXED: {
                        MdNode stambiaFixed = this.createNamedNode(stambiaParentNode, avroSchemaName, "com.stambia.avro.fixed");
                        this.reverseReference(avroSchema, stambiaFixed);
                        namespaceMap = this.getImplicitAndExplicitNamespace(parentNamespace, avroSchema);
                        AVROReverser.setAttribute(stambiaFixed, "namespace", namespaceMap.get(IMPLICIT_NAMESPACE));
                        AVROReverser.setAttribute(stambiaFixed, "doc", avroSchema.getDoc());
                        AVROReverser.setAttribute(stambiaFixed, "size", String.valueOf(avroSchema.getFixedSize()));
                        Set fixedAliases = avroSchema.getAliases();
                        if (fixedAliases != null) {
                            for (String fixedAlias : fixedAliases) {
                                AVROReverser.setAttribute(stambiaFixed, "aliases", fixedAlias);
                            }
                        }
                        this.createObjectProperties(stambiaFixed, avroSchema.getObjectProps());
                        stambiaFixed.setPosition(positionInParentSchema);
                        break;
                    }
                    case UNION: {
                        List unitedSchemas = avroSchema.getTypes();
                        for (Schema unitedSchema : unitedSchemas) {
                            namespaceMap = this.getImplicitAndExplicitNamespace(parentNamespace, avroSchema);
                            this.reverse(stambiaParentNode, unitedSchema, namespaceMap.get(EXPLICIT_NAMESPACE), BigInteger.valueOf(unitedSchemas.indexOf(unitedSchema)));
                        }
                        break;
                    }
                    case STRING: {
                        this.createPrimitive(stambiaParentNode, "string", objectProperties, positionInParentSchema);
                        break;
                    }
                    case BOOLEAN: {
                        this.createPrimitive(stambiaParentNode, "boolean", objectProperties, positionInParentSchema);
                        break;
                    }
                    case BYTES: {
                        this.createPrimitive(stambiaParentNode, "bytes", objectProperties, positionInParentSchema);
                        break;
                    }
                    case DOUBLE: {
                        this.createPrimitive(stambiaParentNode, "double", objectProperties, positionInParentSchema);
                        break;
                    }
                    case FLOAT: {
                        this.createPrimitive(stambiaParentNode, "float", objectProperties, positionInParentSchema);
                        break;
                    }
                    case INT: {
                        this.createPrimitive(stambiaParentNode, "int", objectProperties, positionInParentSchema);
                        break;
                    }
                    case LONG: {
                        this.createPrimitive(stambiaParentNode, "long", objectProperties, positionInParentSchema);
                        break;
                    }
                    case NULL: {
                        this.createPrimitive(stambiaParentNode, "null", objectProperties, positionInParentSchema);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new ExecuteException(e);
            }
        }
    }

    private void createObjectProperties(MdNode parentNode, Map<String, Object> objectProps) throws JsonProcessingException {
        if (objectProps != null && !objectProps.isEmpty()) {
            HashMap<String, String> jsonStringObjectProperties = new HashMap<String, String>();
            ObjectMapper mapper = new ObjectMapper();
            for (Map.Entry<String, Object> entry : objectProps.entrySet()) {
                jsonStringObjectProperties.put(mapper.writeValueAsString((Object)entry.getKey()), mapper.writeValueAsString(entry.getValue()));
            }
            AVROReverser.setAttributeMap(parentNode, "customAttributes", jsonStringObjectProperties);
        }
    }

    private void reverseReference(Schema avroSchema, MdNode complexRecord) {
        String recordFullname = avroSchema.getFullName();
        if (this.referenceableNodes.containsKey(recordFullname)) {
            MdNode referencableNode;
            if (!this.referencedNodes.containsKey(recordFullname)) {
                referencableNode = this.createNamedNode(this.schemasNode, recordFullname, "com.stambia.avro.referenceableType");
                MdNode referenceNode = this.referenceableNodes.get(recordFullname);
                referencableNode.setRefAttribute("type", (EObject)referenceNode, false);
                this.referencedNodes.put(recordFullname, referencableNode);
            }
            referencableNode = this.referencedNodes.get(recordFullname);
            complexRecord.setRefAttribute("typeReference", (EObject)referencableNode, false);
        } else {
            this.referenceableNodes.put(recordFullname, complexRecord);
        }
    }

    private Map<String, String> getImplicitAndExplicitNamespace(String parentNamespace, Schema avroSchema) {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        boolean isStructureElemnt = Schema.Type.RECORD.equals((Object)avroSchema.getType()) || Schema.Type.ENUM.equals((Object)avroSchema.getType()) || Schema.Type.FIXED.equals((Object)avroSchema.getType());
        String implicitNamespace = null;
        String explicitNamespace = null;
        try {
            implicitNamespace = avroSchema.getNamespace();
        }
        catch (Exception e) {
            namespaceMap.put(IMPLICIT_NAMESPACE, null);
            namespaceMap.put(EXPLICIT_NAMESPACE, parentNamespace);
            return namespaceMap;
        }
        if (implicitNamespace != null) {
            explicitNamespace = implicitNamespace;
            if (isStructureElemnt && implicitNamespace.equals(parentNamespace)) {
                implicitNamespace = null;
            }
        }
        namespaceMap.put(IMPLICIT_NAMESPACE, implicitNamespace);
        namespaceMap.put(EXPLICIT_NAMESPACE, explicitNamespace);
        return namespaceMap;
    }

    private MdNode createNamedNode(MdNode parent, String name, String stambiaTechAvroType) {
        MdNode node = this.createUnamedNode(parent, stambiaTechAvroType);
        node.setName(name);
        return node;
    }

    private MdNode createUnamedNode(MdNode parent, String stambiaTechAvroType) {
        MdNode node = this.createMdNode(stambiaTechAvroType);
        if (parent != null) {
            parent.getNode().add((Object)node);
        }
        return node;
    }

    private MdNode createPrimitive(MdNode parent, String primitiveTypeName, Map objectProperties, BigInteger positionInParentSchema) throws XPathExpressionException, JsonProcessingException {
        MdNode node = this.createMdNode("com.stambia.avro.primitiveRef");
        node.setPosition(positionInParentSchema);
        if (parent != null) {
            parent.getNode().add((Object)node);
        }
        if (this.stambiaBaseNode != null && primitiveTypeName != null) {
            String primitiveName = primitiveTypeName;
            String expression = "ancestor::product/primitive[@name='" + primitiveName + "']";
            MdNode primitive = (MdNode)this.stambiaBaseNode.evaluateMdNode(expression);
            if (primitive == null) {
                throw new RuntimeException(Messages.AVROReverser_unknownPrimitive);
            }
            AVROReverser.setRefAttribute(node, "typeRef", primitive);
            if (objectProperties != null && objectProperties.get("logicalType") != null) {
                String logicalType = (String)objectProperties.get("logicalType");
                expression = "ancestor::product/logicalType[@name='" + logicalType + "']";
                MdNode logic = (MdNode)this.stambiaBaseNode.evaluateMdNode(expression);
                if (logic == null) {
                    throw new RuntimeException("The logial type '" + logicalType + "' is unknown in avro product MD");
                }
                AVROReverser.setRefAttribute(node, "logicalTypeRef", logic);
                if (objectProperties.get("scale") != null) {
                    Integer scale = (Integer)objectProperties.get("scale");
                    AVROReverser.setAttribute(node, "scale", scale.toString());
                }
                if (objectProperties.get("precision") != null) {
                    Integer precision = (Integer)objectProperties.get("precision");
                    AVROReverser.setAttribute(node, "precision", precision.toString());
                }
            }
        }
        if (objectProperties != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(objectProperties);
            map.remove("type");
            map.remove("logicalType");
            map.remove("scale");
            map.remove("precision");
            this.createObjectProperties(node, map);
        }
        return node;
    }

    private static void setRefAttribute(MdNode node, String shortCode, MdNode ref) {
        if (node != null) {
            node.setRefAttribute(shortCode, (EObject)ref, false);
        }
    }

    private static void setAttribute(MdNode node, String shortCode, String value) {
        if (node != null) {
            node.setAttribute(shortCode, value, false);
        }
    }

    private static void setAttributeMap(MdNode node, String shortCode, Map value) {
        if (node != null && value != null) {
            node.setAttribute(shortCode, null, false);
            Attribute attr = node.getAttributeByShortCode(shortCode);
            attr.getValueEntry().putAll(value);
        }
    }
}

