/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.file.avro;

import com.indy.addons.file.avro.AVROReverser;
import com.indy.addons.file.avro.Messages;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ReverseAvscAction
implements IExecute {
    private static final String AVSC_MODE = "AVSC";
    private static final String AVRO_MODE = "AVRO";
    private static final Set<String> REFERENCE_TYPES = new HashSet<String>();

    static {
        REFERENCE_TYPES.add("com.stambia.avro.record");
        REFERENCE_TYPES.add("com.stambia.avro.fixed");
        REFERENCE_TYPES.add("com.stambia.avro.enum");
    }

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode inputStambiaRootNode = (MdNode)object;
        String reverseMode = params.getOrDefault("reverseMode", AVSC_MODE);
        ReverseAvscAction.reverse(inputStambiaRootNode, reverseMode);
        return null;
    }

    public static void reverse(MdNode stambiaRootNode, String reverseMode) throws ExecuteException {
        try {
            Schema avroSchema = null;
            switch (reverseMode) {
                case "AVSC": {
                    String avscPath = stambiaRootNode.evaluate("@avscReverseURL");
                    if (avscPath == null || avscPath.trim().isEmpty()) {
                        throw new RuntimeException("Please give path to an avro schema (*.AVSC)");
                    }
                    avroSchema = ReverseAvscAction.getSchemaFromAvsc(avscPath);
                    break;
                }
                case "AVRO": {
                    String avroPath = stambiaRootNode.evaluate("@avroReverseURL");
                    if (avroPath == null || avroPath.trim().isEmpty()) {
                        throw new RuntimeException(Messages.ReverseAvscAction_0);
                    }
                    avroSchema = ReverseAvscAction.getSchemaFromAvro(avroPath);
                    break;
                }
                default: {
                    throw new RuntimeException(Messages.ReverseAvscAction_10);
                }
            }
            ReverseAvscAction.reverse(stambiaRootNode, avroSchema);
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    static Schema getSchemaFromAvsc(String avscPath) throws IOException {
        URL url = new URL(avscPath);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = url.openStream();){
            Schema.Parser parser = new Schema.Parser();
            return parser.parse(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private static Schema getSchemaFromAvro(String avroPath) throws IOException {
        URL url = new URL(avroPath);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Schema schema;
            DataFileStream dataFileReader;
            InputStream is;
            block16: {
                block15: {
                    is = url.openStream();
                    dataFileReader = new DataFileStream(is, (DatumReader)new GenericDatumReader());
                    schema = dataFileReader.getSchema();
                    if (dataFileReader == null) break block15;
                    dataFileReader.close();
                }
                if (is == null) break block16;
                is.close();
            }
            return schema;
            {
                catch (Throwable throwable2) {
                    try {
                        if (dataFileReader != null) {
                            dataFileReader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void reverse(MdNode existingDesignerRootNode, Schema avroSchema) throws Exception {
        AvroRefResolver avroRefResolver = new AvroRefResolver(existingDesignerRootNode);
        AVROReverser reverser = new AVROReverser(avroSchema, existingDesignerRootNode);
        MdNode newStambiaRootNode = reverser.reverse();
        if (newStambiaRootNode != null) {
            ArrayList<MdNode> newNodesToMerge = new ArrayList<MdNode>();
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            for (MdNode n : newStambiaRootNode.getNode()) {
                n.setSubstituteContainer((EObject)existingDesignerRootNode);
                newNodesToMerge.add(n);
            }
            for (MdNode nodeToMerge : newNodesToMerge) {
                if (nodeToMerge == null) continue;
                reversedMap.put(nodeToMerge, existingDesignerRootNode.getNodeByName(nodeToMerge.getDefType(), nodeToMerge.getName()));
            }
            HashMap<String, Boolean> incrementalDelete = new HashMap<String, Boolean>();
            incrementalDelete.put("com.stambia.avro.primitiveRef", true);
            incrementalDelete.put("com.stambia.avro.complexTypeRef", true);
            incrementalDelete.put("com.stambia.avro.array", true);
            incrementalDelete.put("com.stambia.avro.index", true);
            incrementalDelete.put("com.stambia.avro.map", true);
            HashMap<String, RefReverseMode> nodeMatchingMap = new HashMap<String, RefReverseMode>();
            nodeMatchingMap.put("com.stambia.avro.primitiveRef", new RefReverseMode());
            nodeMatchingMap.put("com.stambia.avro.complexTypeRef", new RefReverseMode());
            nodeMatchingMap.put("com.stambia.avro.array", (RefReverseMode)IncrementalReverser.DefaulteverseMatchingStrategy.ByOrderAmongstSiblingWithSameLevel);
            nodeMatchingMap.put("com.stambia.avro.map", (RefReverseMode)IncrementalReverser.DefaulteverseMatchingStrategy.ByOrderAmongstSiblingWithSameLevel);
            IncrementalReverser ir = new IncrementalReverser((EObject)existingDesignerRootNode, reversedMap, Collections.EMPTY_LIST, false, (AttributeRefResolver)avroRefResolver, incrementalDelete, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, nodeMatchingMap, false);
            ir.reverse();
        }
    }

    private static class AvroRefResolver
    implements AttributeRefResolver {
        Map<String, MdNode> referenceableNodesById = new HashMap<String, MdNode>();
        Map<String, MdNode> referenceableNodesByName = new HashMap<String, MdNode>();
        Map<String, MdNode> referencedNodesById = new HashMap<String, MdNode>();
        Map<String, MdNode> referencedNodesByName = new HashMap<String, MdNode>();

        AvroRefResolver(MdNode rootMdNode) {
            this.storeReferenceableNodes(rootMdNode);
            this.storeReferencedNodes(rootMdNode);
        }

        private void storeReferenceableNodes(MdNode rootMdNode) {
            EList childNodes = rootMdNode.getNode();
            if (childNodes != null) {
                for (MdNode childNode : childNodes) {
                    String childId = childNode.getId();
                    Attribute referenceAttribute = childNode.getAttributeByShortCode("type");
                    if (referenceAttribute == null) continue;
                    MdNode referenceNode = (MdNode)referenceAttribute.getRef();
                    this.referenceableNodesById.put(childId, referenceNode);
                    String name = referenceNode.getName();
                    this.referenceableNodesByName.putIfAbsent(name, referenceNode);
                }
            }
        }

        private void storeReferencedNodes(MdNode mdNode) {
            EList childNodes;
            String id = mdNode.getId();
            String defType = mdNode.getDefType();
            Attribute referenceAttribute = mdNode.getAttributeByShortCode("typeReference");
            if (REFERENCE_TYPES.contains(defType) && referenceAttribute != null) {
                MdNode referenceNode = (MdNode)referenceAttribute.getRef();
                this.referencedNodesById.put(id, referenceNode);
                String name = referenceNode.getName();
                this.referencedNodesByName.putIfAbsent(name, referenceNode);
            }
            if ((childNodes = mdNode.getNode()) != null) {
                for (MdNode childNode : childNodes) {
                    this.storeReferencedNodes(childNode);
                }
            }
        }

        public List<Object> resolve(MdNode context, Attribute attribute) {
            String id = context.getId();
            String name = context.getName();
            Attribute typeAttribute = context.getAttributeByShortCode("type");
            Attribute typeReferenceAttribute = context.getAttributeByShortCode("typeReference");
            MdNode referenceNode = null;
            if (typeAttribute != null) {
                if (this.referenceableNodesById.containsKey(id)) {
                    referenceNode = this.referenceableNodesById.get(id);
                } else if (this.referenceableNodesByName.containsKey(name)) {
                    referenceNode = this.referenceableNodesByName.get(name);
                }
            } else if (typeReferenceAttribute != null) {
                if (this.referencedNodesById.containsKey(id)) {
                    referenceNode = this.referencedNodesById.get(id);
                } else if (this.referencedNodesByName.containsKey(name)) {
                    referenceNode = this.referencedNodesByName.get(name);
                }
            }
            ArrayList<MdNode> resolvedNodes = null;
            if (referenceNode != null) {
                resolvedNodes = new ArrayList<MdNode>();
                resolvedNodes.add(referenceNode);
            }
            return resolvedNodes;
        }
    }

    private static class RefReverseMode
    implements IncrementalReverser.IReverseMatchingStrategy {
        private RefReverseMode() {
        }

        public IncrementalReverser.NodeMatcher getMatcher() {
            return new IncrementalReverser.NodeMatcher(){

                public boolean match(MdNode n1, MdNode n2) {
                    EObject ref2;
                    EObject ref1;
                    Attribute att1 = n1.getAttributeByFullCode("com.stambia.avro.primitiveRef.typeRef");
                    Attribute att2 = n2.getAttributeByFullCode("com.stambia.avro.primitiveRef.typeRef");
                    String fileId1 = null;
                    String eltId1 = null;
                    String eltName1 = null;
                    if (att1 != null && (ref1 = att1.getRef()) != null) {
                        fileId1 = CacheHelper.extractFileID((EObject)ref1);
                        eltId1 = CacheHelper.extractEltID((EObject)ref1);
                        eltName1 = CacheHelper.extractEltName((EObject)ref1);
                    }
                    String fileId2 = null;
                    String eltId2 = null;
                    String eltName2 = null;
                    if (att2 != null && (ref2 = att2.getRef()) != null) {
                        fileId2 = CacheHelper.extractFileID((EObject)ref2);
                        eltId2 = CacheHelper.extractEltID((EObject)ref2);
                        eltName2 = CacheHelper.extractEltName((EObject)ref2);
                    }
                    return (fileId1 == null && fileId2 == null || fileId1 != null && fileId1.equals(fileId2)) && (eltId1 == null && eltId2 == null || eltId1 != null && eltId1.equals(eltId2)) && (eltName1 == null && eltName2 == null || eltName1 != null && eltName1.equals(eltName2));
                }
            };
        }
    }
}

