/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.indy.engine.core.actionCodes.convert.AbstractParser;
import com.indy.engine.core.actionCodes.convert.ParserProvider;
import com.indy.engine.core.actionCodes.convert.Unparser;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ABAPDataTypeProvider
extends AbstractDataTypeConverter {
    public final int BCD_TYPE = 2;
    public final int BYTE_TYPE = 4;
    public final int CHAR_TYPE = 0;
    public final int DATE_TYPE = 1;
    public final int FLOAT_TYPE = 7;
    public final int INT_TYPE = 8;
    public final int INT1_TYPE = 10;
    public final int INT2_TYPE = 9;
    public final int NUM_TYPE = 6;
    public final int STRING_TYPE = 29;
    public final int TIME_TYPE = 3;
    public final int XSTRING_TYPE = 30;
    DateFormat stf = new SimpleDateFormat("HHmmss");
    DateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    AbstractParser dateParser = new AbstractParser.DefaultDateParser(this.sdf);
    AbstractParser timeParser = new AbstractParser.DefaultDateParser(this.stf);

    public int getDataType(String dataType) {
        if (dataType != null && !dataType.isEmpty()) {
            if (dataType.equals("BCD")) {
                return 2;
            }
            if (dataType.equals("BYTE")) {
                return 4;
            }
            if (dataType.equals("CHAR")) {
                return 0;
            }
            if (dataType.equals("DATE")) {
                return 1;
            }
            if (dataType.equals("FLOAT")) {
                return 7;
            }
            if (dataType.equals("INT")) {
                return 8;
            }
            if (dataType.equals("INT1")) {
                return 10;
            }
            if (dataType.equals("INT2")) {
                return 9;
            }
            if (dataType.equals("NUM")) {
                return 6;
            }
            if (dataType.equals("STRING")) {
                return 29;
            }
            if (dataType.equals("TIME")) {
                return 3;
            }
            if (dataType.equals("XSTRING")) {
                return 30;
            }
        }
        return -1;
    }

    public ParserProvider getParserProvider() {
        return new ParserProvider(this){

            public AbstractParser getParser(int dataType) {
                switch (dataType) {
                    case 0: 
                    case 6: 
                    case 29: 
                    case 30: {
                        return AbstractParser.defaultStringParser;
                    }
                    case 1: {
                        return ABAPDataTypeProvider.this.dateParser;
                    }
                    case 3: {
                        return ABAPDataTypeProvider.this.timeParser;
                    }
                    case 7: {
                        return AbstractParser.defaultDoubleParser;
                    }
                    case 2: {
                        return AbstractParser.defaultBigDecimalParser;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        return AbstractParser.defaultIntegerParser;
                    }
                    case 4: {
                        return null;
                    }
                }
                return null;
            }
        };
    }

    public Unparser getUnparser() throws EngineExceptionI {
        return new Unparser(this){

            public String printString(String str, int targetType) {
                return str;
            }

            public String printFloat(Float d, int targetType) {
                return d.toString();
            }

            public String printDouble(Double d, int targetType) {
                return d.toString();
            }

            public String printDecimal(BigDecimal dec, int targetType) {
                return dec.toPlainString();
            }

            public String printDateTime(Calendar cal, int targetType) {
                switch (targetType) {
                    case 3: {
                        return ABAPDataTypeProvider.this.stf.format(cal.getTime());
                    }
                    case 1: {
                        return ABAPDataTypeProvider.this.sdf.format(cal.getTime());
                    }
                }
                return cal.toString();
            }

            public String printBoolean(boolean b, int targetType) {
                if (ABAPDataTypeProvider.this.isString(targetType)) {
                    return b ? "true" : "false";
                }
                return b ? "1" : "0";
            }

            public String print(Object val, int valueType) {
                return null;
            }

            public String printBytes(byte[] bytes, int targetType) {
                return new String(bytes);
            }
        };
    }

    private boolean isString(int type) {
        switch (type) {
            case 0: 
            case 6: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

