/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.sap;

import com.indy.engine.addons.sap.Messages;
import com.indy.engine.addons.sap.SapAbstractActionCodeI;
import com.indy.engine.addons.sap.utils.JCOProvider;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoTable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.UUID;

public class SapAbapExecuteActionCodeI
extends SapAbstractActionCodeI {
    private String programName;
    boolean commit = true;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    String destinationId = UUID.randomUUID().toString();

    public SapAbapExecuteActionCodeI() {
        super("Sap With Rfc", true);
    }

    @Override
    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        super.prepare(sourceRSet);
        this.programName = this.getLocalStringBindedParameter(sourceRSet, "SAP_PROGRAM_NAME", null);
        this.commit = this.getLocalBooleanBindedParameter(sourceRSet, "SAP_COMMIT", false);
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            try {
                String error;
                String programString = this.actionTxtCode;
                JCoDestination destination = this.connect();
                JCoFunctionTemplate tpl = destination.getRepository().getFunctionTemplate("RFC_ABAP_INSTALL_AND_RUN");
                JCoFunction function = tpl.getFunction();
                JCoTable program = function.getTableParameterList().getTable("PROGRAM");
                String[] stringArray = programString.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    program.appendRow();
                    program.setValue("LINE", line);
                    ++n2;
                }
                function.getImportParameterList().setValue("MODE", "F");
                if (this.programName != null) {
                    function.getImportParameterList().setValue("PROGRAMNAME", this.programName);
                }
                this.begin(destination);
                function.execute(destination);
                if (this.commit) {
                    JCoFunction _function = destination.getRepository().getFunctionTemplate("BAPI_TRANSACTION_COMMIT").getFunction();
                    _function.execute(destination);
                }
                this.end(destination);
                JCoTable writes = function.getTableParameterList().getTable("WRITES");
                if (writes.getNumRows() > 0) {
                    int i = 0;
                    while (i < writes.getNumRows()) {
                        writes.setRow(i);
                        ++i;
                    }
                }
                if ((error = function.getExportParameterList().getString("ERRORMESSAGE")) != null && !error.isEmpty() && !error.isBlank()) {
                    throw new EngineExceptionI(Messages.getString("SapAbapExecuteActionCodeI.0") + error);
                }
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            try {
                this.removeDestinationProperties();
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        return 0;
    }

    protected JCoDestination connect() throws Exception {
        return SapAbapExecuteActionCodeI.connect(this, this.destinationId);
    }

    protected void removeDestinationProperties() {
        JCOProvider.getInstance().removeDestinationProperties(this.destinationId);
    }

    protected void begin(JCoDestination destination) {
        JCoContext.begin((JCoDestination)destination);
    }

    protected void end(JCoDestination destination) throws JCoException {
        JCoContext.end((JCoDestination)destination);
    }
}

