/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server;

import com.semarchy.xdi.license.server.Log;
import com.semarchy.xdi.license.server.Messages;
import com.semarchy.xdi.license.server.model.Designer;
import com.semarchy.xdi.license.server.model.Group;
import com.semarchy.xdi.license.server.model.Host;
import com.semarchy.xdi.license.server.model.Hosts;
import com.semarchy.xdi.license.server.model.Message;
import com.semarchy.xdi.license.server.model.MessageCode;
import com.semarchy.xdi.license.server.model.Permission;
import com.semarchy.xdi.license.server.model.Session;
import com.semarchy.xdi.license.server.model.SessionStatus;
import com.semarchy.xdi.license.server.model.Sessions;
import com.semarchy.xdi.license.server.model.Token;
import com.semarchy.xdi.license.server.plugin.IDesignerFilterPlugin;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.springframework.util.AlternativeJdkIdGenerator;

public class VirtualServer {
    long updateDate;
    Map<String, Token> tokens = new HashMap<String, Token>();
    Map<String, Host> hostsMap = new HashMap<String, Host>();
    Map<String, String> designerIdToHostId = new HashMap<String, String>();
    Map<String, Designer> designers = new HashMap<String, Designer>();
    Map<String, Session> sessionsMap = new HashMap<String, Session>();
    Map<String, Set<String>> macAdressSetMap = new HashMap<String, Set<String>>();
    Sessions sessions = new Sessions();
    Hosts hosts = new Hosts();
    String lock = new String("");
    long week = 604800000L;
    AlternativeJdkIdGenerator alternativeJdkIdGenerator = new AlternativeJdkIdGenerator();
    IDesignerFilterPlugin filter;
    private static DatatypeFactory df = null;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private Group group;
    List<String> userCacheList;
    long lastRefresh = 0L;
    File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTokenAndSession() {
        String string = this.lock;
        synchronized (string) {
            for (Host host : new ArrayList<Host>(this.hostsMap.values())) {
                boolean removeHost = true;
                for (Session session : new ArrayList<Session>(host.getSession())) {
                    if (session.getStatus() != SessionStatus.REFUSED) {
                        if (!this.isSessionActive(session)) {
                            if (session.getStatus() != SessionStatus.INACTIVE) {
                                session.setStatus(SessionStatus.INACTIVE);
                            }
                        } else if (session.getStatus() != SessionStatus.ACTIVE) {
                            session.setStatus(SessionStatus.ACTIVE);
                        }
                    }
                    if (session.getStatus() == SessionStatus.INACTIVE || session.getStatus() == SessionStatus.REFUSED) {
                        long t = session.getLastAccessDate().toGregorianCalendar().getTimeInMillis();
                        if (t + this.week <= System.currentTimeMillis()) {
                            this.sessions.getSession().remove(session);
                            this.sessionsMap.remove(session.getUuid());
                            continue;
                        }
                        removeHost = false;
                        continue;
                    }
                    removeHost = false;
                }
                if (!removeHost) continue;
                this.hostsMap.remove(host.getHostId());
                this.hosts.getHost().remove(host);
                host.getSession().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token acquireOrRefreshToken(String uuid, String hostId, Set<String> macAddresses, String groupCode, String hostName, String hostAddress, String userName, String stbVersion, String jvm) {
        if (hostId != null) {
            String string = this.lock;
            synchronized (string) {
                Object designer;
                Message mess;
                Session session;
                this.clearTokenAndSession();
                Host host = this.hostsMap.get(hostId);
                if (host == null) {
                    host = new Host();
                    host.setHostId(hostId);
                    host.setGroupCode(groupCode);
                    this.hostsMap.put(hostId, host);
                    this.hosts.getHost().add(host);
                }
                if ((session = this.sessionsMap.get(uuid)) == null) {
                    session = new Session();
                    session.setSessionDate(this.now());
                    session.setLastAccessDate(session.getSessionDate());
                    session.setUuid(uuid);
                    session.setHostId(host.getHostId());
                    session.setDesignerVersion(stbVersion);
                    session.setDesignerJvm(jvm);
                    this.sessionsMap.put(uuid, session);
                    this.sessions.getSession().add(session);
                    host.getSession().add(session);
                } else {
                    session.setLastAccessDate(this.now());
                }
                session.getMessage().clear();
                ArrayList<Message> errorMessages = new ArrayList<Message>();
                Token token = this.tokens.get(hostId);
                if (token != null) {
                    Log.getServerLogger().debug(Messages.getString("VirtualServer.1") + this.tokenString(token) + Messages.getString("VirtualServer.2"));
                    if (!this.isTokenValid(token)) {
                        this.removeToken(token);
                        mess = new Message();
                        mess.setCode(MessageCode.MISS_REFRESH_TIME);
                        errorMessages.add(mess);
                        token = null;
                    } else {
                        Log.getServerLogger().debug(Messages.getString("VirtualServer.3") + this.tokenString(token) + Messages.getString("VirtualServer.4"));
                        designer = this.designers.get(token.getDesignerId());
                        if (designer == null) {
                            Log.getServerLogger().info(Messages.getString("VirtualServer.5") + this.tokenString(token) + Messages.getString("VirtualServer.6") + token.getDesignerId());
                            token = null;
                        } else if (!this.hasDesignerDateValid((Designer)designer)) {
                            Log.getServerLogger().info(Messages.getString("VirtualServer.7") + this.tokenString(token) + Messages.getString("VirtualServer.8") + token.getDesignerId());
                            this.removeToken(token);
                            Message mess2 = new Message();
                            errorMessages.add(mess2);
                            mess2.setCode(MessageCode.EXPIRED);
                            token = null;
                        } else {
                            Log.getServerLogger().debug(Messages.getString("VirtualServer.9") + this.tokenString(token) + Messages.getString("VirtualServer.10") + token.getDesignerId());
                        }
                    }
                } else {
                    Log.getServerLogger().debug(Messages.getString("VirtualServer.11") + uuid + Messages.getString("VirtualServer.12") + hostId);
                    Log.getServerLogger().debug(Messages.getString("VirtualServer.13"));
                    for (Token _token : this.tokens.values()) {
                        Log.getServerLogger().info(this.tokenString(_token));
                    }
                }
                if (token == null) {
                    designer = this.searchStaticDesigner(macAddresses, groupCode, hostName, hostAddress, userName);
                    boolean isStatic = true;
                    if (designer == null) {
                        isStatic = false;
                        designer = this.searchConcurrentDesigner(groupCode);
                    }
                    if (designer != null) {
                        token = this.createToken(hostId, (Designer)designer);
                        Log.getServerLogger().debug(Messages.getString("VirtualServer.14") + this.tokenString(token) + Messages.getString("VirtualServer.15") + (isStatic ? Messages.getString("VirtualServer.16") : Messages.getString("VirtualServer.17")) + Messages.getString("VirtualServer.18") + hostId);
                    } else {
                        Log.getServerLogger().debug(Messages.getString("VirtualServer.19") + uuid);
                        Message mess3 = new Message();
                        mess3.setCode(MessageCode.NO_TOKEN_AVAILABLE);
                        errorMessages.add(mess3);
                    }
                }
                if (token != null) {
                    session.setStatus(SessionStatus.ACTIVE);
                    mess = new Message();
                    mess.setCode(MessageCode.TOKEN_AVAILABLE);
                    session.getMessage().add(mess);
                    this.refreshToken(token);
                } else {
                    session.setStatus(SessionStatus.REFUSED);
                    session.getMessage().addAll(errorMessages);
                }
                return token;
            }
        }
        return null;
    }

    private void refreshToken(Token token) {
        boolean toRefresh = token.getLastRefreshDate() == null || this.updateDate > token.getLastRefreshDate().toGregorianCalendar().getTimeInMillis();
        token.setLastRefreshDate(this.now());
        if (toRefresh) {
            Designer designer = this.designers.get(token.getDesignerId());
            Integer refreshDelay = designer.getRefreshDelay();
            if (refreshDelay == null) {
                refreshDelay = designer.getMode().equals("CONCURRENT") ? Integer.valueOf(30000) : Integer.valueOf(60000);
            }
            token.setRefreshDelay(refreshDelay);
            XMLGregorianCalendar startDate = designer.getStartDate();
            token.setStartDate(startDate);
            XMLGregorianCalendar endDate = designer.getEndDate();
            token.setEndDate(endDate);
            Long toleranceLevel1Duration = designer.getToleranceLevel1Duration();
            if (toleranceLevel1Duration == null) {
                toleranceLevel1Duration = 0L;
            }
            token.setToleranceLevel1Duration(toleranceLevel1Duration);
            Long toleranceLevel2Duration = designer.getToleranceLevel2Duration();
            if (toleranceLevel2Duration == null) {
                toleranceLevel2Duration = 0L;
            }
            token.setToleranceLevel2Duration(toleranceLevel2Duration);
            Long toleranceKillDuration = designer.getToleranceKillDuration();
            if (toleranceKillDuration == null) {
                toleranceKillDuration = 0L;
            }
            token.setToleranceKillDuration(toleranceKillDuration);
        }
    }

    private boolean isTokenValid(Token token) {
        Integer deltaValidity;
        Designer designer = this.designers.get(token.getDesignerId());
        if (designer == null) {
            Log.getServerLogger().info(Messages.getString("VirtualServer.20") + this.tokenString(token) + Messages.getString("VirtualServer.21") + token.getDesignerId());
            return false;
        }
        String verif = this.designerIdToHostId.get(designer.getId());
        if (verif == null || !verif.equals(token.getHostId())) {
            Log.getServerLogger().info(Messages.getString("VirtualServer.22") + this.tokenString(token) + Messages.getString("VirtualServer.23") + verif + Messages.getString("VirtualServer.24") + token.getHostId());
            return false;
        }
        if (designer.getMode().equals("STATIC")) {
            if (designer.getMacAddress() == null || token.getMacAddress() == null) {
                Log.getServerLogger().info(Messages.getString("VirtualServer.26") + this.tokenString(token) + Messages.getString("VirtualServer.27") + designer.getMacAddress() + Messages.getString("VirtualServer.28") + token.getMacAddress() + Messages.getString("VirtualServer.29"));
                return false;
            }
            if (!token.getMacAddress().equals(designer.getMacAddress())) {
                Log.getServerLogger().info(Messages.getString("VirtualServer.30") + this.tokenString(token) + Messages.getString("VirtualServer.31") + designer.getMacAddress() + Messages.getString("VirtualServer.32") + token.getMacAddress() + Messages.getString("VirtualServer.33"));
                return false;
            }
        }
        if ((deltaValidity = designer.getValidityDuration()) == null) {
            deltaValidity = token.getRefreshDelay() + 10000;
        }
        if (VirtualServer.isDateValid(token.getLastRefreshDate(), deltaValidity)) {
            return true;
        }
        Log.getServerLogger().info(Messages.getString("VirtualServer.34") + this.tokenString(token) + Messages.getString("VirtualServer.35") + token.getLastRefreshDate().toGregorianCalendar().getTimeInMillis() + Messages.getString("VirtualServer.36") + System.currentTimeMillis());
        return false;
    }

    private boolean isSessionActive(Session session) {
        Token token = this.tokens.get(session.getHostId());
        if (token != null) {
            Designer designer = this.designers.get(token.getDesignerId());
            if (designer == null) {
                return false;
            }
            Integer deltaValidity = designer.getValidityDuration();
            if (deltaValidity == null) {
                deltaValidity = token.getRefreshDelay() + 10000;
            }
            return VirtualServer.isDateValid(session.getLastAccessDate(), deltaValidity);
        }
        return false;
    }

    private static boolean isDateValid(XMLGregorianCalendar lastDate, int deltaValidity) {
        if (lastDate == null) {
            return false;
        }
        boolean ret = System.currentTimeMillis() - lastDate.toGregorianCalendar().getTimeInMillis() < (long)deltaValidity;
        return ret;
    }

    private boolean hasDesignerDateValid(Designer designer) {
        XMLGregorianCalendar startDate = designer.getStartDate();
        XMLGregorianCalendar endDate = designer.getEndDate();
        if (startDate != null && startDate.compare(this.now()) == 1) {
            return false;
        }
        return endDate == null || endDate.compare(this.now()) != -1;
    }

    private boolean hasDesignerMatchMacAdressOrOther(Designer designer, Set<String> macAddresses, String hostName, String hostAddress, String userName) {
        boolean retour = true;
        if (!(designer.getMacAddress() == null || designer.getMacAddress().isEmpty() || macAddresses != null && macAddresses.contains(designer.getMacAddress()))) {
            retour = false;
        }
        if (!(!retour || designer.getHostName() == null || designer.getHostName().isEmpty() || hostName != null && hostName.equals(designer.getHostName()))) {
            retour = false;
        }
        if (!(!retour || designer.getHostAddress() == null || designer.getHostAddress().isEmpty() || hostAddress != null && hostAddress.equals(designer.getHostAddress()))) {
            retour = false;
        }
        if (!(!retour || designer.getUserName() == null || designer.getUserName().isEmpty() || userName != null && userName.equals(designer.getUserName()))) {
            retour = false;
        }
        return retour;
    }

    private XMLGregorianCalendar now() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(System.currentTimeMillis());
        return df.newXMLGregorianCalendar(gc);
    }

    private Token createToken(String hostId, Designer designer) {
        this.designerIdToHostId.put(designer.getId(), hostId);
        Token token = new Token();
        if (designer.getMacAddress() != null) {
            token.setMacAddress(designer.getMacAddress());
        }
        this.tokens.put(hostId, token);
        token.setDesignerId(designer.getId());
        token.setTokenDate(this.now());
        token.setHostId(hostId);
        token.setMode(designer.getMode());
        token.setIsTrial(designer.getIsTrial());
        return token;
    }

    private String tokenString(Token token) {
        return this.sdf.format(new Date(token.getTokenDate().toGregorianCalendar().getTimeInMillis())) + token.getHostId();
    }

    private void removeToken(Token token) {
        Log.getServerLogger().info(Messages.getString("VirtualServer.0") + this.tokenString(token));
        String hostId = this.designerIdToHostId.get(token.getDesignerId());
        if (hostId != null && hostId.equals(token.getHostId())) {
            this.designerIdToHostId.remove(token.getDesignerId());
        }
        this.tokens.remove(token.getHostId());
    }

    private Token getToken(Designer designer) {
        String hostId = this.designerIdToHostId.get(designer.getId());
        if (hostId != null) {
            for (Token token : this.tokens.values()) {
                if (!hostId.equals(token.getHostId())) continue;
                return token;
            }
        }
        return null;
    }

    private Designer searchConcurrentDesigner(String groupCode) {
        if (groupCode == null) {
            groupCode = "default";
        }
        try {
            for (Designer designer : this.designers.values()) {
                if (!designer.getMode().equals("CONCURRENT")) continue;
                boolean valid = this.hasDesignerDateValid(designer);
                Token token = this.getToken(designer);
                if (token != null) {
                    if (!valid) {
                        this.removeToken(token);
                        continue;
                    }
                    if (this.isTokenValid(token)) continue;
                    this.removeToken(token);
                    return designer;
                }
                if (!valid) continue;
                return designer;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Designer searchStaticDesigner(Set<String> macAddresses, String groupCode, String hostName, String hostAddress, String userName) {
        if (groupCode == null) {
            groupCode = "default";
        }
        try {
            for (Designer designer : this.designers.values()) {
                if (!designer.getMode().equals("STATIC") || !this.hasDesignerDateValid(designer)) continue;
                boolean valid = this.hasDesignerMatchMacAdressOrOther(designer, macAddresses, hostName, hostAddress, userName);
                Token token = this.getToken(designer);
                if (token != null) {
                    if (!valid) {
                        this.removeToken(token);
                        continue;
                    }
                    if (this.isTokenValid(token)) continue;
                    this.removeToken(token);
                    return designer;
                }
                if (!valid) continue;
                return designer;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Session getSession(String uuid) {
        return this.sessionsMap.get(uuid);
    }

    public Sessions getSessions() {
        this.clearTokenAndSession();
        return this.sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroup(Group group) {
        this.updateDate = System.currentTimeMillis();
        String string = this.lock;
        synchronized (string) {
            this.group = group;
            for (Designer designer : group.getDesigner()) {
                this.designers.put(designer.getId(), designer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUser(String userName) {
        if (this.filter != null) {
            long currentTime = System.currentTimeMillis();
            String string = this.lock;
            synchronized (string) {
                if (this.lastRefresh == 0L || currentTime - this.lastRefresh > this.filter.getRefreshInterval()) {
                    Log.getServerLogger().info(Messages.getString("VirtualServer.40") + this.group.getCode());
                    this.lastRefresh = currentTime;
                    try {
                        this.userCacheList = this.filter.getUserNames();
                        Log.getServerLogger().info(Messages.getString("VirtualServer.41") + this.userCacheList.size() + Messages.getString("VirtualServer.42") + this.group.getCode());
                    }
                    catch (Exception e) {
                        Log.getServerLogger().error(Messages.getString("VirtualServer.43") + this.userCacheList.size() + Messages.getString("VirtualServer.44"), (Throwable)e);
                    }
                }
            }
            return this.userCacheList.contains(userName);
        }
        return true;
    }

    public List<String> getPermission() {
        ArrayList<String> permissionNameList = new ArrayList<String>();
        List<Permission> permissionList = this.group.getPermission();
        XMLGregorianCalendar currentDate = this.now();
        this.keepYearMonthDayInformation(currentDate);
        for (Permission permission : permissionList) {
            if (!this.hasPermissionDateValid(permission, currentDate)) continue;
            permissionNameList.add(permission.getValue());
        }
        return permissionNameList;
    }

    private boolean hasPermissionDateValid(Permission permission, XMLGregorianCalendar currentDate) {
        XMLGregorianCalendar startDate = permission.getStartDate();
        XMLGregorianCalendar endDate = permission.getEndDate();
        if (startDate != null) {
            this.keepYearMonthDayInformation(startDate);
            if (startDate.compare(currentDate) == 1) {
                return false;
            }
        }
        if (endDate != null) {
            this.keepYearMonthDayInformation(endDate);
            if (endDate.compare(currentDate) == -1) {
                return false;
            }
        }
        return true;
    }

    private void keepYearMonthDayInformation(XMLGregorianCalendar date) {
        date.setHour(0);
        date.setMinute(0);
        date.setSecond(0);
        date.setMillisecond(0);
        date.setTimezone(0);
    }

    public boolean check(String key, String login, String password) {
        return VirtualServer.equalsNull(key, this.group.getKey()) && VirtualServer.equalsNull(login, this.group.getLogin()) && VirtualServer.equalsNull(password, this.group.getPassword());
    }

    public boolean keyIsMatched(String key) {
        return VirtualServer.equalsNull(key, this.group.getKey());
    }

    public boolean loginIsMatched(String login) {
        return VirtualServer.equalsNull(login, this.group.getLogin());
    }

    public boolean passwordIsMatched(String password) {
        return VirtualServer.equalsNull(password, this.group.getPassword());
    }

    public boolean keyIsRequired() {
        return this.group.getKey() != null && !this.group.getKey().isEmpty();
    }

    public boolean loginIsRequired() {
        return this.group.getLogin() != null && !this.group.getKey().isEmpty();
    }

    public boolean passwordIsRequired() {
        return this.group.getLogin() != null;
    }

    public static boolean equalsNull(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String getUUIDFromMacAddressSet(Set<String> macAddressSet) {
        for (String mac : macAddressSet) {
            for (String uuid : this.macAdressSetMap.keySet()) {
                if (!this.macAdressSetMap.get(uuid).contains(mac)) continue;
                return uuid;
            }
        }
        String newUuid = this.alternativeJdkIdGenerator.generateId().toString();
        this.macAdressSetMap.put(newUuid, macAddressSet);
        return newUuid;
    }

    public Host getHost(String hostId) {
        return this.hostsMap.get(hostId);
    }

    public Hosts getHosts() {
        this.clearTokenAndSession();
        return this.hosts;
    }

    public File getFile() {
        return this.file;
    }

    public void setFilter(IDesignerFilterPlugin filter2) {
        this.filter = filter2;
    }

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalStateException("Exception while obtaining DatatypeFactory instance", dce);
        }
    }
}

