/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server.filter;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class WadlDocStripFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        String path = request.getUriInfo().getPath();
        if (path == null || !path.equalsIgnoreCase("application.wadl")) {
            return;
        }
        Object entity = response.getEntity();
        if (entity == null) {
            return;
        }
        request.getHeaders().remove((Object)"Content-Length");
        Pattern docs = Pattern.compile("(?is)<doc\\b[^>]*?/\\s*>|<doc\\b[^>]*?>.*?</doc>");
        String xml = entity.toString();
        if (entity instanceof ByteArrayInputStream) {
            ByteArrayInputStream in = (ByteArrayInputStream)entity;
            xml = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        } else if (entity instanceof byte[]) {
            byte[] bytes = (byte[])entity;
            xml = new String(bytes, StandardCharsets.UTF_8);
        }
        response.setEntity((Object)docs.matcher(xml).replaceAll(""), null, MediaType.APPLICATION_XML_TYPE);
    }
}

