/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server.model;

import com.semarchy.xdi.license.server.model.Designer;
import com.semarchy.xdi.license.server.model.Message;
import com.semarchy.xdi.license.server.model.Messages;
import com.semarchy.xdi.license.server.model.Session;
import java.lang.reflect.Field;

public class Utils {
    public static Object copyEmptyObjectToAnother(Object source, Object target) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : target.getClass().getDeclaredFields()) {
            field.set(target, field.get(source));
        }
        return target;
    }

    public static String printMessages(Messages messages) {
        Object str = "";
        for (Message mess : messages.getMessage()) {
            if (!((String)str).isEmpty()) {
                str = (String)str + " | ";
            }
            str = (String)str + Utils.printMessage(mess);
        }
        return str;
    }

    public static String printMessage(Message mess) {
        return String.valueOf((Object)mess.getCode()) + (String)(mess.getValue() != null && !mess.getValue().isEmpty() ? ": " + mess.getValue() : "");
    }

    public static int compareSession(Session sess1, Session sess2) {
        if (sess1 == null && sess2 == null) {
            return 0;
        }
        if (sess2 == null) {
            return 1;
        }
        if (sess1 == null) {
            return -1;
        }
        if (sess1.getSessionDate() == null && sess2.getSessionDate() == null) {
            return 0;
        }
        if (sess2.getSessionDate() == null) {
            return 1;
        }
        if (sess1.getSessionDate() == null) {
            return -1;
        }
        return sess1.getSessionDate().compare(sess2.getSessionDate());
    }

    public static boolean isDesignerStatic(Designer designer) {
        return designer.getMacAddress() != null && !designer.getMacAddress().isEmpty() || designer.getHostName() != null && !designer.getHostName().isEmpty() || designer.getHostAddress() != null && !designer.getHostAddress().isEmpty() || designer.getUserName() != null && !designer.getUserName().isEmpty();
    }

    public static String printQuery(String groupCode, String macList, String uuid, String user, String ip, String hostName, String os, String jvm, String key, String login, String password, String stbVersion) {
        return "Query [groupCode=" + groupCode + ", macList=" + macList + ", uuid=" + uuid + ", user=" + user + ", ip=" + ip + ", hostName=" + hostName + ", os=" + os + ", jvm=" + jvm + ", key=" + key + ", login=" + login + ", password=" + password + ", stbVersion=" + stbVersion + "]";
    }
}

