/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server.resource.v2;

import com.semarchy.xdi.license.server.LicenceServer;
import com.semarchy.xdi.license.server.Log;
import com.semarchy.xdi.license.server.VirtualServer;
import com.semarchy.xdi.license.server.model.Host;
import com.semarchy.xdi.license.server.model.Hosts;
import com.semarchy.xdi.license.server.model.Message;
import com.semarchy.xdi.license.server.model.MessageCode;
import com.semarchy.xdi.license.server.model.ObjectFactory;
import com.semarchy.xdi.license.server.model.Session;
import com.semarchy.xdi.license.server.model.Token;
import com.semarchy.xdi.license.server.model.Utils;
import com.semarchy.xdi.license.server.resource.v2.Messages;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.springframework.web.bind.annotation.RestController;

@Path(value="/api/2")
@RestController
public class ModeResourceV2 {
    @Context
    HttpServletRequest req;

    @Path(value="/{group}/token/designer/")
    @GET
    @Produces(value={"text/xml"})
    public String getMode(@PathParam(value="group") String groupCode, @QueryParam(value="macs") String macList, @QueryParam(value="uuid") String uuid, @QueryParam(value="user") String user, @QueryParam(value="ip") String ip, @QueryParam(value="host") String hostName, @QueryParam(value="os") String os, @QueryParam(value="jvm") String jvm, @QueryParam(value="key") String key, @QueryParam(value="login") String login, @QueryParam(value="password") String password, @QueryParam(value="stbversion") String stbVersion, @Context UriInfo ui) {
        String msg;
        block32: {
            msg = Messages.getString("ModeResourceV2.0") + uuid + Messages.getString("ModeResourceV2.1") + hostName;
            Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.2"));
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.3") + groupCode);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.5") + macList);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.6") + user);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.7") + ip);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.8") + hostName);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.9") + os);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.10") + jvm);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.11") + key);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.12") + stbVersion);
            Log.getServerLogger().debug(uuid + Messages.getString("ModeResourceV2.13") + String.valueOf(ui));
            if (groupCode != null) {
                try {
                    VirtualServer vs = LicenceServer.INSTANCE.getVirtualServer(groupCode);
                    if (vs != null) {
                        Message message;
                        boolean check = vs.check(key, login, password);
                        boolean userCheck = vs.checkUser(user);
                        if (check && userCheck) {
                            HashSet<String> macAddresSet = new HashSet<String>();
                            if (macList != null && macList.length() > 0 && macList.length() % 17 == 0) {
                                for (int i = 0; i < macList.length() / 17; ++i) {
                                    String tmp = macList.substring(i * 17, (i + 1) * 17);
                                    macAddresSet.add(tmp);
                                }
                            }
                            String hostId = vs.getUUIDFromMacAddressSet(macAddresSet) + "-" + user;
                            Token token = vs.acquireOrRefreshToken(uuid, hostId, macAddresSet, groupCode, hostName, ip, user, stbVersion, jvm);
                            Host host = vs.getHost(hostId);
                            if (host != null) {
                                host.setAddress(ip);
                                host.setMacAddress(macList);
                                host.setName(hostName);
                                host.setOperatingSystem(os);
                                host.setUserName(user);
                                host.setRemoteAddress(this.req.getRemoteAddr());
                                host.setRemoteName(this.req.getRemoteHost());
                            }
                            if (token != null) {
                                token.setPermission(vs.getPermission());
                                Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.16") + token.getDesignerId());
                                return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createToken(token));
                            }
                            com.semarchy.xdi.license.server.model.Messages messages = new com.semarchy.xdi.license.server.model.Messages();
                            Session sess = vs.getSession(uuid);
                            messages.getMessage().addAll(sess.getMessage());
                            Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.17"));
                            Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.18") + Utils.printMessages(messages));
                            Log.getServerLogger().info(msg + " " + Utils.printQuery(groupCode, macList, uuid, user, ip, hostName, hostId, jvm, key, login, password, stbVersion));
                            if (messages != null) {
                                return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createMessages(messages));
                            }
                            break block32;
                        }
                        com.semarchy.xdi.license.server.model.Messages messages = new com.semarchy.xdi.license.server.model.Messages();
                        if (vs.keyIsRequired()) {
                            if (key == null || key.isEmpty()) {
                                message = new Message();
                                message.setCode(MessageCode.KEY_REQUIRED);
                                messages.getMessage().add(message);
                            } else if (!vs.keyIsMatched(key)) {
                                message = new Message();
                                message.setCode(MessageCode.KEY_ERROR);
                                messages.getMessage().add(message);
                            }
                        } else if (key != null && !key.isEmpty()) {
                            message = new Message();
                            message.setCode(MessageCode.KEY_NOT_PERMITTED);
                            messages.getMessage().add(message);
                        }
                        if (vs.loginIsRequired()) {
                            if (login == null || login.isEmpty()) {
                                message = new Message();
                                message.setCode(MessageCode.LOGIN_REQUIRED);
                                messages.getMessage().add(message);
                            } else if (!vs.loginIsMatched(key)) {
                                message = new Message();
                                message.setCode(MessageCode.LOGIN_ERROR);
                                messages.getMessage().add(message);
                            }
                        } else if (login != null && !login.isEmpty()) {
                            message = new Message();
                            message.setCode(MessageCode.LOGIN_NOT_PERMITTED);
                            messages.getMessage().add(message);
                        }
                        if (vs.passwordIsRequired()) {
                            if (password == null) {
                                message = new Message();
                                message.setCode(MessageCode.PASSWORD_REQUIRED);
                                messages.getMessage().add(message);
                            } else if (!vs.passwordIsMatched(key)) {
                                message = new Message();
                                message.setCode(MessageCode.PASSWORD_ERROR);
                                messages.getMessage().add(message);
                            }
                        } else if (password != null) {
                            message = new Message();
                            message.setCode(MessageCode.PASSWORD_NOT_PERMITTED);
                            messages.getMessage().add(message);
                        } else if (!userCheck) {
                            message = new Message();
                            message.setCode(MessageCode.LOGIN_NOT_PERMITTED);
                            messages.getMessage().add(message);
                            message.setValue(user);
                        }
                        Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.14"));
                        Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.21") + Utils.printMessages(messages));
                        return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createMessages(messages));
                    }
                    com.semarchy.xdi.license.server.model.Messages messages = new com.semarchy.xdi.license.server.model.Messages();
                    Message message = new Message();
                    message.setCode(MessageCode.GROUP_NOT_EXISTS);
                    messages.getMessage().add(message);
                    message.setValue(groupCode);
                    Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.22"));
                    Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.23") + Utils.printMessages(messages));
                    return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createMessages(messages));
                }
                catch (Exception e) {
                    Log.getServerLogger().error(Messages.getString("ModeResourceV2.24"), (Throwable)e);
                }
            }
        }
        com.semarchy.xdi.license.server.model.Messages messages = new com.semarchy.xdi.license.server.model.Messages();
        Message message = new Message();
        message.setCode(MessageCode.ERROR);
        try {
            Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.25"));
            Log.getServerLogger().info(msg + Messages.getString("ModeResourceV2.26") + Utils.printMessages(messages));
            return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createMessages(messages));
        }
        catch (JAXBException jAXBException) {
            return null;
        }
    }

    @Path(value="/{group}/sessionList/")
    @GET
    @Produces(value={"text/xml"})
    public String getSessions(@PathParam(value="group") String groupCode) {
        Log.getServerLogger().info(Messages.getString("ModeResourceV2.27"));
        try {
            VirtualServer vs = LicenceServer.INSTANCE.getVirtualServer(groupCode);
            if (vs != null) {
                return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createSessions(vs.getSessions()));
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return "<sessions/>";
    }

    @Path(value="/update/")
    @POST
    @Produces(value={"text/xml"})
    public String update(final @QueryParam(value="delay") int delay, @Context HttpServletRequest request) throws Exception {
        Log.getServerLogger().info(Messages.getString("ModeResourceV2.35"));
        StringBuilder stringBuilder = new StringBuilder();
        String content = null;
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[5000];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        content = stringBuilder.toString();
        LicenceServer.CmdLineOption cmd = LicenceServer.INSTANCE.getCmd();
        String basedir = cmd.getBasedir();
        Object filePath = "license.xml";
        if (basedir != null) {
            filePath = basedir + "/" + (String)filePath;
        }
        File file = new File((String)filePath);
        FileWriter fw = new FileWriter(file);
        fw.write(content);
        fw.close();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.getServerLogger().info(Messages.getString("ModeResourceV2.39"));
                    if (delay < 1000) {
                        Thread.sleep(1000L);
                    } else {
                        Thread.sleep(delay);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                LicenceServer.restart();
            }
        });
        thread.start();
        return "<update/>";
    }

    @Path(value="/{group}/hostList/")
    @GET
    @Produces(value={"text/xml"})
    public String getHosts(@PathParam(value="group") String groupCode) {
        Log.getServerLogger().info(Messages.getString("ModeResourceV2.41"));
        try {
            VirtualServer vs = LicenceServer.INSTANCE.getVirtualServer(groupCode);
            Hosts hosts = vs.getHosts();
            if (vs != null) {
                return LicenceServer.INSTANCE.marshallToString(new ObjectFactory().createHosts(hosts));
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        return "<hosts/>";
    }

    @Path(value="/hostList/")
    @GET
    @Produces(value={"text/xml"})
    public String getHosts2(@QueryParam(value="group") String groupCode) {
        return this.getHosts(groupCode);
    }

    @Path(value="/sessionList/")
    @GET
    @Produces(value={"text/xml"})
    public String getSessions2(@QueryParam(value="group") String groupCode) {
        return this.getSessions(groupCode);
    }

    @Path(value="/groupList/")
    @GET
    @Produces(value={"text/xml"})
    public String getGroups() {
        Log.getServerLogger().info(Messages.getString("ModeResourceV2.43"));
        Object str = "<groups>";
        for (String ket : LicenceServer.INSTANCE.groupList()) {
            str = (String)str + "<group>" + ket + "</group>";
        }
        str = (String)str + "</groups>";
        return str;
    }
}

