/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.license.server.validation;

import com.semarchy.xdi.license.server.model.ObjectFactory;
import com.semarchy.xdi.license.server.model.Server;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VerificationUtil {
    public static String getServerToString(Server server, Logger logger) throws JAXBException, ParserConfigurationException, SAXException, IOException, XPathExpressionException, NoSuchAlgorithmException, NoSuchProviderException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.semarchy.xdi.license.server.model");
        Marshaller m = jc.createMarshaller();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        m.marshal(new ObjectFactory().createServer(server), (OutputStream)output);
        ByteArrayInputStream decodedInput = new ByteArrayInputStream(output.toByteArray());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(decodedInput);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        XPathExpression expr = xpath.compile("//@*[not(name()='signature')]");
        NodeList result = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<CallSite> str = new ArrayList<CallSite>();
        for (int i = 0; i < result.getLength(); ++i) {
            if (result.item(i).getNodeValue() == null || result.item(i).getNodeValue().isEmpty()) continue;
            str.add((CallSite)((Object)(result.item(i).getNodeName() + "|" + result.item(i).getNodeValue())));
        }
        Collections.sort(str, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuffer buffer = new StringBuffer();
        if (logger != null) {
            logger.debug("Compute Signature, base: ");
        }
        for (String string : str) {
            buffer.append(string);
            if (logger == null) continue;
            logger.debug(string);
        }
        return buffer.toString();
    }
}

