/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.BasicAuthentication;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Authentication;
import com.semarchy.xdi.base.core.auth.OAuthAuthentication;
import com.semarchy.xdi.base.core.auth.ProxyInformationsEnum;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class AuthenticationFactory {
    public static String getAuthHeader(Map<String, Object> authParameters, String method, URL url, Map<String, Object> proxyParameters) throws Exception {
        Object type = authParameters.get("type");
        if (type != null) {
            switch ((String)authParameters.get("type")) {
                case "basic": {
                    return AuthenticationFactory.getBasicAuthHeader(authParameters);
                }
                case "oauth": {
                    return AuthenticationFactory.getOauthHeader(authParameters, method, url);
                }
                case "oauth2": {
                    return AuthenticationFactory.getOauth2Header(authParameters, proxyParameters);
                }
            }
            return null;
        }
        return null;
    }

    private static String getBasicAuthHeader(Map<String, Object> authParameters) throws Exception {
        String userName = (String)authParameters.get("userName");
        String password = (String)authParameters.get("password");
        return new BasicAuthentication(userName, password).getAuthenticationHeaderValue(null);
    }

    private static String getOauth2Header(Map<String, Object> authParameters, Map<String, Object> proxyParameters) throws Exception {
        return AuthenticationFactory.getOAuth2Authentication(authParameters, proxyParameters).getAuthenticationHeaderValue(null);
    }

    public static String getOAuth2Token(Map<String, Object> authParameters) throws Exception {
        return AuthenticationFactory.getOAuth2Authentication(authParameters, null).getOAuth2Token();
    }

    private static OAuth2Authentication getOAuth2Authentication(Map<String, Object> authParameters, Map<String, Object> proxyParameters) throws Exception {
        String clientId = (String)authParameters.get("clientId");
        String tokenEndpointHttpMethod = (String)authParameters.get("tokenEndpointHttpMethod");
        String redirectionEndpoint = (String)authParameters.get("redirectionEndpoint");
        String accessToken = (String)authParameters.get("accessToken");
        String authorizationEndpoint = (String)authParameters.get("authorizationEndpoint");
        Integer expiresIn = null;
        if (authParameters.get("expiresIn") != null) {
            expiresIn = Integer.valueOf((String)authParameters.get("expiresIn"));
        }
        String tokenEndpoint = (String)authParameters.get("tokenEndpoint");
        String clientSecret = (String)authParameters.get("clientSecret");
        Integer numberOfAttempts = null;
        if (authParameters.get("numberOfAttemps") != null) {
            numberOfAttempts = Integer.valueOf((String)authParameters.get("numberOfAttempts"));
        }
        Integer connectionTimeout = null;
        if (authParameters.get("connectionTimeout") != null) {
            numberOfAttempts = Integer.valueOf((String)authParameters.get("connectionTimeout"));
        }
        String flowType = (String)authParameters.get("flowType");
        String refreshToken = (String)authParameters.get("refreshToken");
        String scope = null;
        if (authParameters.get("scope") != null) {
            scope = String.join((CharSequence)" ", (ArrayList)authParameters.get("scope"));
        }
        boolean sendClientId = false;
        if (authParameters.get("useClientId4TokenGeneration") != null) {
            sendClientId = Boolean.valueOf((String)authParameters.get("useClientId4TokenGeneration"));
        }
        boolean sendClientSecret = false;
        if (authParameters.get("useClientSecret4TokenGeneration") != null) {
            sendClientSecret = Boolean.valueOf((String)authParameters.get("useClientSecret4TokenGeneration"));
        }
        OAuth2.CredentialMode clientCredentialPolicy = OAuth2.CredentialMode.NONE;
        if (authParameters.get("sendClientCredentialsPolicy") != null) {
            clientCredentialPolicy = OAuth2.CredentialMode.fromLabel((String)authParameters.get("sendClientCredentialsPolicy"));
        }
        if (clientCredentialPolicy == OAuth2.CredentialMode.NONE && sendClientId) {
            clientCredentialPolicy = sendClientSecret ? OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET : OAuth2.CredentialMode.PARAMETER_CLIENT_ID;
        }
        Boolean enableCertificatefVerif = true;
        String enableCertificateVerification = (String)authParameters.get("enableCertificateVerification");
        if (enableCertificateVerification != null && !enableCertificateVerification.isEmpty()) {
            enableCertificatefVerif = Boolean.valueOf(enableCertificateVerification);
        }
        Boolean enableHostnameVerif = true;
        String enableHostnameVerification = (String)authParameters.get("enableHostnameVerification");
        if (enableHostnameVerification != null && !enableHostnameVerification.isEmpty()) {
            enableHostnameVerif = Boolean.valueOf(enableHostnameVerification);
        }
        String username = (String)authParameters.get("username");
        String password = (String)authParameters.get("password");
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUser = null;
        String proxyPassword = null;
        if (proxyParameters != null) {
            proxyHost = (String)proxyParameters.get(ProxyInformationsEnum.host.name());
            String strPort = (String)proxyParameters.get(ProxyInformationsEnum.port.name());
            if (strPort != null && !strPort.isEmpty()) {
                try {
                    proxyPort = Integer.valueOf(strPort);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            proxyUser = (String)proxyParameters.get(ProxyInformationsEnum.username.name());
            proxyPassword = (String)proxyParameters.get(ProxyInformationsEnum.password.name());
        }
        Map authorizationParameters = (Map)authParameters.get("authorizationParameter");
        Map additionalHttpHeaders = (Map)authParameters.get("additionalHttpHeaders");
        return new OAuth2Authentication(accessToken, refreshToken, tokenEndpoint, clientId, clientSecret, expiresIn, numberOfAttempts, connectionTimeout, flowType, authorizationEndpoint, username, password, redirectionEndpoint, scope, clientCredentialPolicy, tokenEndpointHttpMethod, authorizationParameters, enableHostnameVerif, enableCertificatefVerif, additionalHttpHeaders, proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    private static String getOauthHeader(Map<String, Object> authParameters, String method, URL url) throws Exception {
        String signatureMethod = (String)authParameters.get("signatureMethod");
        String token = (String)authParameters.get("token");
        String consumerSecret = (String)authParameters.get("consumerSecret");
        String consumerKey = (String)authParameters.get("consumerKey");
        String tokenSecret = (String)authParameters.get("tokenSecret");
        return new OAuthAuthentication(url, method, consumerKey, consumerSecret, signatureMethod, token, tokenSecret).getAuthenticationHeaderValue(null);
    }
}

