/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import jakarta.xml.bind.DatatypeConverter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;

public class OAuth {
    private OAuth() {
    }

    private static String encode(String decode) throws UnsupportedEncodingException {
        return URLEncoder.encode(decode, "UTF-8").replace("+", "%20");
    }

    public static String generateHeader(String surl, String httpMethod, OAuthMetadata md, Map<String, String> parameters) throws UnsupportedEncodingException {
        TreeMap<String, String> tmpParameters = new TreeMap<String, String>();
        String signature = "";
        String encodedSignature = "";
        HashMap<String, String> urlParamters = new HashMap<String, String>();
        if (surl.contains("?")) {
            String surlTemp = surl.substring(surl.indexOf("?") + 1);
            surl = surl.substring(0, surl.indexOf("?"));
            boolean bool = true;
            while (bool) {
                String param;
                if (surlTemp.contains("&")) {
                    param = surlTemp.substring(0, surlTemp.indexOf("&"));
                    surlTemp = surlTemp.substring(surlTemp.indexOf("&") + 1);
                    urlParamters.put(param.substring(0, param.indexOf("=")), param.substring(param.indexOf("=") + 1));
                    continue;
                }
                param = surlTemp;
                urlParamters.put(param.substring(0, param.indexOf("=")), param.substring(param.indexOf("=") + 1));
                bool = false;
            }
        }
        TreeMap<String, String> map = new TreeMap<String, String>(md.getParameters());
        map.put("oauth_nonce", OAuth.generateNonce());
        map.put("oauth_timestamp", OAuth.timestamp());
        tmpParameters.putAll(map);
        tmpParameters.putAll(md.getParameters());
        tmpParameters.putAll(parameters);
        for (String key : tmpParameters.keySet()) {
            String value = (String)tmpParameters.get(key);
            if (value != null) {
                tmpParameters.put(key, OAuth.encode(value));
                continue;
            }
            tmpParameters.put(key, "");
        }
        Object concatParameters = "";
        tmpParameters.putAll(urlParamters);
        int i = 0;
        for (String key : tmpParameters.keySet()) {
            String value = (String)tmpParameters.get(key);
            if (i++ > 0) {
                concatParameters = (String)concatParameters + "&";
            }
            concatParameters = (String)concatParameters + key + "=" + value;
        }
        String signature_base_string = httpMethod + "&" + OAuth.encode(surl) + "&" + OAuth.encode((String)concatParameters);
        String signKey = OAuth.encode(md.consumerSecret) + "&" + OAuth.encode(md.tokenSecret);
        byte[] result = OAuth.hashHmacSHA1(signKey, signature_base_string);
        signature = DatatypeConverter.printBase64Binary((byte[])result);
        encodedSignature = OAuth.encode(signature);
        Object header = "OAuth ";
        map.put("oauth_signature", encodedSignature);
        i = 0;
        for (Map.Entry entry : map.entrySet()) {
            String paramValue = (String)entry.getValue();
            if (i++ > 0) {
                header = (String)header + ", ";
            }
            header = (String)header + (String)entry.getKey() + "=\"" + paramValue + "\"";
        }
        return header;
    }

    public static String generateNonce() {
        SecureRandom gen = new SecureRandom();
        ((Random)gen).setSeed(System.currentTimeMillis());
        StringBuilder nonceBuilder = new StringBuilder("");
        String base = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int baseLength = base.length();
        for (int i = 0; i < 32; ++i) {
            int position = gen.nextInt(baseLength);
            nonceBuilder.append(base.charAt(position));
        }
        return nonceBuilder.toString();
    }

    public static String timestamp() {
        Long time = System.currentTimeMillis();
        return String.valueOf(time / 1000L);
    }

    public static byte[] hashHmacSHA1(String signKey, String signature_base_string) {
        SecretKeySpec keySpec = new SecretKeySpec(signKey.getBytes(), "HmacSHA1");
        byte[] result = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            result = mac.doFinal(signature_base_string.getBytes());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LogManager.getLogger(OAuth.class).warn("unexpected", (Throwable)e);
        }
        return result;
    }
}

