/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.tools;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ColumnNameGeneratorUtil {
    private HashMap<String, Integer> map = new HashMap();
    private List<String> finalColumnNames = new ArrayList<String>();
    private Style style = Style.FLAT;
    private Case forceColumnCase;

    private String formatCase(String baseColName) {
        if (this.forceColumnCase != null) {
            if (this.forceColumnCase.equals((Object)Case.LOWER)) {
                baseColName = baseColName.toLowerCase();
            } else if (this.forceColumnCase.equals((Object)Case.UPPER)) {
                baseColName = baseColName.toUpperCase();
            }
        } else if (this.style == Style.FLAT) {
            baseColName = baseColName.toLowerCase();
        } else if (this.style == Style.NORMALIZE) {
            baseColName = baseColName.toUpperCase();
        } else if (this.style == Style.PRESERVE) {
            // empty if block
        }
        return baseColName;
    }

    public ColumnNameGeneratorUtil(Style s) {
        if (s != null) {
            this.style = s;
        }
    }

    public ColumnNameGeneratorUtil(Style s, Case forceColumnCase) {
        if (s != null) {
            this.style = s;
        }
        if (forceColumnCase != null) {
            this.forceColumnCase = forceColumnCase;
        }
    }

    public String addColumnName(String baseColName) {
        if (this.style == Style.PRESERVE) {
            return this.addColumnNameODBC(baseColName);
        }
        if (this.style == Style.NORMALIZE) {
            return this.addColumnNameNormalized(baseColName);
        }
        return this.addColumnNameGOOGLE(baseColName);
    }

    private String addColumnNameNormalized(String baseColName) {
        Object colName = this.normalizeColumnName(baseColName);
        Integer i = this.map.get(colName);
        if (i != null) {
            Integer n = i;
            i = i + 1;
            this.map.put((String)colName, i);
            colName = (String)colName + "_" + i;
        } else {
            this.map.put((String)colName, 1);
        }
        this.finalColumnNames.add((String)colName);
        return colName;
    }

    private String addColumnNameGOOGLE(String baseColName) {
        Object colName = this.formatColumnName(baseColName);
        Integer i = this.map.get(colName);
        if (i != null) {
            Integer n = i;
            i = i + 1;
            this.map.put((String)colName, i);
            colName = (String)colName + "_" + i;
        } else {
            this.map.put((String)colName, 1);
        }
        this.finalColumnNames.add((String)colName);
        return colName;
    }

    private String addColumnNameODBC(String baseColName) {
        baseColName = this.formatCase((String)baseColName);
        Integer i = null;
        for (String columName : this.map.keySet()) {
            if (columName == null || !columName.equalsIgnoreCase((String)baseColName)) continue;
            i = this.map.get(columName);
        }
        if (i != null) {
            Iterator<String> iterator = i;
            i = i + 1;
            this.map.put((String)baseColName, i);
            baseColName = (String)baseColName + i;
            this.map.put((String)baseColName, 0);
        } else {
            this.map.put((String)baseColName, 0);
        }
        this.finalColumnNames.add((String)baseColName);
        return baseColName;
    }

    public List<String> getColumnNames() {
        return this.finalColumnNames;
    }

    private String normalizeColumnName(String baseColName) {
        String convertedString = Normalizer.normalize(this.formatCase(baseColName), Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "").replaceAll("[^a-zA-Z0-9]", "");
        return convertedString;
    }

    private String formatColumnName(String colName) {
        String res = this.formatCase(colName);
        res = res.replaceAll("[^a-z0-9\\-\\.\t\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00f1\u00fe\u00ff]", "");
        return res;
    }

    public static String unformatColumnName(Style style, String colName) {
        if (style == Style.FLAT) {
            if (colName.matches(".*_[0-9]*")) {
                return colName.replaceAll("_[0-9]*", "");
            }
            return colName;
        }
        return colName;
    }

    public boolean supportColumnName(String columnName) {
        if (this.style == Style.FLAT) {
            String res = columnName.toLowerCase();
            res = res.replaceAll("[^a-z0-9\\-\\.\t\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00f1\u00fe\u00ff]", "");
            return res.equals(columnName.toLowerCase());
        }
        return true;
    }

    public static enum Case {
        UPPER,
        LOWER;

    }

    public static enum Style {
        FLAT,
        PRESERVE,
        NORMALIZE;

    }
}

