/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.jdbc.tools;

import com.stambia.udriver.jdbc.tools.Messages;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryDescriptorParser {
    String tablesString;
    String columnsString;
    String datatypesString;
    String consumeGroupAlias;
    QueryDescriptorParserConfig config = new QueryDescriptorParserConfig();
    public Map<String, TableDesc> tables = new HashMap<String, TableDesc>();
    public Map<String, ColumnDesc> columns = new HashMap<String, ColumnDesc>();
    public List<ColumnDesc> columnsList = new ArrayList<ColumnDesc>();

    public QueryDescriptorParser(String version) throws Exception {
        assert (version != null && version.equals("1")) : Messages.getString("QueryDescriptorParser.0");
    }

    public QueryDescriptorParser(String version, QueryDescriptorParserConfig config) {
        assert (version != null && version.equals("1")) : Messages.getString("QueryDescriptorParser.1");
        this.config = config;
    }

    public void parse(String tablesString, String columnsString, String datatypesString, String consumeGroupAlias, String scalesString, String precisionsString) throws SQLException {
        this.tablesString = tablesString;
        this.columnsString = columnsString;
        this.datatypesString = datatypesString;
        this.consumeGroupAlias = consumeGroupAlias;
        this.tables.clear();
        this.columns.clear();
        String[] tablesArray = tablesString.trim().split(this.config.tableSeparator);
        int i = 0;
        for (String _table : tablesArray) {
            TableDesc table = this.parseTable(_table);
            if (this.tables.get(table.name) != null) {
                throw new SQLException();
            }
            this.tables.put(table.name, table);
            ++i;
        }
        List<String> dataTypesList = this.splitToList(datatypesString, ",");
        List<String> scalesList = this.splitToList(scalesString, ",");
        List<String> precisionsList = this.splitToList(precisionsString, ",");
        i = 0;
        for (String _column : columnsString.trim().split(",")) {
            ColumnDesc col = this.parseColumn(_column);
            if (this.columns.get(col.alias) != null) {
                throw new SQLException();
            }
            this.columns.put(col.alias, col);
            this.columnsList.add(col);
            if (dataTypesList.size() > i) {
                col.datatype = dataTypesList.get(i);
                if (col.datatype.contentEquals("decimal") || col.datatype.contentEquals("numeric")) {
                    if (scalesList.size() > i && precisionsList.size() > i) {
                        try {
                            col.scale = Integer.valueOf(scalesList.get(i));
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(Messages.getString("QueryDescriptorParser.2"));
                        }
                        try {
                            col.precision = Integer.valueOf(precisionsList.get(i));
                        }
                        catch (NumberFormatException e) {
                            throw new SQLException(Messages.getString("QueryDescriptorParser.3"));
                        }
                    }
                    throw new SQLException(Messages.getString("QueryDescriptorParser.4"));
                }
            } else {
                throw new SQLException();
            }
            ++i;
        }
        for (TableDesc td : this.tables.values()) {
            td.columns.addAll(this.columnsList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColumnDesc parseColumn(String colExp) throws SQLException {
        ColumnDesc column = new ColumnDesc();
        String colTrim = colExp.trim();
        while (colTrim.contains("  ")) {
            colTrim = colTrim.replace("  ", " ");
        }
        String[] parts = colTrim.split(this.config.tableColumnSeparator);
        if (parts.length == 1) {
            colTrim = parts[0];
        } else {
            if (parts.length != 2) throw new SQLException(Messages.getString("QueryDescriptorParser.6"));
            if (this.consumeGroupAlias == null || !parts[0].equals(this.consumeGroupAlias)) throw new SQLException(Messages.getString("QueryDescriptorParser.5"));
            colTrim = parts[1];
        }
        colTrim = colTrim.trim();
        parts = colTrim.split(" ");
        if (parts.length == 1) {
            column.alias = column.name = parts[0];
            return column;
        } else {
            if (parts.length != 2) throw new SQLException(Messages.getString("QueryDescriptorParser.7"));
            column.name = parts[0];
            column.alias = parts[1];
        }
        return column;
    }

    private TableDesc parseTable(String table) throws SQLException {
        while (table.contains("  ")) {
            table = table.replace("  ", " ");
        }
        TableDesc ttable = new TableDesc();
        ttable.fullName = table;
        if (this.config.tableSchemaSeparator != null) {
            String[] parts = table.split(this.config.tableSchemaSeparator);
            if (parts.length == 1) {
                table = parts[0];
            } else if (parts.length == 2) {
                ttable.schema = parts[0];
                table = parts[1];
            } else {
                throw new SQLException(Messages.getString("QueryDescriptorParser.8"));
            }
        }
        ttable.name = table = table.trim();
        return ttable;
    }

    private List<String> splitToList(String str, String sep) {
        ArrayList<String> elements = new ArrayList<String>();
        if (str != null) {
            for (String el : str.trim().split(sep)) {
                elements.add(el.trim());
            }
        }
        return elements;
    }

    public static void main(String[] args) throws Exception {
        QueryDescriptorParser tpd = new QueryDescriptorParser("1");
        tpd.parse("topics01 t01,topics02 t02", "t01.col,t02.col2 c", "string, string", "", "", "");
        System.out.println(tpd.tables);
    }

    public static class QueryDescriptorParserConfig {
        public String tableColumnSeparator = "\\.";
        public String tableAliasSeparator = " ";
        public String columnAliasSeparator = " ";
        public String tableSeparator = ",";
        public String columnSeparator = ",";
        public String tableSchemaSeparator = "\\.";
    }

    public static class TableDesc {
        public String schema;
        public String fullName;
        public String name;
        public List<ColumnDesc> columns = new ArrayList<ColumnDesc>();

        public String toString() {
            return "Table [schema=" + this.schema + ", name=" + this.name + ", columns=" + String.valueOf(this.columns) + "]";
        }
    }

    public static class ColumnDesc {
        public String name;
        public String alias;
        public String datatype;
        public int scale;
        public int precision;

        public String toString() {
            return "Column [name=" + this.name + ", alias=" + this.alias + ", datatype=" + this.datatype + "]";
        }
    }
}

