/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.Global;
import com.indy.engine.Messages;
import com.indy.engine.common.sql.SqlUtils;
import com.indy.engine.main.connections.tools.JdbcFunctions;
import com.indy.engine.userLog.RdbmsUserLog;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.runtime.sessionlog.RdbmsLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InternalDatabase {
    private static final Logger logger = LogManager.getLogger(InternalDatabase.class);
    private Map<String, String> lstSystemLogProperties = Global.getLstLogParametersInRepository(Global.USERLOG_DEFAULT_NAME);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepareSystemSchedulerDatabase(String url, String user, String password) throws EngineExceptionI {
        block35: {
            Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "preparing internal Scheduler Database !", 0, 0, "INFO");
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    Connection jdbcConnection = JdbcFunctions.rapidConnect("org.hsqldb.jdbcDriver", url, user, password, null, "HSQL");
                    try {
                        block34: {
                            try (Statement dmlStatement = jdbcConnection.createStatement();){
                                String txtCode = "CREATE SCHEMA SCHEDULER";
                                Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", txtCode, 0, 0, "INFO");
                                Object sqlQuery = "";
                                try {
                                    Throwable throwable2 = null;
                                    Object var11_16 = null;
                                    try {
                                        FileReader fr = new FileReader(new File(System.getProperty("com.indy.engine.installation.folder", ".") + "/scripts/scheduler/tables_hsql.sql"));
                                        try {
                                            try (BufferedReader br = new BufferedReader(fr);){
                                                Iterator iterator;
                                                dmlStatement.execute(txtCode);
                                                while (true) {
                                                    String thisLine;
                                                    if ((thisLine = br.readLine()) == null) {
                                                        iterator = SqlUtils.splitSqlScript((String)sqlQuery, (String)";", (String[])new String[]{"--|\n", "/\\*|\\*/", "'"}).iterator();
                                                        break;
                                                    }
                                                    sqlQuery = (String)sqlQuery + thisLine + "\n";
                                                }
                                                while (iterator.hasNext()) {
                                                    String o = (String)iterator.next();
                                                    try {
                                                        Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Execute Query:\n" + o, 0, 0, "INFO");
                                                        dmlStatement.execute(o);
                                                    }
                                                    catch (Exception e) {
                                                        Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Exception " + e.getMessage(), 0, 0, "INFO");
                                                    }
                                                }
                                            }
                                            if (fr == null) break block34;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            if (fr == null) throw throwable2;
                                            fr.close();
                                            throw throwable2;
                                        }
                                        fr.close();
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable4;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable4) throw throwable2;
                                        throwable2.addSuppressed(throwable4);
                                        throw throwable2;
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug(Messages.getString("InternalDatabase.2"), (Throwable)e);
                                    Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Exception " + e.getMessage(), 0, 0, "INFO");
                                }
                            }
                        }
                        if (jdbcConnection == null) break block35;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (jdbcConnection == null) throw throwable;
                        jdbcConnection.close();
                        throw throwable;
                    }
                    jdbcConnection.close();
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.debug(Messages.getString("InternalDatabase.2"), (Throwable)e);
                Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Exception " + e.getMessage(), 0, 0, "INFO");
                throw new EngineExceptionI((Throwable)e);
            }
        }
        Global.dLog.write("EngineServerI=>prepareSystemSchedulerDatabase()", "Internal Scheduler Database prepared!", 0, 0, "INFO");
    }

    public InternalDatabase() throws EngineExceptionI {
        if (this.lstSystemLogProperties == null) {
            throw new EngineExceptionI("Impossible to find configuration for: " + Global.USERLOG_DEFAULT_NAME);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareSystemDatabase() throws EngineExceptionI {
        block20: {
            if (!this.lstSystemLogProperties.get("userLogClass").equals(RdbmsUserLog.class.getName())) {
                if (!this.lstSystemLogProperties.get("userLogClass").equals(RdbmsLogger.class.getName())) return;
            }
            Global.dLog.write("EngineServerI=>prepareSystemDatabase()", "preparing internal Database !", 0, 0, "INFO");
            String userDriver = this.lstSystemLogProperties.get("userLogRdbmsDriver");
            if (userDriver.equals("org.hsqldb.jdbcDriver")) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        Connection jdbcConnection = JdbcFunctions.rapidConnect(this.lstSystemLogProperties.get("userLogRdbmsDriver"), this.lstSystemLogProperties.get("userLogRdbmsUrl"), this.lstSystemLogProperties.get("userLogRdbmsUser"), this.lstSystemLogProperties.get("userLogRdbmsPassword"), this.lstSystemLogProperties.get("userLogRdbmsEncryptedPassword"), this.lstSystemLogProperties.get("userLogRdbmsModule"));
                        try {
                            block19: {
                                try (Statement dmlStatement = jdbcConnection.createStatement();){
                                    Object sqlSchemaName = this.lstSystemLogProperties.get("userLogRdbmsSchemaName");
                                    if (sqlSchemaName != null) {
                                        String txtCode = "CREATE SCHEMA " + (String)sqlSchemaName;
                                        try {
                                            dmlStatement.execute(txtCode);
                                        }
                                        catch (Exception e) {
                                            logger.debug("cannot create schema", (Throwable)e);
                                        }
                                        sqlSchemaName = (String)sqlSchemaName + ".";
                                        break block19;
                                    }
                                    sqlSchemaName = "";
                                }
                            }
                            if (jdbcConnection == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (jdbcConnection == null) throw throwable;
                            jdbcConnection.close();
                            throw throwable;
                        }
                        jdbcConnection.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        Global.dLog.write("EngineServerI=>prepareSystemDatabase()", "Internal Database prepared!", 0, 0, "INFO");
    }
}

