/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MacAddress {
    private static final Logger LOGGER = LogManager.getLogger(MacAddress.class);
    String arg;

    public static void main(String[] args) {
        new MacAddress();
        LOGGER.info(MacAddress.list());
    }

    public MacAddress() {
    }

    public MacAddress(String print) {
        LOGGER.info(print);
    }

    public static String list() {
        HashSet<String> l = new HashSet<String>();
        Object result = "";
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface interfaceN = interfaces.nextElement();
                    byte[] b = interfaceN.getHardwareAddress();
                    Object tmp = "";
                    if (b != null) {
                        int j = 0;
                        while (j < b.length) {
                            tmp = (String)tmp + String.format("%02X%s", b[j], j < b.length - 1 ? "-" : "");
                            ++j;
                        }
                    }
                    if (((String)tmp).isEmpty() || l.contains(tmp)) continue;
                    result = (String)result + interfaceN.getDisplayName() + ": " + (String)tmp + "(" + interfaceN.isVirtual() + ")\n";
                    l.add((String)tmp);
                }
                catch (Exception e1) {
                    LOGGER.warn("error getting mac address", (Throwable)e1);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.warn("error getting mac address", (Throwable)e1);
        }
        return result;
    }
}

