/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command.impl;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.command.impl.Messages;
import com.indy.engine.command.impl.RuntimeCommand;
import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.core.IEngineClient;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

@CommandLine(startWith="restart session", removeString="restart", usage="restart session <id> [synch [format %<columnName>[,<%columnName2>...]]]", description="restart the session <id>")
public class RestartSessionCommand
implements RuntimeCommand {
    @CommandParameter(name="session", valueSample="sessionId", usage="Session ID", required=true)
    public String sessId;
    @CommandParameter(name="format")
    public String format;
    @CommandParameter(name="synch")
    public Boolean synch;

    @Override
    public void execute(IEngineClient engineAPI, PrintStream out, Map<String, Object> ctx) throws Exception {
        if (!(this.format == null || this.synch != null && this.synch.booleanValue())) {
            out.print(Messages.getString("RestartSessionCommand.0"));
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sessionId", this.sessId);
        try {
            engineAPI.restartSession(parameters);
            if (this.isSynch()) {
                out.println(Messages.getString("RestartSessionCommand.1") + this.sessId + Messages.getString("RestartSessionCommand.2"));
                HashMap<String, String> parameters2 = new HashMap<String, String>();
                parameters2.put("sessionId", this.sessId);
                Map ret = engineAPI.waitSession(parameters2);
                if (ctx != null) {
                    ctx.put("lastExecutionDeliveryReturnCode", ret.get("returnCode"));
                }
                if (this.format == null) {
                    this.format = "%id,%status,%returncode";
                }
                this.format(this.sessId, engineAPI, out);
            } else {
                out.print(Messages.getString("RestartSessionCommand.3") + this.sessId + Messages.getString("RestartSessionCommand.4"));
            }
        }
        catch (Exception e) {
            throw new Exception(String.format(Messages.getString("RestartSessionCommand.5"), this.sessId, e.getMessage()), e);
        }
    }

    private boolean isSynch() {
        return this.synch != null && this.synch != false;
    }

    private void format(String id, IEngineClient engineAPI, PrintStream out) throws Exception {
        Map session = engineAPI.getSessionInfo(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Map<String, InternalEngineCommandsI.Column> columns = InternalEngineCommandsI.createSessionsColumns(this.format != null && (this.format.contains("errormessage") || this.format.contains("exception")));
        InternalEngineCommandsI.fillSessionsColumns(columns, session, sdf, engineAPI);
        out.println(InternalEngineCommandsI.formatList2(columns, this.format));
    }
}

