/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.connections;

import com.indy.engine.core.main.connections.RuntimeConnection;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceConfiguration;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JdbcRuntimeConnection
implements RuntimeConnection<Connection> {
    private final DataSource dataSource;
    private Connection currentConnection = null;

    public JdbcRuntimeConnection(DataSourceConfiguration configuration) {
        this.dataSource = DataSourceManager.instance().getDataSource(configuration);
    }

    public int close(boolean commitTrans) throws EngineExceptionI {
        if (this.currentConnection != null) {
            try {
                if (commitTrans) {
                    if (!this.currentConnection.getAutoCommit()) {
                        this.currentConnection.commit();
                    }
                } else if (!this.currentConnection.getAutoCommit()) {
                    this.currentConnection.rollback();
                }
                this.currentConnection.close();
                this.currentConnection = null;
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return 1;
    }

    public Connection getUnderlyingConnection() throws EngineExceptionI {
        try {
            if (this.currentConnection == null) {
                this.currentConnection = this.dataSource.getConnection();
            }
            return this.currentConnection;
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }
}

