/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.repository.impl;

import com.indy.engine.Global;
import com.indy.engine.core.repository.DeliveryRepositoryPluginUtils;
import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.IDeliveryRepositoryPlugin;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Utils;
import com.indy.engine.main.repository.impl.Messages;
import com.indy.engine.main.repository.stores.FileRepositoryStore;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.engine.wsdl.WsdlAPI;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;

public final class FileRepository
implements IDeliveryRepositoryPlugin {
    private FileRepositoryStore fileRepositoryStore;
    private final File repositoryFolder;
    private final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> deliveriesInfo = Collections.synchronizedMap(new HashMap());
    private WsdlAPI wsdlApi = null;
    private boolean isWebservice = false;
    private static final Pattern pattern = Pattern.compile("(.*)(\\." + Global.DELIVERY_EXTENSION + ")");
    private static final String extension = "." + Global.DELIVERY_EXTENSION;
    private static final FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File directory, String name) {
            Matcher matcher = pattern.matcher(name);
            boolean match = matcher.matches();
            return match;
        }
    };

    public FileRepository(IPluginFactory.IPluginConfiguration conf, IPluginFactory.IRelativePathResolver resolver) {
        this.fileRepositoryStore = new FileRepositoryStore(conf, resolver);
        this.repositoryFolder = this.fileRepositoryStore.getAbsoluteFolder();
        if (this.repositoryFolder != null && !this.repositoryFolder.exists()) {
            this.repositoryFolder.mkdirs();
        }
        this.isWebservice = Boolean.valueOf(conf.getProperty("webservice"));
    }

    public final File getDeliveryContent(IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo) throws Exception {
        if (deliveryInfo != null && deliveryInfo.getFile() != null && deliveryInfo.getFile().exists()) {
            return deliveryInfo.getFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> getDeliveriesInfo(boolean refresh) throws Exception {
        Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> map = this.deliveriesInfo;
        synchronized (map) {
            if (refresh && this.repositoryFolder != null && this.repositoryFolder.exists()) {
                File[] filesArray = this.repositoryFolder.listFiles(filenameFilter);
                List<File> files = Arrays.asList(filesArray);
                HashSet<String> unexist = new HashSet<String>(this.deliveriesInfo.keySet());
                for (File file : files) {
                    unexist.remove(file.getName());
                    this.synch(file);
                }
                for (String key : unexist) {
                    this.deliveriesInfo.remove(key);
                }
            }
            return new HashMap<String, IDeliveryRepositoryPlugin.DeliveryInfo>(this.deliveriesInfo);
        }
    }

    IDeliveryRepositoryPlugin.DeliveryInfo synch(String deliveryName) throws Exception {
        return this.synch(this.getFile(deliveryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDeliveryRepositoryPlugin.DeliveryInfo synch(File file) throws Exception {
        Map<String, IDeliveryRepositoryPlugin.DeliveryInfo> map = this.deliveriesInfo;
        synchronized (map) {
            IDeliveryRepositoryPlugin.DeliveryInfo info = this.deliveriesInfo.get(file.getName());
            if (file.exists()) {
                if ((info == null || info.getLastModified() != file.lastModified()) && (info = this.getDeliveryInfo(file)) != null) {
                    this.deliveriesInfo.put(file.getName(), info);
                }
            } else {
                if (info != null) {
                    this.deliveriesInfo.remove(file.getName());
                }
                info = null;
            }
            return info;
        }
    }

    public final IDeliveryRepositoryPlugin.DeliveryInfo putDelivery(InputStream inputStream, String deliveryName) throws Exception {
        if (deliveryName == null || inputStream == null) {
            throw new Exception(Messages.getString("FileRepository.0"));
        }
        File file = this.getFile(deliveryName);
        DeliveryRepositoryPluginUtils.writeDelivery((File)file, (InputStream)inputStream);
        file = this.getFile(deliveryName);
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = this.synch(file);
        if (deliveryInfo != null) {
            this.deliveriesInfo.put(deliveryInfo.getName(), deliveryInfo);
        }
        return deliveryInfo;
    }

    public final void removeDelivery(String deliveryName) throws Exception {
        if (deliveryName != null) {
            File file = this.getFile(deliveryName);
            if (file.exists()) {
                Files.delete(file.toPath());
                this.deliveriesInfo.remove(deliveryName);
            } else {
                throw new IOException(Messages.getString("FileRepository.2") + deliveryName + Messages.getString("FileRepository.3"));
            }
        }
    }

    private IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(File file) throws Exception {
        IDeliveryRepositoryPlugin.DeliveryInfo deliveryInfo = new IDeliveryRepositoryPlugin.DeliveryInfo();
        if (this.wsdlApi == null && this.isWebservice && Global.engineServer != null) {
            this.wsdlApi = Global.engineServer.getWsdlAPI();
        }
        try {
            Delivery delivery = Utils.parseDelivery(file, this.wsdlApi, false);
            if (delivery != null) {
                String id = delivery.getId();
                String name = delivery.getName();
                String version = delivery.getVersion();
                deliveryInfo.setId(id);
                deliveryInfo.setName(name);
                deliveryInfo.setVersion(version);
                deliveryInfo.setFile(file);
                long lastModified = file.lastModified();
                deliveryInfo.setLastModified(lastModified);
            }
        }
        catch (SAXParseException e) {
            return null;
        }
        return deliveryInfo;
    }

    private static String extendDeliveryName(String deliveryName) {
        Object extentedName = deliveryName.endsWith(extension) ? deliveryName : deliveryName + extension;
        return extentedName;
    }

    protected File getFile(String deliveryName) throws IOException {
        if (this.repositoryFolder != null && !this.repositoryFolder.exists()) {
            this.repositoryFolder.mkdirs();
        }
        if (this.repositoryFolder == null) {
            throw new IOException("repositoryFolder is null");
        }
        Path repositoryPath = this.repositoryFolder.toPath().normalize();
        String extendedName = FileRepository.extendDeliveryName(deliveryName);
        File file = new File(String.valueOf(repositoryPath) + File.separator + extendedName);
        if (!file.toPath().normalize().startsWith(repositoryPath)) {
            throw new IOException("Entry " + extendedName + " is outside of the target directory " + String.valueOf(this.repositoryFolder));
        }
        return file;
    }

    public IDeliveryRepositoryInfo getInfos() {
        return this.fileRepositoryStore;
    }

    public IDeliveryRepositoryPlugin.DeliveryInfo getDeliveryInfo(String deliveryName) throws Exception {
        return this.synch(deliveryName);
    }

    public void setCacheFolder(File cacheFolder) {
    }
}

