/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.scripting;

import com.indy.engine.command.impl.InternalEngineCommandsI;
import com.indy.engine.common.actioncodes.connection.JdbcConnectionManager;
import com.indy.engine.common.compiler.impl.StambiaJavaCompilerFactoryImpl;
import com.indy.engine.core.IActionBind;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.IModuleAccess;
import com.indy.engine.core.IScriptContext;
import com.indy.engine.core.IXmlUtils;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.classloader.DirectoryClassLoader;
import com.indy.engine.core.classloader.IClassLoader;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.compiler.StambiaJavaCompiler;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.jdbc.INamedResultSetsProcessor;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.core.jdbc.IResultSetPreviousRowComparator;
import com.indy.engine.core.jdbc.IResultSetsKeyPairComparator;
import com.indy.engine.core.manager.IActionContext;
import com.indy.engine.core.manager.INamedObjectManager;
import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.core.module.classloader.StambiaClassLoaderRegistry;
import com.indy.engine.core.naming.IInitialContextManager;
import com.indy.engine.main.EngineContextI;
import com.indy.engine.main.scripting.Messages;
import com.indy.engine.manager.Action;
import com.indy.engine.naming.impl.InitialContextManager;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.indy.runtime.api.impl.jdbc.NamedResultSetsProcessor;
import com.indy.runtime.api.impl.jdbc.ResultSetPreviousRowComparator;
import com.indy.runtime.api.impl.jdbc.ResultSetsKeyPairComparator;
import com.semarchy.xdi.engine.common.EngineFactory;
import com.semarchy.xdi.engine.common.exceptions.ActionExceptionI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptContextI
implements IScriptContext {
    EngineContextI engineContext = null;
    IActionContext actionContext = null;
    String executionType = null;
    public Object retValue = null;
    private final Logger logger = LogManager.getLogger(this.getClass());
    JdbcPreparedStatementToResultSet jpstrs = null;
    List<JdbcPreparedStatementToResultSet> jpstrsl = Collections.synchronizedList(new ArrayList());
    public static IJsonUtils jsonUtils;
    public static IXmlUtils xmlUtils;
    List<JdbcConnectionManager> connections;

    public ScriptContextI(IActionContext act, EngineContextI engineContext, String pExecutionType) {
        try {
            jsonUtils = UtilsService.getJsonUtils();
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
        try {
            xmlUtils = UtilsService.getXmlUtils();
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
        this.connections = new ArrayList<JdbcConnectionManager>();
        this.actionContext = act;
        this.engineContext = engineContext;
        this.executionType = pExecutionType;
    }

    public void publishVariable(String name, String value) {
        this.publishVariable(name, value, null, false);
    }

    public IClassLoader getDirectoryClassLoader(String path) throws Exception {
        return DirectoryClassLoader.getLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)path, (Logger)LogManager.getLogger((String)DirectoryClassLoader.class.getName()));
    }

    public void publishVariable(String name, String value, String type) {
        this.publishVariable(name, value, type, false);
    }

    public void publishVariable(String name, String value, boolean pRealTimeReport) {
        this.publishVariable(name, value, null, pRealTimeReport);
    }

    public void publishVariable(String name, String value, String type, boolean pRealTimeReport) {
        this.engineContext.addVariable(name, this.actionContext.getActionName(), value, type, pRealTimeReport, false);
    }

    public void publishCumulativeVariable(String name, String value) {
        this.publishCumulativeVariable(name, value, null, false);
    }

    public void publishCumulativeVariable(String name, String value, String type) {
        this.publishCumulativeVariable(name, value, type, false);
    }

    public void publishCumulativeVariable(String name, String value, boolean pRealTimeReport) {
        this.publishCumulativeVariable(name, value, null, pRealTimeReport);
    }

    public void publishCumulativeVariable(String name, String value, String type, boolean pRealTimeReport) {
        this.engineContext.addVariable(name, this.actionContext.getActionName(), value, type, pRealTimeReport, true);
    }

    public long getCurrentBindIteration() {
        return this.actionContext.getCurrentBindIteration();
    }

    public String sumVariable(String vName) {
        return this.sumVariable(vName, "/");
    }

    public String averageVariable(String vName) {
        return this.averageVariable(vName, "/");
    }

    public String countVariable(String vName) {
        return this.countVariable(vName, "/");
    }

    public String minVariable(String vName) {
        return this.minVariable(vName, "/");
    }

    public String maxVariable(String vName) {
        return this.maxVariable(vName, "/");
    }

    public String sumVariable(String vName, String startingPath) {
        String v = "0";
        try {
            v = this.engineContext.aggregateVariable(this.actionContext.getActionName(), vName, 1, startingPath, "$NO_SCRIPT$").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String countVariable(String vName, String startingPath) {
        String v = "0";
        try {
            v = this.engineContext.aggregateVariable(this.actionContext.getActionName(), vName, 5, startingPath, "$NO_SCRIPT$").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String averageVariable(String vName, String startingPath) {
        String v = "0";
        try {
            v = this.engineContext.aggregateVariable(this.actionContext.getActionName(), vName, 4, startingPath, "$NO_SCRIPT$").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String minVariable(String vName, String startingPath) {
        String v = "0";
        try {
            v = this.engineContext.aggregateVariable(this.actionContext.getActionName(), vName, 2, startingPath, "$NO_SCRIPT$").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public String maxVariable(String vName, String startingPath) {
        String v = "0";
        try {
            v = this.engineContext.aggregateVariable(this.actionContext.getActionName(), vName, 3, startingPath, "$NO_SCRIPT$").getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    private int getIntTypeAggreg(String tAggreg) {
        int typeAggreg = 1;
        if (tAggreg.equalsIgnoreCase("sum")) {
            typeAggreg = 1;
        } else if (tAggreg.equalsIgnoreCase("count")) {
            typeAggreg = 5;
        } else if (tAggreg.equalsIgnoreCase("min")) {
            typeAggreg = 2;
        } else if (tAggreg.equalsIgnoreCase("max")) {
            typeAggreg = 3;
        } else if (tAggreg.equalsIgnoreCase("avg")) {
            typeAggreg = 4;
        }
        return typeAggreg;
    }

    public int aggregateVariable(String vName, String tAggreg) {
        int typeAggreg = this.getIntTypeAggreg(tAggreg);
        return this.aggregateVariable(vName, typeAggreg, "/");
    }

    public int aggregateVariable(String vName, String tAggreg, String startingPath) {
        int typeAggreg = this.getIntTypeAggreg(tAggreg);
        return this.aggregateVariable(vName, typeAggreg, startingPath);
    }

    public int aggregateVariable(String vName, int typeAggreg, String startingPath) {
        String v = "0";
        int retVal = 0;
        try {
            v = this.engineContext.aggregateVariable(this.actionContext.getActionName(), vName, typeAggreg, startingPath, "$NO_SCRIPT$").getValue();
            retVal = Integer.valueOf(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public Runtime getRuntime() {
        return Runtime.getRuntime();
    }

    public String getVariableValue(String vName) {
        String ret = "";
        try {
            ret = this.engineContext.getExpressionVariable(vName, this.actionContext.getActionName()).getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String getVariableSource(String vName) {
        String ret = "";
        try {
            ret = this.engineContext.getExpressionVariable(vName, this.actionContext.getActionName()).getSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public Object getVariableCumulativeValue(String vName) {
        Object ret = null;
        try {
            ret = this.engineContext.getExpressionVariable(vName, this.actionContext.getActionName()).getCumulativeValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public List<Variable> getLstVariablesByName(String vName) {
        return this.getLstVariablesByName(vName);
    }

    public List<Variable> getLstVariablesByName(String vName, boolean withErrors) {
        return this.getLstVariablesByName(vName, "~/", withErrors);
    }

    public List<Variable> getLstVariablesByName(String vName, String startingPath) {
        ArrayList<Variable> al = null;
        Map<String, Variable> tm = this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), vName, startingPath, false);
        al = tm != null ? new ArrayList<Variable>(tm.values()) : new ArrayList<Variable>();
        return al;
    }

    public List<Variable> getLstVariablesByName(String vName, String startingPath, boolean withErrors) {
        ArrayList<Variable> al = null;
        Map<String, Variable> tm = this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), vName, startingPath, withErrors);
        al = tm != null ? new ArrayList<Variable>(tm.values()) : new ArrayList<Variable>();
        return al;
    }

    public Map<String, Variable> getVariableTreeByName(String vName) {
        return this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), vName, "~/", false);
    }

    public Map<String, Variable> getVariableTreeByName(String vName, String startingPath) {
        return this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), vName, startingPath, false);
    }

    public Map<String, Variable> getVariableTreeByName(String vName, boolean withErrors) {
        return this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), vName, "~/", withErrors);
    }

    public Map<String, Variable> getVariableTreeByName(String vName, String startingPath, boolean withErrors) {
        return this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), vName, startingPath, withErrors);
    }

    public List<Variable> getLstErrors() {
        return this.getLstErrors("~/");
    }

    public List<Variable> getLstErrors(String startingPath) {
        ArrayList<Variable> al = null;
        Map<String, Variable> tm = this.engineContext.getLstSessionVariablesByName(this.actionContext.getActionName(), VariableType.CORE_RET_MESS.getName(), startingPath, true);
        al = tm != null ? new ArrayList<Variable>(tm.values()) : new ArrayList<Variable>();
        return al;
    }

    public void throwException(String exceptionMsg) throws ActionExceptionI {
        throw new ActionExceptionI(exceptionMsg);
    }

    private String privateDecryptPassword(String encryptedPassword) {
        if (this.executionType.equals("s")) {
            try {
                return this.actionContext.decryptString(encryptedPassword);
            }
            catch (EngineExceptionI e) {
                this.logger.warn("Error decrypting password", (Throwable)e);
            }
        }
        return "";
    }

    @Deprecated
    public String decryptPassword(String encryptedPassword) {
        return this.privateDecryptPassword(encryptedPassword);
    }

    public String password(String encryptedPassword) {
        return this.privateDecryptPassword(encryptedPassword);
    }

    public Object newInstance(ClassLoader classLoader, String name) throws SecurityException, IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.newInstance(classLoader, name, null);
    }

    public Object newInstance(ClassLoader classLoader, String name, Object[] initargs) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        return this.initClass(name, initargs, classLoader);
    }

    public StambiaJavaCompiler createJavaCompiler() {
        return this.createJavaCompiler(this.getClass().getClassLoader());
    }

    public StambiaJavaCompiler createJavaCompiler(ClassLoader parentClassLoader) {
        return StambiaJavaCompilerFactoryImpl.INSTANCE.newCompiler(parentClassLoader);
    }

    public void addSessionClassLoader(String name, ClassLoader cl) throws Exception {
        this.actionContext.getEngineContext().addSessionClassLoader(name, cl);
    }

    public ClassLoader getSessionClassLoader(String name) throws Exception {
        return this.actionContext.getEngineContext().getSessionClassLoader(name);
    }

    public ClassLoader createClassLoaderFromDir(ClassLoader parentClassLoader, String file, boolean deeply, String filterExtension) throws Exception {
        if (filterExtension != null) {
            return StambiaJavaCompilerFactoryImpl.INSTANCE.createClassLoaderFromDir(parentClassLoader, file, deeply, filterExtension.split("\\|"));
        }
        return StambiaJavaCompilerFactoryImpl.INSTANCE.createClassLoaderFromDir(parentClassLoader, file, deeply, new String[0]);
    }

    @Deprecated
    public Object initClass(String name) throws SecurityException, IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.initClass(name, null);
    }

    @Deprecated
    public Object initClass(String name, Object[] initargs) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        return this.initClass(name, initargs, ClassLoader.getSystemClassLoader());
    }

    @Deprecated
    public Object initClass(String name, Object[] initargs, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Class<?> m = classLoader.loadClass(name);
        if (initargs == null) {
            return m.newInstance();
        }
        ArrayList list = new ArrayList();
        if (initargs != null) {
            Object[] objectArray = initargs;
            int n = initargs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                list.add(o.getClass());
                ++n2;
            }
        }
        Class[] clazzs = new Class[list.size()];
        list.toArray(clazzs);
        Constructor<?> con = m.getConstructor(clazzs);
        return con.newInstance(initargs);
    }

    private IEngineClient getEngineApi() throws Exception {
        return this.engineContext.getEngineApi();
    }

    public List<String> executeCommands(String commands, String commandSeparator) throws Exception {
        ArrayList<String> rets = new ArrayList<String>();
        String[] stringArray = commands.split(commandSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            rets.add(this.executeCommand(this.getEngineApi(), command.trim()));
            ++n2;
        }
        return rets;
    }

    public List<String> executeRemoteCommands(String host, int port, String commands, String commandSeparator) throws Exception {
        return this.executeRemoteCommands(host, port, commands, commandSeparator, null, null);
    }

    public List<String> executeRemoteCommands(String host, int port, String commands, String commandSeparator, String user, String password) throws Exception {
        ArrayList<String> rets = new ArrayList<String>();
        String[] stringArray = commands.split(commandSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            rets.add(this.executeRemoteCommand(host, port, command.trim(), user, password, true));
            ++n2;
        }
        return rets;
    }

    public String executeCommand(String command) throws Exception {
        return this.executeCommand(this.getEngineApi(), command);
    }

    private String executeCommand(IEngineClient runtime, String command) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        InternalEngineCommandsI engineCommands = new InternalEngineCommandsI(ps, runtime, true, true, true, new HashMap<String, Object>());
        engineCommands.executeCommandWithException(command);
        String ret = baos.toString();
        baos.close();
        return ret;
    }

    public String executeRemoteCommand(String host, int port, String command) throws Exception {
        return this.executeRemoteCommand(host, port, command, null, null, true);
    }

    public String executeRemoteCommand(String host, int port, String command, String user, String password) throws Exception {
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("user", user);
        if (password != null && !password.isEmpty()) {
            credentials.put("password", password);
        }
        LocalSession ec = EngineFactory.getEngine((String)host, (int)port, credentials);
        return this.executeCommand(ec.getRemoteObject(), command);
    }

    public String executeRemoteCommand(String host, int port, String command, String user, String password, boolean optionnal) throws Exception {
        return this.executeRemoteCommand(host, port, command, user, password);
    }

    public IInitialContextManager getInitialContextManager() {
        return InitialContextManager.getDefault();
    }

    public IPreparedStatementToResultSet createBindedPreparedStatement() throws EngineExceptionI, SQLException {
        if (this.jpstrs != null) {
            throw new EngineExceptionI(Messages.getString("ScriptContextI.0"));
        }
        IActionBind aBind = this.actionContext.getSrcBind(this.actionContext.getActionName());
        if (aBind != null && !aBind.getLstBindedActions().isEmpty()) {
            String[] ids = new String[aBind.getLstBindedActions().size()];
            int i = 0;
            boolean useFileQueue = false;
            for (Object value : aBind.getLstBindedActions().values()) {
                Action action = (Action)value;
                ids[i++] = action.getActionId();
                if (ids.length <= 1 || action.lstFatherLinks.size() <= 1) continue;
                useFileQueue = true;
            }
            this.jpstrs = new JdbcPreparedStatementToResultSet(){
                boolean bindIsStarted = false;

                public void handleBeforeAdd() throws SQLException {
                    if (!this.bindIsStarted) {
                        try {
                            ScriptContextI.this.actionContext.bindWithTarget(this.getNotFetchedResultSetBindI());
                        }
                        catch (EngineExceptionI e) {
                            throw new SQLException(e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new SQLException(e);
                        }
                        this.bindIsStarted = true;
                    }
                }
            };
            this.jpstrs.setConsumers(useFileQueue, ids);
            this.jpstrsl.add(this.jpstrs);
            return this.jpstrs;
        }
        throw new EngineExceptionI(Messages.getString("ScriptContextI.1"));
    }

    public IPreparedStatementToResultSet createPreparedStatement(boolean autoClose) throws EngineExceptionI, SQLException {
        JdbcPreparedStatementToResultSet statement = new JdbcPreparedStatementToResultSet();
        if (autoClose) {
            this.jpstrsl.add(statement);
        }
        return statement;
    }

    public IPreparedStatementToResultSet createPreparedStatement() throws EngineExceptionI, SQLException {
        return this.createPreparedStatement(true);
    }

    public void close() throws SQLException {
        for (JdbcPreparedStatementToResultSet statement : this.jpstrsl) {
            if (statement == null) continue;
            try {
                statement.end();
            }
            finally {
                statement.close();
            }
        }
        this.jpstrsl.clear();
        for (JdbcConnectionManager jcm : this.connections) {
            jcm.close();
        }
        this.actionContext = null;
    }

    public ResultSet getSourceResultSet() throws SQLException {
        Object o;
        IActionBind a = this.actionContext.getTrgBind(this.actionContext.getActionName());
        if (a != null && (o = a.getBindedObject()) instanceof NotFetchedResultSetBindI) {
            return ((NotFetchedResultSetBindI)o).getResultSet(this.actionContext.getActionId());
        }
        return null;
    }

    public IJsonUtils getJsonUtils() {
        return jsonUtils;
    }

    public void setReturnValue(Object object) {
        this.retValue = null;
    }

    public Object getReturnValue() {
        return this.retValue;
    }

    public INamedObjectManager getNamedObjectManager() {
        return this.actionContext.getNamedObjectManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exposeNamedObject(final String name) throws Exception {
        final INamedObjectManager nom = this.getNamedObjectManager();
        final Object o = nom.waitObject(name);
        IActionBind aBind = this.actionContext.getSrcBind(this.actionContext.getActionName());
        if (aBind != null) {
            String[] ids = new String[aBind.getLstBindedActions().size()];
            int i = 0;
            boolean useFileQueue = false;
            for (Object value : aBind.getLstBindedActions().values()) {
                Action action = (Action)value;
                ids[i++] = action.getActionId();
                if (ids.length <= 1 || action.lstFatherLinks.size() <= 1) continue;
                useFileQueue = true;
            }
            final HashSet set = new HashSet();
            Collections.addAll(set, ids);
            if (o instanceof JdbcPreparedStatementToResultSet) {
                final JdbcPreparedStatementToResultSet jpstrs = (JdbcPreparedStatementToResultSet)o;
                jpstrs.setConsumers(useFileQueue, ids);
                this.actionContext.bindWithTarget(new NotFetchedResultSetBindI(){

                    public ResultSet initResultSet(String id) throws SQLException {
                        return jpstrs.getNotFetchedResultSetBindI().initResultSet(id);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void closeResultSet(String id) throws SQLException {
                        try {
                            try {
                                Set set2 = set;
                                synchronized (set2) {
                                    set.remove(id);
                                    if (set.isEmpty()) {
                                        nom.setCompleted(name);
                                    }
                                }
                            }
                            catch (Exception e) {
                                throw new SQLException(e);
                            }
                        }
                        finally {
                            jpstrs.getNotFetchedResultSetBindI().closeResultSet(id);
                        }
                    }

                    public ResultSet getResultSet(String id) throws SQLException {
                        return jpstrs.getNotFetchedResultSetBindI().getResultSet(id);
                    }
                });
                nom.setReady(name);
                jpstrs.start();
            } else {
                ResultSet rs;
                if (!(o instanceof ResultSet) && !(o instanceof PreparedStatement)) throw new Exception(Messages.getString("ScriptContextI.2") + o.getClass().getName() + " object");
                ResultSet resultSet = rs = o instanceof ResultSet ? (ResultSet)o : ((PreparedStatement)o).executeQuery();
                if (ids.length == 1) {
                    this.actionContext.bindWithTarget(new NotFetchedResultSetBindI(){

                        public ResultSet initResultSet(String id) throws SQLException {
                            return rs;
                        }

                        public void closeResultSet(String id) throws SQLException {
                            try {
                                try {
                                    nom.setCompleted(name);
                                }
                                catch (Exception e) {
                                    throw new SQLException(e);
                                }
                            }
                            finally {
                                rs.close();
                                if (o instanceof PreparedStatement) {
                                    ((PreparedStatement)o).close();
                                }
                            }
                        }

                        public ResultSet getResultSet(String id) throws SQLException {
                            return rs;
                        }
                    });
                    nom.setReady(name);
                } else {
                    Throwable throwable = null;
                    Object var11_12 = null;
                    try (final JdbcPreparedStatementToResultSet localPreparedStatement = new JdbcPreparedStatementToResultSet();){
                        localPreparedStatement.setInputResultSet(rs);
                        localPreparedStatement.setConsumers(useFileQueue, ids);
                        this.actionContext.bindWithTarget(new NotFetchedResultSetBindI(){

                            public ResultSet initResultSet(String id) throws SQLException {
                                return localPreparedStatement.getNotFetchedResultSetBindI().initResultSet(id);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void closeResultSet(String id) throws SQLException {
                                try {
                                    try {
                                        Set set2 = set;
                                        synchronized (set2) {
                                            set.remove(id);
                                            if (set.isEmpty()) {
                                                nom.setCompleted(name);
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new SQLException(e);
                                    }
                                }
                                finally {
                                    localPreparedStatement.getNotFetchedResultSetBindI().closeResultSet(id);
                                }
                            }

                            public ResultSet getResultSet(String id) throws SQLException {
                                return localPreparedStatement.getNotFetchedResultSetBindI().getResultSet(id);
                            }
                        });
                        localPreparedStatement.start();
                        localPreparedStatement.fill();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        }
        this.getNamedObjectManager().waitCompleted(name);
    }

    public Object getConnection(String name, Map<String, Object> params) throws Throwable {
        JdbcConnectionManager jcm = new JdbcConnectionManager("INSERT", "", this.actionContext, null, false);
        this.connections.add(jcm);
        jcm.prepareConnection(name, params == null ? Collections.EMPTY_MAP : params);
        return jcm.setConnection();
    }

    public StambiaJavaCompiler createJavaCompiler(String library) throws EngineExceptionI {
        ClassLoader cl = null;
        try {
            if (library == null) {
                library = "internal";
            }
            cl = ClassLoaderServiceProvider.instance().getClassLoader(library);
        }
        catch (ClassLoaderServiceProvider.ClassLoaderServiceException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        if (cl == null) {
            throw new EngineExceptionI(Messages.getString("ScriptContextI.3") + library + Messages.getString("ScriptContextI.4"));
        }
        return this.createJavaCompiler(cl);
    }

    public IModuleAccess getModule(String name) throws Exception {
        ClassLoader cl = ClassLoaderServiceProvider.instance().getClassLoader(name);
        if (cl instanceof URLClassLoader) {
            ModuleImpl mai = new ModuleImpl();
            mai.cl = cl;
            mai.name = name;
            return mai;
        }
        throw new Exception(Messages.getString("ScriptContextI.5"));
    }

    public IResultSetPreviousRowComparator createResultSetPreviousRowComparator(ResultSet resultSet) throws EngineExceptionI {
        return new ResultSetPreviousRowComparator(resultSet);
    }

    public IResultSetsKeyPairComparator createResultSetsKeyPairComparator(ResultSet resultSetLeft, ResultSet resultSetRight) throws EngineExceptionI {
        return new ResultSetsKeyPairComparator(resultSetLeft, resultSetRight);
    }

    public INamedResultSetsProcessor createNamedResultSetsProcessor() throws EngineExceptionI {
        return new NamedResultSetsProcessor((IScriptContext)this);
    }

    public IXmlUtils getXmlUtils() {
        return xmlUtils;
    }

    private class ModuleImpl
    implements IModuleAccess {
        private String name;
        ClassLoader cl;

        private ModuleImpl() {
        }

        public Collection<URL> getContent() throws Exception {
            return Arrays.asList(((URLClassLoader)this.cl).getURLs());
        }

        public ClassLoader getClassLoader() throws Exception {
            return this.cl;
        }

        public boolean checkBaseModuleVersionRange(int minimumVersion, int maximumVersion) {
            boolean condition = true;
            try {
                Integer currentVersion;
                IModuleService.IModule module = StambiaClassLoaderRegistry.INSTANCE.getModuleService().getModule(this.getName());
                condition = module != null ? ((currentVersion = module.getDescriptor().getBaseModuleInfo().getVersion()) != null ? minimumVersion <= currentVersion && currentVersion <= maximumVersion : false) : false;
            }
            catch (Exception ex) {
                condition = false;
            }
            return condition;
        }

        private String getName() {
            return this.name;
        }
    }
}

