/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.naming.impl;

import com.indy.engine.core.naming.IInitialContextManager;
import com.indy.engine.naming.impl.Messages;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;

public class InitialContextManager
implements IInitialContextManager {
    static IInitialContextManager def = new InitialContextManager();

    public static IInitialContextManager getDefault() {
        return def;
    }

    public InitialLdapContext createInitialLdapContext(Hashtable props, Control[] ctrl) throws NamingException {
        return (InitialLdapContext)this.createInitialContext(props, ctrl, "ldap");
    }

    public InitialContext createInitialContext(Hashtable props) throws NamingException {
        return this.createInitialContext(props, null, null);
    }

    public InitialContext createInitialDirContext(Hashtable props) throws NamingException {
        return this.createInitialContext(props, null, "dir");
    }

    private InitialContext createInitialContext(Hashtable props, Control[] ctrl, String type) throws NamingException {
        if (props != null) {
            Hashtable props2 = new Hashtable();
            final int[] encoded = new int[1];
            for (Object key : props.keySet()) {
                Object value = props.get(key);
                if (key instanceof String && ((String)key).startsWith("STB_ENCODED_PROPERTY:")) {
                    String _key = (String)key;
                    _key = _key.substring("STB_ENCODED_PROPERTY:".length());
                    Object _value = value;
                    if (value instanceof String) {
                        try {
                            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                            semaphoreManager.getIsSemaphore(Messages.getString("InitialContextManager.0"));
                            _value = semaphoreManager.getStringAsciiInfo((String)_value);
                            encoded[0] = encoded[0] + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    props2.put(_key, _value);
                    continue;
                }
                props2.put((String)key, value);
            }
            if (type == null) {
                return new InitialContext(props2){

                    @Override
                    public Hashtable<?, ?> getEnvironment() throws NamingException {
                        if (encoded[0] > 0) {
                            throw new NamingException(Messages.getString("InitialContextManager.1") + encoded[0] + Messages.getString("InitialContextManager.2"));
                        }
                        return super.getEnvironment();
                    }
                };
            }
            if (type.toLowerCase().equals("ldap")) {
                return new InitialLdapContext(props2, ctrl){

                    @Override
                    public Hashtable<?, ?> getEnvironment() throws NamingException {
                        if (encoded[0] > 0) {
                            throw new NamingException(Messages.getString("InitialContextManager.3") + encoded[0] + Messages.getString("InitialContextManager.4"));
                        }
                        return super.getEnvironment();
                    }
                };
            }
            if (type.toLowerCase().equals("dir")) {
                return new InitialDirContext(props2){

                    @Override
                    public Hashtable<?, ?> getEnvironment() throws NamingException {
                        if (encoded[0] > 0) {
                            throw new NamingException(Messages.getString("InitialContextManager.5") + encoded[0] + Messages.getString("InitialContextManager.6"));
                        }
                        return super.getEnvironment();
                    }
                };
            }
            throw new NamingException(Messages.getString("InitialContextManager.7") + type);
        }
        if (type == null) {
            return new InitialContext();
        }
        if (type.toLowerCase().equals("ldap")) {
            return new InitialLdapContext();
        }
        if (type.toLowerCase().equals("dir")) {
            return new InitialDirContext();
        }
        throw new NamingException(Messages.getString("InitialContextManager.8") + type);
    }
}

