/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.main.action.variable.VariableContainer;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.statics.ActionStatic;
import com.indy.engine.main.action.statics.LinkStatic;
import com.indy.engine.main.action.statics.SessionStatic;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class SessionRecorder {
    private final Logger logger = LogManager.getLogger((String)Global.comIndyEngineMainLogger);
    int lastOffset = 0;

    private synchronized int newOffset() {
        return ++this.lastOffset;
    }

    public void fillSessionInfo(MainEngineI main, SessionRecord si) {
        si.sessionID = main.getSessionID();
        si.sessionIter = main.getSessionIter();
        si.sessionName = main.getSessionName();
    }

    public ActionStartRecord createActionStartRecord(IAction action, int num) {
        ActionStartRecord ar = new ActionStartRecord();
        this.fillRecord(ar, action, num, false);
        ar.offset = this.newOffset();
        ar.actionRuntimeName = action.getActionRuntimeName();
        ar.beginDate = action.getBeginDate();
        ar.fatherId = action.getFatherId();
        ar.hasFather = action.hasFather();
        ar.isBeginAction = action.getBeginAction();
        ar.runtimeShortName = action.getRuntimeShortName();
        ar.actionStatic = action.getActionStatic();
        if (action.hasFather()) {
            ar.parentIteration = action.getParentAction().getIteration();
        }
        this.fillSessionInfo(action.getMainEngine(), ar);
        return ar;
    }

    public SessionStartRecord createSessionStartRecord(MainEngineI mainEngine) {
        SessionStartRecord ssr = new SessionStartRecord();
        ssr.offset = this.newOffset();
        ssr.actionId = mainEngine.getMyAction().getActionId();
        ssr.configuration = mainEngine.getConfiguration();
        ssr.executionMode = mainEngine.getExecutionMode();
        ssr.guestHost = mainEngine.getGuestHost();
        ssr.launchMode = mainEngine.getLaunchMode();
        ssr.parentSessionId = mainEngine.getSessionDataExchange().getParentSessionId();
        ssr.parentSessionIter = mainEngine.getSessionDataExchange().getParentSessionIter();
        ssr.userName = mainEngine.getRemoteSessionInfo() != null ? mainEngine.getRemoteSessionInfo().getUser() : null;
        ssr.sessionName = mainEngine.getSessionName();
        ssr.beginDate = mainEngine.getBeginDate();
        ssr.sessionStatic = mainEngine.getSessionStatic();
        this.fillSessionInfo(mainEngine, ssr);
        return ssr;
    }

    public SessionEndRecord createSessionEndRecord(MainEngineI mainEngine) {
        SessionEndRecord ser = new SessionEndRecord();
        ser.offset = this.newOffset();
        ser.endDate = mainEngine.getEndDate();
        ser.sessionMsg = mainEngine.getSessionMsg();
        ser.sessionStatus = mainEngine.getSessionStatus();
        Map aggrs = mainEngine.getEngineContext().aggregateNumeric(null);
        if (aggrs != null && aggrs.size() > 0) {
            ser.aggregates = new ArrayList<AggregateRecord>();
            for (VariableContainer.AggregateNumeric _aggr : aggrs.values()) {
                AggregateRecord arec = new AggregateRecord();
                arec.count = _aggr.getCount();
                arec.max = _aggr.getMax();
                arec.min = _aggr.getMin();
                arec.name = _aggr.getName();
                arec.sum = _aggr.getSum();
                ser.aggregates.add(arec);
            }
        }
        this.fillSessionInfo(mainEngine, ser);
        ser.elapseTime = mainEngine.getEndDate().getTime() - mainEngine.getBeginDate().getTime();
        ser.sessionName = mainEngine.getSessionName();
        return ser;
    }

    private ActionInfo createActionInfo(IAction action) {
        ActionInfo ai = new ActionInfo();
        ai.actionId = action.getActionId();
        ai.actionName = action.getActionName();
        ai.actionIteration = action.getIteration();
        ai.isProcess = action.isProcess();
        StringBuilder tmp = new StringBuilder();
        this.computePathWithIteration(tmp, action);
        ai.pathWithIteration = tmp.toString();
        return ai;
    }

    private void computePathWithIteration(StringBuilder path, IAction action) {
        if (action.getParentAction() != null) {
            this.computePathWithIteration(path, action.getParentAction());
            path.append('/');
        }
        path.append(action.getRuntimeShortName());
        path.append('[');
        path.append(action.getIteration());
        path.append(']');
    }

    public ActionEndRecord createActionEndRecord(IAction action, int num) {
        ActionEndRecord ar = new ActionEndRecord();
        this.fillRecord(ar, action, num, true);
        ar.offset = this.newOffset();
        ar.isProcess = action.isProcess();
        ar.endDate = action.getEndDate();
        ar.duration = action.getEndDate().getTime() - action.getBeginDate().getTime();
        ar.actionErrorMsg = action.getActionErrorMsg();
        ar.nbExecution = action.getNbExecution();
        ar.currentBindIteration = action.getCurrentBindIteration();
        ar.actionStatic = action.getActionStatic();
        Map aggrs = action.getActionContext().getGetter().getAllAggregate();
        if (aggrs != null && aggrs.size() > 0) {
            ar.aggregates = new ArrayList<AggregateRecord>();
            for (VariableContainer.AggregateNumeric _aggr : aggrs.values()) {
                VariableContainer.AggregateNumeric aggr = _aggr.getCurrent();
                AggregateRecord arec = new AggregateRecord();
                arec.count = aggr.getCount();
                arec.max = aggr.getMax();
                arec.min = aggr.getMin();
                arec.name = aggr.getName();
                arec.sum = aggr.getSum();
                ar.aggregates.add(arec);
            }
        }
        this.fillSessionInfo(action.getMainEngine(), ar);
        return ar;
    }

    private void fillRecord(ActionRecord ar, IAction action, int num, boolean end) {
        ar.action = this.createActionInfo(action);
        ar.actionState = action.getActionState();
        ar.numAction = num;
    }

    public ActionLogRecord createActionLogRecord(IAction action, IAction actionPath, String path, String message, int num) {
        ActionLogRecord alr = new ActionLogRecord();
        alr.offset = this.newOffset();
        alr.path = path;
        alr.message = message;
        alr.num = num;
        alr.timeInMillis = System.currentTimeMillis();
        alr.action = this.createActionInfo(action);
        alr.actionPath = this.createActionInfo(actionPath);
        alr.message = message;
        this.fillSessionInfo(action.getMainEngine(), alr);
        return alr;
    }

    public ChildSessionRecord createChildSessionRecord(IAction act, int iteration, String sessId) {
        ChildSessionRecord csr = new ChildSessionRecord();
        csr.offset = this.newOffset();
        csr.iteration = iteration;
        csr.action = this.createActionInfo(act);
        csr.childSessionId = sessId;
        this.fillSessionInfo(act.getMainEngine(), csr);
        return csr;
    }

    public LinkRecord createLinkRecord(ActionGraphLinkI agl, Boolean withTxt, Date date) {
        LinkRecord lr = new LinkRecord();
        lr.offset = this.newOffset();
        lr.sCondition_sOriginScript = agl.sCondition.sOriginScript;
        lr.sCondition_sScript = agl.sCondition.sScript;
        lr.date = date;
        lr.withTxt = withTxt;
        lr.linkStatic = agl.getLinkStatic();
        lr.state = agl.getState();
        lr.iter = agl.getIter();
        this.fillSessionInfo(agl.getActionSource().getMainEngine(), lr);
        return lr;
    }

    public VariableRecord createVariableRecord(MainEngineI mainengine, IAction action, Variable var, int num) {
        VariableRecord vr = new VariableRecord();
        vr.offset = this.newOffset();
        vr.num = num;
        if (action != null) {
            vr.action = this.createActionInfo(action);
        } else {
            vr.isSession = true;
        }
        vr.cumulativeValue = var.getCumulativeValue();
        vr.isOriginalSourceModified = var.isOriginalSourceModified();
        vr.lastBindedValue = var.getLastBindedValue();
        vr.name = var.getName();
        vr.shortName = var.getShortName();
        vr.source = var.getSource();
        vr.type = var.getType();
        vr.value = var.getValue();
        vr.variablePublicationMode = var.getVariablePublicationMode();
        this.fillSessionInfo(mainengine, vr);
        return vr;
    }

    public DeliveryRecord createDeliveryRecord(MainEngineI mainEngine) {
        DeliveryRecord dr = new DeliveryRecord();
        dr.offset = this.newOffset();
        dr.configuration = mainEngine.getConfiguration();
        dr.delivery = mainEngine.getMemoryDelivery();
        dr.processName = mainEngine.getMainEngineName();
        return dr;
    }

    public SessionActivityRecord createSessionActivityRecord(MainEngineI mainengine) {
        SessionActivityRecord sar = new SessionActivityRecord();
        this.fillSessionInfo(mainengine, sar);
        sar.sessionStatus = mainengine.getSessionStatus();
        sar.sessionName = mainengine.getSessionName();
        return sar;
    }

    public class ActionEndRecord
    extends ActionRecord {
        List<AggregateRecord> aggregates;
        Date endDate;
        String actionErrorMsg;
        int nbExecution;
        long currentBindIteration;
        boolean isProcess;
        long duration;

        public ActionEndRecord() {
            this.aggregates = null;
        }

        public Collection<AggregateRecord> getAggregates() {
            return this.aggregates;
        }

        public boolean isAction() {
            return !this.isProcess;
        }

        @Override
        public boolean isProcess() {
            return this.isProcess;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public String getActionErrorMsg() {
            return this.actionErrorMsg;
        }

        public int getNbExecution() {
            return this.nbExecution;
        }

        public long getCurrentBindIteration() {
            return this.currentBindIteration;
        }

        public long getDuration() {
            return this.duration;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "aer_" + this.getAction().getActionId();
        }
    }

    public class ActionInfo {
        private String actionName;
        private String actionId;
        private int actionIteration;
        private String pathWithIteration;
        private boolean isProcess;

        public String getActionName() {
            return this.actionName;
        }

        public String getActionId() {
            return this.actionId;
        }

        public int getActionIteration() {
            return this.actionIteration;
        }

        public String getPathWithIteration() {
            return this.pathWithIteration;
        }

        public boolean isProcess() {
            return this.isProcess;
        }
    }

    public class ActionLogRecord
    extends SessionRecord {
        private int num;
        private ActionInfo action;
        private ActionInfo actionPath;
        private String path;
        private long timeInMillis;
        public String message;

        public String getMessage() {
            return this.message;
        }

        public int getNum() {
            return this.num;
        }

        public ActionInfo getAction() {
            return this.action;
        }

        public ActionInfo getActionPath() {
            return this.actionPath;
        }

        public long getTimeInMillis() {
            return this.timeInMillis;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "alr_" + this.getAction().getActionId() + "." + this.getActionPath().getActionId() + "." + this.getPath();
        }
    }

    public abstract class ActionRecord
    extends SessionRecord {
        ActionInfo action;
        int actionState;
        int numAction;
        String actionRuntimeName;
        ActionStatic actionStatic;

        public String getActionRuntimeName() {
            return this.actionRuntimeName;
        }

        public int getNumAction() {
            return this.numAction;
        }

        public ActionInfo getAction() {
            return this.action;
        }

        public int getActionState() {
            return this.actionState;
        }

        public boolean isProcess() {
            return false;
        }

        public ActionStatic getActionStatic() {
            return this.actionStatic;
        }
    }

    public class ActionStartRecord
    extends ActionRecord {
        boolean isBeginAction;
        String runtimeShortName;
        boolean hasFather;
        String fatherId;
        Date beginDate;
        int parentIteration;

        public Date getBeginDate() {
            return this.beginDate;
        }

        public String getFatherId() {
            return this.fatherId;
        }

        public boolean hasFather() {
            return this.hasFather;
        }

        public String getRuntimeShortName() {
            return this.runtimeShortName;
        }

        public boolean getBeginAction() {
            return this.isBeginAction;
        }

        public int getParentIteration() {
            return this.parentIteration;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "asr_" + this.getAction().getActionId();
        }
    }

    public class AggregateRecord {
        private String name;
        private long sum;
        private int count;
        private long min;
        private long max;

        public String getName() {
            return this.name;
        }

        public long getSum() {
            return this.sum;
        }

        public int getCount() {
            return this.count;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }
    }

    public class ChildSessionRecord
    extends SessionRecord {
        private ActionInfo action;
        private String childSessionId;
        private int iteration;

        public ActionInfo getAction() {
            return this.action;
        }

        public String getChildSessionId() {
            return this.childSessionId;
        }

        public int getIteration() {
            return this.iteration;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "csr_" + this.getAction().getActionId();
        }
    }

    public abstract class CommonRecord
    extends Record {
        int offset;

        public abstract String getUniqueName() throws EngineExceptionI;
    }

    public class DeliveryRecord
    extends CommonRecord {
        String processName;
        String configuration;
        IMemoryDelivery delivery;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteArrayOutputStream getBaos() throws EngineExceptionI {
            Document doc;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Document document = doc = this.delivery.getDocument();
            synchronized (document) {
                try {
                    TransformerFactory tf = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), null);
                    tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    Transformer trans = tf.newTransformer();
                    trans.setOutputProperty("cdata-section-elements", "step");
                    trans.transform(new DOMSource(doc), new StreamResult(out));
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            return out;
        }

        public String getProcessName() {
            return this.processName;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public SessionStatic getSessionStatic() throws EngineExceptionI {
            return this.delivery.getSessionStatic();
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "dr_" + this.getSessionStatic().getDlvId();
        }
    }

    public class LinkRecord
    extends SessionRecord {
        private Boolean withTxt;
        private Date date;
        private String sCondition_sOriginScript;
        private String sCondition_sScript;
        private int iter;
        private LinkStatic linkStatic;
        private int state;

        public String getsCondition_sScript() {
            return this.sCondition_sScript;
        }

        public String getsCondition_sOriginScript() {
            return this.sCondition_sOriginScript;
        }

        public LinkStatic getLinkStatic() {
            return this.linkStatic;
        }

        public int getIter() {
            return this.iter;
        }

        public Date getDate() {
            return this.date;
        }

        public int getState() {
            return this.state;
        }

        public boolean getWithTxt() {
            return this.withTxt;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "lr_" + this.getLinkStatic().getId();
        }
    }

    public class Record {
        String sessionID;
        int sessionIter;

        public String getSessionID() {
            return this.sessionID;
        }

        public int getSessionIter() {
            return this.sessionIter;
        }
    }

    public class SessionActivityRecord
    extends SessionRecord {
        public int sessionStatus;
        private String sessionName;

        public int getSessionStatus() {
            return this.sessionStatus;
        }

        @Override
        public String getSessionName() {
            return this.sessionName;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "sar_" + this.getSessionID();
        }
    }

    public class SessionEndRecord
    extends SessionRecord {
        private Date endDate;
        private int sessionStatus;
        private String sessionMsg;
        private String sessionName;
        List<AggregateRecord> aggregates;
        private long elapseTime;

        public SessionEndRecord() {
            this.aggregates = null;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public int getSessionStatus() {
            return this.sessionStatus;
        }

        public String getSessionMsg() {
            return this.sessionMsg;
        }

        public Collection<AggregateRecord> getAggregates() {
            return this.aggregates;
        }

        @Override
        public String getSessionName() {
            return this.sessionName;
        }

        public long getElapseTIme() {
            return this.elapseTime;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "ser";
        }
    }

    public abstract class SessionRecord
    extends CommonRecord {
        String sessionID;
        private String sessionName;
        int sessionIter;

        public String getSessionName() {
            return this.sessionName;
        }

        @Override
        public String getSessionID() {
            return this.sessionID;
        }

        @Override
        public int getSessionIter() {
            return this.sessionIter;
        }
    }

    public class SessionStartRecord
    extends SessionRecord {
        private String userName;
        private String actionId;
        private int parentSessionIter;
        private String parentSessionId;
        private String configuration;
        private String guestHost;
        private String executionMode;
        private String launchMode;
        private String sessionName;
        private Date beginDate;
        private SessionStatic sessionStatic;

        public String getLaunchMode() {
            return this.launchMode;
        }

        public String getExecutionMode() {
            return this.executionMode;
        }

        public String getGuestHost() {
            return this.guestHost;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public String getParentSessionId() {
            return this.parentSessionId;
        }

        public String getActionId() {
            return this.actionId;
        }

        public int getParentSessionIter() {
            return this.parentSessionIter;
        }

        public String getUserName() {
            return this.userName;
        }

        @Override
        public String getSessionName() {
            return this.sessionName;
        }

        public Date getBeginDate() {
            return this.beginDate;
        }

        public SessionStatic getSessionStatic() {
            return this.sessionStatic;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            return "ssr";
        }
    }

    public class VariableRecord
    extends SessionRecord {
        public boolean isSession;
        public int num;
        private String shortName;
        private ActionInfo action;
        private String type;
        private Object cumulativeValue;
        private boolean isOriginalSourceModified;
        private VariablePublicationMode variablePublicationMode;
        private String lastBindedValue;
        private String name;
        private String source;
        private String value;

        public String getValue() {
            return this.value;
        }

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.name;
        }

        public String getLastBindedValue() {
            return this.lastBindedValue;
        }

        public VariablePublicationMode getVariablePublicationMode() {
            return this.variablePublicationMode;
        }

        public boolean isOriginalSourceModified() {
            return this.isOriginalSourceModified;
        }

        public Object getCumulativeValue() {
            return this.cumulativeValue;
        }

        public String getType() {
            return this.type;
        }

        public boolean isSession() {
            return this.isSession;
        }

        public ActionInfo getAction() {
            return this.action;
        }

        public String getShortName() {
            return this.shortName;
        }

        public long getNum() {
            return this.num;
        }

        @Override
        public String getUniqueName() throws EngineExceptionI {
            if (this.isSession()) {
                return "vr_" + this.sessionID + "." + this.getName();
            }
            return "vr_" + this.getAction().getActionId() + "." + this.getName();
        }
    }
}

