/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.Global;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.indy.engine.rmi.SessionFilterCriteria;
import com.indy.engine.userLog.IUserLogI;
import com.indy.engine.userLog.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class UserLogI
implements IUserLogI {
    private static final Logger LOGGER = LogManager.getLogger(UserLogI.class);
    Map<String, String> properties;

    @Override
    public void cleanReportLog() {
        this.properties = null;
    }

    public static boolean verifFilters(ISessionDataExchange sde, Map<String, Object> criteria) {
        boolean sessionOK;
        block11: {
            sessionOK = false;
            boolean filterOK = true;
            boolean statusOK = false;
            try {
                if (criteria == null || criteria.size() == 0) {
                    sessionOK = true;
                    break block11;
                }
                String filter = (String)criteria.get("nameFilter");
                List lstStatus = (List)criteria.get("statusList");
                String client = (String)criteria.get("clientName");
                Date beginDate = (Date)criteria.get("beginDate");
                Date endDate = (Date)criteria.get("endDate");
                Boolean useComplexRegexpForFilter = (Boolean)criteria.get("useComplexRegexpForFilter");
                useComplexRegexpForFilter = useComplexRegexpForFilter == null ? false : useComplexRegexpForFilter;
                filterOK = true;
                if (beginDate != null && sde.getBeginDate().before(beginDate)) {
                    filterOK = false;
                }
                if (endDate != null && filterOK && sde.getEndDate().after(endDate)) {
                    filterOK = false;
                }
                if (lstStatus != null && filterOK) {
                    statusOK = false;
                    Iterator itStatus = lstStatus.iterator();
                    while (itStatus.hasNext() && !statusOK) {
                        Integer iStatus = (Integer)itStatus.next();
                        if (sde.getStatus() != iStatus.intValue()) continue;
                        statusOK = true;
                    }
                    itStatus = null;
                    filterOK = statusOK;
                }
                if (filter == null) break block11;
                String testExpression = filter.toUpperCase();
                if (testExpression != null && filterOK) {
                    if (!useComplexRegexpForFilter.booleanValue()) {
                        testExpression = StringOperations.replaceWildCharsWithGroups((String)testExpression);
                    }
                    try {
                        filterOK = StringOperations.matchPattern((String)testExpression, (String)sde.getName().toUpperCase());
                    }
                    catch (EngineExceptionI e) {
                        filterOK = false;
                    }
                }
                sessionOK = filterOK;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sessionOK;
    }

    private static boolean isDateInInterval(Date intervalDeb, Date intervalEnd, Date dateDeb, Date dateEnd) {
        Date date = dateEnd = dateEnd == null ? new Date() : dateEnd;
        if (intervalDeb == null && intervalEnd == null) {
            return true;
        }
        if (intervalEnd == null) {
            return intervalDeb.after(dateDeb) || dateEnd == null || intervalDeb.after(dateEnd);
        }
        if (intervalDeb == null) {
            return intervalEnd.before(dateDeb) || dateEnd == null || intervalEnd.before(dateEnd);
        }
        return !(!intervalDeb.after(dateDeb) && dateEnd != null && !intervalDeb.after(dateEnd) || !intervalEnd.before(dateDeb) && dateEnd != null && !intervalEnd.before(dateEnd));
    }

    public static boolean verifFilters(ISessionDataExchange sde, List<SessionFilterCriteria> lstfilters) {
        boolean sessionOK = false;
        boolean filterOK = true;
        boolean statusOK = false;
        try {
            if (lstfilters == null) {
                sessionOK = true;
            } else if (lstfilters.size() == 0) {
                sessionOK = true;
            }
            if (lstfilters != null) {
                Iterator<SessionFilterCriteria> it = lstfilters.iterator();
                while (it.hasNext() && !sessionOK) {
                    SessionFilterCriteria sfc;
                    block27: {
                        String testExpression;
                        block26: {
                            filterOK = true;
                            sfc = it.next();
                            if (sfc == null) continue;
                            if (sfc.isCurrentEngine()) {
                                String tmp = Global.HTTP_HOST + ":" + Global.HTTP_PORT.toString();
                                String tmp2 = sde.getEngineHost() + ":" + String.valueOf(sde.getEnginePort());
                                if (!tmp.toUpperCase().equals(tmp2.toUpperCase())) {
                                    filterOK = false;
                                    break;
                                }
                            }
                            if (sfc.getGuestHost() == null) {
                                filterOK = true;
                            } else if (sde.getGuestHost() == null || !sde.getGuestHost().equals(sfc.getGuestHost())) {
                                filterOK = false;
                                break;
                            }
                            if (!UserLogI.isMinDuration(sfc.getMinDuration(), sde.getBeginDate(), sde.getEndDate())) {
                                filterOK = false;
                                break;
                            }
                            if (!UserLogI.isMaxDuration(sfc.getMaxDuration(), sde.getBeginDate(), sde.getEndDate())) {
                                filterOK = false;
                                break;
                            }
                            if (!UserLogI.isDateInInterval(sfc.getSessBeginDate(), sfc.getSessEndDate(), sde.getBeginDate(), sde.getEndDate())) {
                                filterOK = false;
                                break;
                            }
                            List<Integer> lstStatus = sfc.getLstStatus();
                            if (lstStatus != null && filterOK) {
                                statusOK = false;
                                Iterator<Integer> itStatus = lstStatus.iterator();
                                while (itStatus.hasNext() && !statusOK) {
                                    Integer iStatus = itStatus.next();
                                    if (sde.getStatus() != iStatus.intValue()) continue;
                                    statusOK = true;
                                    break;
                                }
                                itStatus = null;
                                filterOK = statusOK;
                            }
                            if (sfc.getSessName() != null && (testExpression = sfc.getSessName().toUpperCase()) != null && filterOK) {
                                testExpression = StringOperations.replaceWildCharsWithGroups((String)testExpression);
                                try {
                                    filterOK = StringOperations.matchPattern((String)testExpression, (String)sde.getName().toUpperCase());
                                    if (!filterOK) {
                                    }
                                    break block26;
                                }
                                catch (EngineExceptionI e) {
                                    filterOK = false;
                                }
                                break;
                            }
                        }
                        if (sfc.getSessConfigName() != null && (testExpression = sfc.getSessConfigName().toUpperCase()) != null && filterOK) {
                            testExpression = StringOperations.replaceWildCharsWithGroups((String)testExpression);
                            try {
                                filterOK = StringOperations.matchPattern((String)testExpression, (String)sde.getConfiguration().toUpperCase());
                                if (!filterOK) {
                                }
                                break block27;
                            }
                            catch (EngineExceptionI e) {
                                filterOK = false;
                            }
                            break;
                        }
                    }
                    if (sfc.getLstSessionId() != null && sfc.getLstSessionId().size() > 0 && !sfc.getLstSessionId().contains(sde.getId())) {
                        filterOK = false;
                        break;
                    }
                    sessionOK = filterOK;
                }
                it = null;
            }
            sessionOK = filterOK;
        }
        catch (Exception e) {
            LOGGER.warn("unexpected", (Throwable)e);
        }
        return sessionOK;
    }

    private static boolean isMinDuration(Long minDuration, Date beginDate, Date endDate) {
        if (minDuration == null || minDuration <= 0L) {
            return true;
        }
        if (beginDate != null) {
            Date _endDate;
            Date date = _endDate = endDate == null ? new Date() : endDate;
            return minDuration <= _endDate.getTime() - beginDate.getTime();
        }
        return false;
    }

    private static boolean isMaxDuration(Long maxDuration, Date beginDate, Date endDate) {
        if (maxDuration == null || maxDuration <= 0L) {
            return true;
        }
        if (beginDate != null) {
            Date _endDate;
            Date date = _endDate = endDate == null ? new Date() : endDate;
            return maxDuration >= _endDate.getTime() - beginDate.getTime();
        }
        return false;
    }

    public String getProperty(String pName) throws EngineExceptionI {
        String ret = "";
        try {
            ret = this.properties.get(pName);
            if (ret == null) {
                throw new EngineExceptionI("UserLogI->getProperty, Missing parameter : " + pName);
            }
        }
        catch (NullPointerException e) {
            Global.dLog.write("", "UserLogI->getProperty", e.getMessage(), 0, 0, "WARNING");
            throw new EngineExceptionI(Messages.getString("UserLogI.2") + pName, (Throwable)e);
        }
        catch (MissingResourceException e) {
            Global.dLog.write("", "UserLogI->getProperty", e.getMessage(), 0, 0, "WARNING");
            throw new EngineExceptionI(Messages.getString("UserLogI.0") + pName, (Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public void setProperties(Map<String, String> p) {
        this.properties = p;
    }
}

