/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.Global;
import com.indy.engine.common.swagger2.IOpenAPI;
import com.indy.engine.common.swagger2.SwaggerDefinition;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.wsdl.DeliveryRestAPIHelper;
import com.indy.engine.wsdl.WsdlAPI;
import com.indy.runtime.wsdl.HttpRestDeliveryProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Swagger20
implements DeliveryRestAPIHelper.IOpenAPISpec {
    private Logger logger = LogManager.getLogger(Swagger20.class);
    SwaggerDefinition swaggerDef;
    String filePath;
    Map<String, WsdlAPI.DeliveryInfo> list = new HashMap<String, WsdlAPI.DeliveryInfo>();

    Swagger20(String catalogName, String filePath, String basePath) {
        this.swaggerDef = new SwaggerDefinition(basePath);
        this.filePath = filePath;
        SwaggerDefinition.Info info = this.swaggerDef.newInfo();
        info.description = "description";
        info.title = catalogName;
        info.version = "version";
        if (Global.webServiceSecureProtocolType != null) {
            this.swaggerDef.addSchemes("https");
        } else {
            this.swaggerDef.addSchemes("http");
        }
        if (Global.hasUser()) {
            this.swaggerDef.getSecurityDefinition().put("BasicAuth", new SwaggerDefinition.Security());
            this.swaggerDef.setSecurity(List.of(new SwaggerDefinition.SecurityRef()));
        }
    }

    @Override
    public void addDelivery(WsdlAPI.DeliveryInfo deliv, Map<String, String> jsonSchemas) {
        try {
            this.list.put(deliv.deliv.getName(), deliv);
            ArrayList<String> methods = new ArrayList<String>();
            HashSet tags = new HashSet();
            Object _path = "/" + deliv.name;
            boolean form = false;
            String rct = null;
            if (deliv.deliv.getHttpRestDeliveryProperties() != null) {
                rct = deliv.deliv.getHttpRestDeliveryProperties().getRequestContentType();
                if (rct != null && rct.equals("application/x-www-form-urlencoded")) {
                    form = true;
                }
                methods.addAll(deliv.deliv.getHttpRestDeliveryProperties().getMethods());
                if (deliv.deliv.getHttpRestDeliveryProperties().getPathTemplate() != null && !((String)(_path = deliv.deliv.getHttpRestDeliveryProperties().getPathTemplate())).startsWith("/")) {
                    _path = "/" + (String)_path;
                }
                tags.addAll(deliv.deliv.getHttpRestDeliveryProperties().getTags());
            }
            if (methods.isEmpty()) {
                if (deliv.deliv.getInputType() != Delivery.InOutType.nothing || form) {
                    methods.add("post");
                } else {
                    methods.add("get");
                }
            }
            SwaggerDefinition.Path path = this.swaggerDef.newPath((String)_path);
            for (String meth : methods) {
                SwaggerDefinition.Method method = path.newMethod(meth);
                if (methods.size() > 1) {
                    method.setOperationId(IOpenAPI.computeName((String)(deliv.name + "_" + meth)));
                } else {
                    method.setOperationId(IOpenAPI.computeName((String)deliv.name));
                }
                if (rct != null) {
                    method.addConsumes(rct);
                }
                if (rct == null) {
                    switch (deliv.deliv.getInputType()) {
                        case json: 
                        case other: 
                        case mix: {
                            method.addConsumes("application/json");
                            break;
                        }
                        case xsd: {
                            method.addConsumes("text/xml");
                            break;
                        }
                    }
                }
                switch (deliv.deliv.getOutputType()) {
                    case json: 
                    case other: 
                    case mix: {
                        method.addProduces("application/json");
                        break;
                    }
                    case xsd: {
                        method.addProduces("text/xml");
                        break;
                    }
                }
                method.addTags(tags);
                if (deliv.deliv.isExternalized()) {
                    SwaggerDefinition.Parameter param = method.newParameter("X-Delivery-Configuration-Name");
                    if (deliv.deliv.getConfigurationCode() != null) {
                        param.setEnumValues(Arrays.asList(deliv.deliv.getConfigurationCode().split(" ")));
                    }
                    param.setType("string");
                    param.setIn("header");
                    param.required = true;
                }
                for (Map.Entry<String, Delivery.Parameter> entry : deliv.deliv.getParameters().entrySet()) {
                    HttpRestDeliveryProperties.ParameterReplacement pr;
                    if (!entry.getValue().isInput()) continue;
                    String in = "query";
                    boolean required = false;
                    String name = entry.getKey();
                    HttpRestDeliveryProperties.ParameterReplacement parameterReplacement = pr = deliv.deliv.getHttpRestDeliveryProperties() != null ? deliv.deliv.getHttpRestDeliveryProperties().getParameterReplacement(name) : null;
                    if (pr != null) {
                        in = "path";
                        required = true;
                    } else {
                        HttpRestDeliveryProperties.RequestParameterHeader rrh;
                        HttpRestDeliveryProperties.RequestParameterHeader requestParameterHeader = rrh = deliv.deliv.getHttpRestDeliveryProperties() != null ? deliv.deliv.getHttpRestDeliveryProperties().getInputHeaderParameterName(name) : null;
                        if (rrh != null) {
                            name = rrh.getHeaderName();
                            in = "header";
                        } else if (form) {
                            in = "formData";
                        }
                    }
                    SwaggerDefinition.Parameter param = method.newParameter(name);
                    param.setType(entry.getValue().getType().toLowerCase());
                    param.setIn(in);
                    param.required = required;
                }
                boolean bResponse = false;
                for (Delivery.Route route : deliv.deliv.getRoutes()) {
                    SwaggerDefinition.Response response;
                    String name;
                    String jsonSchema = jsonSchemas.get(route.getCheckSum());
                    if (jsonSchema != null && route.isInput()) {
                        SwaggerDefinition.Parameter param = method.newParameter(route.getElementName());
                        param.setIn("body");
                        name = this.swaggerDef.newRawDefinition((String)route.getElementName(), (String)route.getCheckSum(), (String)jsonSchema, (boolean)false).name;
                        param.newSchemaRef(name);
                    }
                    if (jsonSchema != null && route.isOutput()) {
                        response = method.newResponse("200");
                        response.description = "200 response";
                        bResponse = true;
                        name = this.swaggerDef.newRawDefinition((String)route.getElementName(), (String)route.getCheckSum(), (String)jsonSchema, (boolean)false).name;
                        response.newSchemaRef(name);
                    }
                    if (jsonSchema == null || !route.isFault()) continue;
                    response = method.newResponse("default");
                    response.description = "default response";
                    bResponse = true;
                    name = this.swaggerDef.newRawDefinition((String)route.getElementName(), (String)route.getCheckSum(), (String)jsonSchema, (boolean)false).name;
                    response.newSchemaRef(name);
                }
                if (bResponse) continue;
                SwaggerDefinition.Response response = method.newResponse("default");
                response.description = "default response";
            }
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
        }
    }

    @Override
    public void serializeFile() throws IllegalArgumentException, FileNotFoundException, IllegalAccessException, XMLStreamException {
        this.swaggerDef.writeFile(this.filePath);
    }

    @Override
    public Object getDefinition() {
        return this.swaggerDef;
    }

    @Override
    public String getFileName() {
        return new File(this.filePath).getName();
    }
}

