/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.core.security.Role;
import com.indy.engine.wsdl.SoapService;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet1;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet2;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet3;
import com.semarchy.xdi.runtime.httpserver.RuntimeServlet;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@SpringBootApplication
public class Application {
    private static final String DETAILS_RESTRICTION_ROLES = Role.Admin.name() + "," + Role.Monitor.name();
    private static final String DEFAULT_ACTUATOR_MONITORING = "prometheus";
    private static final String DEFAULT_ACTUATOR_ENDPOINTS = "health,metrics,prometheus,quartz";
    public static final String PATTERN_MAPPING_API_CLIENT = "/client/*";
    public static final String PATTERN_MAPPING_DELIVERY_3 = "/rest/DeliveryService/3/*";
    public static final String PATTERN_MAPPING_DELIVERY_2 = "/rest/DeliveryService/2/*";
    public static final String PATTERN_MAPPING_DELIVERY_1 = "/rest/DeliveryService/1/*";
    private static final String BACKWARD_COMPATIBILITY_PREFIX = "Stambia";
    public static final String PATTERN_MAPPING_DELIVERY_3_BACK = "/rest/StambiaDeliveryService/3/*";
    public static final String PATTERN_MAPPING_DELIVERY_2_BACK = "/rest/StambiaDeliveryService/2/*";
    public static final String PATTERN_MAPPING_DELIVERY_1_BACK = "/rest/StambiaDeliveryService/1/*";
    public static final String API_PREFIX = "/api";
    public static final String API_VERSION_1 = "/1";
    public static final String API_PREFIX_VERSION_1 = "/api/1";
    public static final String PATTERN_MAPPING_DELIVERIES_API = "/deliveries";
    public static final String PATTERN_MAPPING_DELIVERY_REPOSITORIES_API = "/delivery-repositories";
    public static final String FULL_PATTERN_MAPPING_DELIVERIES_API = "/api/1/deliveries";
    public static final String FULL_PATTERN_MAPPING_DELIVERY_REPOSITORIES_API = "/api/1/delivery-repositories";
    private static final String P_GLOBAL_INTERNAL_ACTIVATE_HTTP_RUNTIME = "global.internalActivateHttpRuntime";
    private static final String P_GLOBAL_HTTP_SERVER_THREAD_POOL_SIZE = "global.soapServerThreadPoolSize";
    ConfigurableApplicationContext appContext;

    public void start() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("server.port", Global.HTTP_PORT);
            if (Global.getUserConfiguration().isAllowLocalhostOnly()) {
                props.put("server.address", "127.0.0.1");
            }
            props.put(P_GLOBAL_INTERNAL_ACTIVATE_HTTP_RUNTIME, Boolean.toString(Global.internalActivateHttpRuntime));
            props.put("server.error.include-exception", "true");
            props.put("server.error.include-message", "always");
            props.put("server.error.whitelabel.enabled", "false");
            props.put("server.servlet.encoding.charset", "UTF-8");
            props.put("server.servlet.encoding.force-response", "true");
            props.put("spring.main.banner-mode", "off");
            props.put("spring.lifecycle.timeout-per-shutdown-phase", System.getProperty("com.semarchy.xdi.graceful-shutdown-delay", "2s"));
            props.put("server.forward-headers-strategy", System.getProperty("com.semarchy.xdi.forward-headers-strategy", "native"));
            props.put("springdoc.swagger-ui.enabled", !Boolean.getBoolean("com.semarchy.xdi.disableSwaggerUi"));
            String actuatorEndpoints = System.getProperty("com.semarchy.xdi.metrics-endpoint", DEFAULT_ACTUATOR_ENDPOINTS);
            if (actuatorEndpoints.contains("info")) {
                props.put("management.info.java.enabled", "true");
                props.put("management.info.os.enabled", "true");
            }
            props.put("management.endpoints.access.default", "none");
            props.put("management.endpoints.web.exposure.include", actuatorEndpoints);
            StringUtils.commaDelimitedListToSet((String)actuatorEndpoints).forEach(e -> {
                String string = props.put("management.endpoint." + e + ".access", "unrestricted");
            });
            props.put("springdoc.show-actuator", "true");
            props.put("springdoc.api-docs.groups.enabled", "true");
            props.put("springdoc.swagger-ui.urls[0].url", "/rest/DeliveryService/3/default?openapi3.json");
            props.put("springdoc.swagger-ui.urls[0].name", "rest-openapi3");
            props.put("springdoc.swagger-ui.urlsPrimaryName", "rest-openapi3");
            props.put("springdoc.swagger-ui.urls[1].url", "/rest/DeliveryService/3/default?swagger2.json");
            props.put("springdoc.swagger-ui.urls[1].name", "rest-swagger2");
            props.put("management.defaults.metrics.export.enabled", "false");
            String actuatorMonitoring = System.getProperty("com.semarchy.xdi.monitoring", DEFAULT_ACTUATOR_MONITORING);
            StringUtils.commaDelimitedListToSet((String)actuatorMonitoring).forEach(e -> {
                String string = props.put("management." + e + ".metrics.export.enabled", "true");
            });
            props.put("management.endpoint.health.show-details", "when_authorized");
            props.put("management.endpoint.health.roles", DETAILS_RESTRICTION_ROLES);
            props.put("management.endpoint.quartz.show-values", "when_authorized");
            props.put("management.endpoint.quartz.roles", DETAILS_RESTRICTION_ROLES);
            if (Global.soapServerThreadPoolSize != null) {
                try {
                    Integer.parseInt(Global.soapServerThreadPoolSize);
                    props.put(P_GLOBAL_HTTP_SERVER_THREAD_POOL_SIZE, Global.soapServerThreadPoolSize);
                }
                catch (Exception ex) {
                    throw new Exception("Wrong value for the parameter soapServerThreadPoolSize. A number is expected.", ex);
                }
            }
            this.configureSSL(props);
            this.appContext = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{Application.class}).properties(props).run(new String[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void configureSSL(Map<String, Object> props) throws Exception {
        if (Global.webServiceSecureProtocolType != null) {
            props.put("server.ssl.enabled", true);
            props.put("server.ssl.protocol", "TLS");
            props.put("server.ssl.enabled-protocols", Global.webServiceSecureProtocolType);
            props.put("server.ssl.key-store-type", Global.webServiceHttpsKeyStoreType == null ? "JKS" : Global.webServiceHttpsKeyStoreType);
            if (Global.webServiceHttpsKeyStoreFile == null) {
                throw new Exception("Missing webServiceKeyStoreFile parameter in engineParameters.xml");
            }
            File keyStoreFile = new File(Global.webServiceHttpsKeyStoreFile);
            if (!keyStoreFile.exists() || !keyStoreFile.isFile()) {
                throw new Exception(String.format("The specified path %s for the parameter webServiceKeyStoreFile is not a file or does not exist.", Global.webServiceHttpsKeyStoreFile));
            }
            props.put("server.ssl.key-store", Global.webServiceHttpsKeyStoreFile);
            if (Global.webServiceHttpsKeyStorePassword != null) {
                props.put("server.ssl.key-store-password", Global.webServiceHttpsKeyStorePassword);
            }
            if (Global.webServiceHttpsKeyStoreAlias != null) {
                props.put("server.ssl.key-alias", Global.webServiceHttpsKeyStoreAlias);
            }
            if (Global.webServiceHttpsKeyPassword != null) {
                props.put("server.ssl.key-password", Global.webServiceHttpsKeyPassword);
            }
        }
    }

    public void stop() {
        SpringApplication.exit((ApplicationContext)this.appContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    @Bean
    public GroupedOpenApi actuatorApi() {
        String[] paths = new String[]{"/actuator/**"};
        return GroupedOpenApi.builder().group("monitor").addOpenApiCustomizer(openapi -> {
            openapi.getComponents().addSecuritySchemes("BasicAuth", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic"));
            openapi.addSecurityItem(new SecurityRequirement().addList("BasicAuth", Arrays.asList(Role.Admin.name(), Role.Monitor.name())));
        }).pathsToMatch(paths).build();
    }

    @Bean
    @ConditionalOnProperty(value={"global.internalActivateHttpRuntime"}, havingValue="true")
    ServletRegistrationBean<HttpServlet> registerRuntimeServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new RuntimeServlet());
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_API_CLIENT));
        return bean;
    }

    @Bean
    ServletRegistrationBean<HttpServlet> registerDeliveryClient3() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new DeliveryRestServlet3(SoapService.getWsdlApi()));
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_DELIVERY_3, PATTERN_MAPPING_DELIVERY_3_BACK));
        return bean;
    }

    @Bean
    ServletRegistrationBean<HttpServlet> registerDeliveryClient2() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new DeliveryRestServlet2(SoapService.getWsdlApi()));
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_DELIVERY_2, PATTERN_MAPPING_DELIVERY_2_BACK));
        return bean;
    }

    @Bean
    ServletRegistrationBean<HttpServlet> registerDeliveryClient1() {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setServlet((Servlet)new DeliveryRestServlet1(SoapService.getWsdlApi()));
        bean.setLoadOnStartup(0);
        bean.setUrlMappings(Arrays.asList(PATTERN_MAPPING_DELIVERY_1, PATTERN_MAPPING_DELIVERY_1_BACK));
        return bean;
    }

    @Bean
    HandlerExceptionResolver exceptionHandler() {
        return new DefaultHandlerExceptionResolver();
    }
}

