/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.wsdl.HttpSoapWrapper;
import com.indy.engine.wsdl.Invocation;
import com.indy.engine.wsdl.WsdlAPI;
import com.semarchy.xdi.runtime.httpserver.DeliveryRestServlet2;
import com.semarchy.xdi.runtime.httpserver.HttpErrorHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeliveryRestServlet1
extends HttpServlet {
    private static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final char[] ILLEGAL_CHARACTERS;
    private final transient WsdlAPI wsdlApi;
    private static final HttpErrorHandler errorHandler;

    static {
        char[] cArray = new char[15];
        cArray[0] = 47;
        cArray[1] = 10;
        cArray[2] = 13;
        cArray[3] = 9;
        cArray[5] = 12;
        cArray[6] = 96;
        cArray[7] = 63;
        cArray[8] = 42;
        cArray[9] = 92;
        cArray[10] = 60;
        cArray[11] = 62;
        cArray[12] = 124;
        cArray[13] = 34;
        cArray[14] = 58;
        ILLEGAL_CHARACTERS = cArray;
        errorHandler = new HttpErrorHandler();
    }

    public DeliveryRestServlet1(WsdlAPI wsdlApi) {
        this.wsdlApi = wsdlApi;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                if (!DeliveryRestServlet2.checkExecutionPermission(req.getUserPrincipal())) {
                    this.handleError(HttpStatus.FORBIDDEN.value(), "Execution grants required ", null, resp);
                    return;
                }
                String uri = req.getPathInfo();
                String deliveryName = uri.substring(uri.lastIndexOf("/") + 1);
                if (!DeliveryRestServlet1.isValidDeliveryName(deliveryName)) {
                    this.handleError(HttpStatus.BAD_REQUEST.value(), null, new IllegalArgumentException(), resp);
                    return;
                }
                XMLEventFactory xef = XMLEventFactory.newFactory();
                XMLEventWriter writer = XMLOutputFactory.newFactory().createXMLEventWriter(baos, "UTF-8");
                writer.add(xef.createStartDocument());
                writer.add(xef.createStartElement("soapenv12345", SOAP11_NAMESPACE, "Envelope"));
                writer.add(xef.createNamespace("soapenv12345", SOAP11_NAMESPACE));
                writer.add(xef.createNamespace("wrap12345", "http://stambia.com/document/literal/wrapped"));
                writer.add(xef.createStartElement("soapenv12345", SOAP11_NAMESPACE, "Header"));
                writer.add(xef.createEndElement("soapenv12345", SOAP11_NAMESPACE, "Header"));
                writer.add(xef.createStartElement("soapenv12345", SOAP11_NAMESPACE, "Body"));
                if (req.getMethod().equals(HttpMethod.GET.name())) {
                    Map<String, String> queryPair = HttpSoapWrapper.splitQuery(req.getQueryString());
                    writer.add(xef.createStartElement("wrap12345", "http://stambia.com/document/literal/wrapped", deliveryName + "Input"));
                    for (Map.Entry<String, String> entry : queryPair.entrySet()) {
                        String val = entry.getValue();
                        if (val == null) continue;
                        writer.add(xef.createStartElement(entry.getKey(), null, null));
                        writer.add(xef.createCharacters(entry.getValue()));
                        writer.add(xef.createEndElement(new QName(entry.getKey()), null));
                    }
                    writer.add(xef.createEndElement("wrap12345", "http://stambia.com/document/literal/wrapped", deliveryName + "Input"));
                } else if (req.getMethod().equals(HttpMethod.POST.name())) {
                    String requestContentType = req.getHeader("Content-Type");
                    if (requestContentType == null || !requestContentType.contains("text/xml") || !requestContentType.replace(" ", "").replace("-", "").toLowerCase().contains("charset=utf8")) {
                        resp.sendError(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value());
                        return;
                    }
                } else {
                    resp.sendError(HttpStatus.METHOD_NOT_ALLOWED.value());
                    return;
                }
                MessageFactory messageFactory = MessageFactory.newInstance();
                if (req.getMethod().equals(HttpMethod.POST.name())) {
                    XMLInputFactory factory = XMLInputFactory.newFactory();
                    factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                    factory.setProperty("javax.xml.stream.supportDTD", false);
                    XMLEventReader reader = factory.createXMLEventReader((InputStream)req.getInputStream());
                    while (reader.hasNext()) {
                        XMLEvent event = reader.nextEvent();
                        if (event.isStartDocument() || event.isEndDocument()) continue;
                        writer.add(event);
                    }
                }
                writer.add(xef.createEndElement("soapenv12345", SOAP11_NAMESPACE, "Body"));
                writer.add(xef.createEndElement("soapenv12345", SOAP11_NAMESPACE, "Envelope"));
                writer.add(xef.createEndDocument());
                writer.close();
                MimeHeaders mh = new MimeHeaders();
                Object object = null;
                Object var13_17 = null;
                try (ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());){
                    resp.setHeader("Content-Type", "text/xml;charset=UTF-8");
                    SOAPMessage message = messageFactory.createMessage(mh, (InputStream)is);
                    message.getMimeHeaders().addHeader("Soapaction", deliveryName);
                    Invocation invok = new Invocation(message, this.wsdlApi, req.getUserPrincipal() == null ? null : req.getUserPrincipal().getName(), req.getRemoteHost());
                    invok.setWriteErrorToRoot(true);
                    SOAPMessage response = invok.invoke();
                    NodeList nl = response.getSOAPBody().getChildNodes();
                    if (nl.getLength() == 1) {
                        Node node = nl.item(0);
                        resp.setStatus(HttpStatus.OK.value());
                        this.writeNode(node, (OutputStream)resp.getOutputStream());
                    } else if (nl.getLength() > 1) {
                        Node node = nl.item(0);
                        resp.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                        this.writeNode(node, (OutputStream)resp.getOutputStream());
                    }
                }
                catch (Throwable throwable2) {
                    if (object == null) {
                        object = throwable2;
                    } else if (object != throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                    throw object;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.handleError(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Soap Delivery invocation failed", e, resp);
        }
    }

    static boolean isValidDeliveryName(String deliveryName) {
        char[] chars = deliveryName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            int j = 0;
            while (j < ILLEGAL_CHARACTERS.length) {
                if (chars[i] == ILLEGAL_CHARACTERS[j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    void writeNode(Node node, OutputStream os) throws TransformerException, TransformerFactoryConfigurationError, IOException {
        DOMSource xmlSource = new DOMSource(node);
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            StreamResult outputTarget = new StreamResult(osw);
            TransformerFactory factory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), null);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            factory.newTransformer().transform(xmlSource, outputTarget);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void handleError(int httpErrorCode, String message, Exception t, HttpServletResponse resp) {
        Consumer<String> errorConsumer = errorMessage -> {
            try {
                resp.sendError(httpErrorCode, errorMessage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        errorHandler.handleError(message, t, errorConsumer);
    }
}

