/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.xdg;

import com.indy.engine.EngineServerI;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.manager.Action;
import com.semarchy.xdi.runtime.xdg.HarvestedConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XdgHarvestingPublisher {
    private Logger logger = LogManager.getLogger(XdgHarvestingPublisher.class);
    private File outputFolder = null;
    private TransformerFactory transformationFactory;
    private DocumentBuilderFactory docBuilderFactory;
    private String xdgHarvesterURI;
    private String initiativeURN;
    private String authorizationToken;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);
    private HttpClient client;

    public XdgHarvestingPublisher(HarvestedConfiguration configuration) throws DisabledException {
        String folderPath = configuration.getProperty("outputFolder");
        if (folderPath != null && !folderPath.isEmpty()) {
            this.outputFolder = new File(folderPath);
            this.outputFolder.mkdirs();
        }
        if (configuration.getProperty("apiEndpoint") != null) {
            this.initEndpoint(configuration);
        }
        if (this.outputFolder == null && this.xdgHarvesterURI == null) {
            throw new DisabledException();
        }
        try {
            this.transformationFactory = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), null);
            this.transformationFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            this.transformationFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            String externalEntitiesFeature = "http://xml.org/sax/features/external-general-entities";
            this.docBuilderFactory.setFeature(externalEntitiesFeature, false);
            externalEntitiesFeature = "http://xml.org/sax/features/external-parameter-entities";
            this.docBuilderFactory.setFeature(externalEntitiesFeature, false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected error", e);
        }
    }

    private void initEndpoint(HarvestedConfiguration configuration) {
        StringBuilder url = new StringBuilder();
        url.append(configuration.getProperty("apiEndpoint"));
        String harvestingPath = configuration.getProperty("harvestingPath");
        if (harvestingPath == null || harvestingPath.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid configuration for metadataHarvester's property %s is missing", "harvestingPath"));
        }
        if (!url.toString().endsWith("/")) {
            url.append("/");
        }
        url.append(harvestingPath);
        try {
            this.xdgHarvesterURI = url.toString();
            URI.create(this.xdgHarvesterURI);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid configuration for metadataHarvester's properties %s, %s -> %s", "apiEndpoint", "harvestingPath", url.toString()), e);
        }
        this.authorizationToken = configuration.getProperty("authorizationToken");
        if (this.authorizationToken == null || this.authorizationToken.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid configuration for metadataHarvester's property %s is missing", "authorizationToken"));
        }
        this.initiativeURN = configuration.getProperty("defaultInitiativeUrn");
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public void harvestFromDelivery(String deliveryName, Supplier<InputStream> deliveryStreamProvider) {
        try {
            DocumentBuilder docBuilder = this.docBuilderFactory.newDocumentBuilder();
            Document deliveryDocument = docBuilder.parse(deliveryStreamProvider.get());
            Result result = this.extractXdgModelFromDelivery(deliveryDocument);
            if (result != null) {
                this.publishXdgModel(result, deliveryName);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("No metadata to harvest into delivery {}", (Object)deliveryName);
            }
        }
        catch (DisabledException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped xdg extraction from deliv {} metainf ", (Object)deliveryName);
            }
        }
        catch (Exception ex) {
            this.logger.error("Failed to generate xdg harvester model", (Throwable)ex);
        }
    }

    private SAXSource createXSL() throws IOException {
        ByteArrayOutputStream evalOs = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(XdgHarvestingPublisher.class.getResourceAsStream("xdg.extract.xsl"));){
            byte[] buf = new byte[2048];
            int sz = -1;
            while ((sz = ((InputStream)is).read(buf)) != -1) {
                evalOs.write(buf, 0, sz);
            }
            evalOs.flush();
            evalOs.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new SAXSource(new InputSource(new BufferedInputStream(new ByteArrayInputStream(evalOs.toByteArray()))));
    }

    private Result extractXdgModelFromDelivery(Document deliveryDoc) throws IOException, TransformerException, ParserConfigurationException, SAXException, DisabledException {
        DOMSource domSource = new DOMSource(deliveryDoc);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(bos);
        Transformer transformer = this.transformationFactory.newTransformer(this.createXSL());
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(domSource, outputTarget);
        if (bos.size() > 0) {
            String processId = deliveryDoc.getFirstChild().getAttributes().getNamedItem("processId").getNodeValue();
            String configurationCode = deliveryDoc.getFirstChild().getAttributes().getNamedItem("configurationCode").getNodeValue();
            DocumentBuilder docBuilder = this.docBuilderFactory.newDocumentBuilder();
            return new Result(docBuilder.parse(new ByteArrayInputStream(bos.toByteArray())), this.getInitiativeUrn(deliveryDoc), processId, configurationCode);
        }
        return null;
    }

    private String getInitiativeUrn(Document deliveryDoc) throws DisabledException {
        String metaInf = deliveryDoc.getDocumentElement().getAttribute("metaInf");
        if (metaInf == null || !metaInf.contains("xdgHarvestConfiguration")) {
            return this.initiativeURN;
        }
        try {
            NodeList nodes = Action.parseMetaInf(metaInf);
            int i = 0;
            while (i < nodes.getLength()) {
                Node n = nodes.item(i);
                NamedNodeMap attributes = n.getAttributes();
                if (n.getNodeName().equals("metaInf") && "xdgHarvestConfiguration".equals(attributes.getNamedItem("id").getNodeValue())) {
                    if (Boolean.parseBoolean(attributes.getNamedItem("disabled").getNodeValue())) {
                        throw new DisabledException();
                    }
                    String initiativeUrn = attributes.getNamedItem("initiativeUrn").getNodeValue();
                    if (initiativeUrn != null) {
                        return initiativeUrn;
                    }
                }
                ++i;
            }
        }
        catch (DisabledException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse deliery metaInf", (Throwable)e);
        }
        return this.initiativeURN;
    }

    private String getStatusLabel(int status) {
        return switch (status) {
            case 2 -> "RUNNING";
            case 1 -> "EXECUTED";
            case -2 -> "KILLED";
            case 0 -> "NEVER_EXECUTED";
            case 6 -> "PAUSED";
            case -1 -> "WITH_ERRORS";
            case 9 -> "PREPARING";
            case 10 -> "PREPARED";
            case -4 -> "DEAD";
            default -> "OTHER";
        };
    }

    private void handleSession(MainEngineI sessionInstance) throws IOException, TransformerException, ParserConfigurationException, SAXException, DisabledException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Result res = this.extractXdgModelFromDelivery(sessionInstance.getMemoryDelivery().getDocument());
        if (res == null) {
            return;
        }
        Element session = res.xdgModel.createElement("session");
        session.setAttribute("sessionId", sessionInstance.getSessionID());
        session.setAttribute("status", this.getStatusLabel(sessionInstance.getSessionStatus()));
        session.setAttribute("beginDate", sdf.format(sessionInstance.getBeginDate()));
        session.setAttribute("endDate", sdf.format(sessionInstance.getEndDate()));
        session.setAttribute("launchMode", sessionInstance.getLaunchMode());
        session.setAttribute("user", sessionInstance.getLaunchUser());
        Variable v = sessionInstance.getLstRootSessionVariables().get(VariableType.CORE_DURATION.getName());
        session.appendChild(this.createStatistic("duration", v.getValue(), res.xdgModel));
        session.appendChild(this.createStatistic("errorNumber", Long.toString(sessionInstance.getLstSessionErrors().size()), res.xdgModel));
        session.appendChild(this.createStatistic("warningNumber", Long.toString(sessionInstance.getLstSessionWarnings().size()), res.xdgModel));
        res.xdgModel.getFirstChild().appendChild(session);
        this.publishXdgModel(res, sessionInstance.getSessionID());
    }

    private Element createStatistic(String name, String value, Document doc) {
        Element stat = doc.createElement("statistic");
        stat.setAttribute("name", name);
        stat.setAttribute("value", value);
        return stat;
    }

    private void publishXdgModel(Result result, String fileName) throws IOException, TransformerException {
        Transformer transformer = this.transformationFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        AtomicReference<OutputStream> output = new AtomicReference<OutputStream>();
        AtomicReference<File> xdgFile = new AtomicReference<File>();
        if (this.outputFolder != null) {
            if (!fileName.endsWith(".xdg")) {
                fileName = String.format("%s.xdg", fileName);
            }
            xdgFile.set(new File(this.outputFolder, fileName));
            output.set(new FileOutputStream((File)xdgFile.get()));
        } else {
            output.set(new ByteArrayOutputStream());
        }
        this.insertAttributesInXdgModel(result);
        DOMSource domSource = new DOMSource(result.xdgModel);
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedOutputStream out = new BufferedOutputStream((OutputStream)output.get());){
            StreamResult outputTarget = new StreamResult(out);
            transformer.transform(domSource, outputTarget);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Supplier<InputStream> isProvider = () -> {
            try {
                return xdgFile.get() == null ? new ByteArrayInputStream(((ByteArrayOutputStream)output.get()).toByteArray()) : Files.newInputStream(((File)xdgFile.get()).toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        };
        if (this.xdgHarvesterURI != null) {
            this.executorService.submit(() -> this.sendToXDG(isProvider, this.computeURI(result)));
        }
    }

    private void insertAttributesInXdgModel(Result result) throws IOException {
        NodeList childs = result.xdgModel.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node n = childs.item(i);
            if (n.getNodeName().equals("xdg:model") && n instanceof Element) {
                Element element = (Element)n;
                element.setAttribute("xdiProcessSourceId", result.xdiSourcePorcessId);
                element.setAttribute("xdiConfigurationCode", result.configurationCode);
                try {
                    element.setAttribute("xdiSourceId", result.createSourceId());
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Failed to generate xdg export sourceId", e);
                }
            }
            ++i;
        }
    }

    private URI computeURI(Result result) {
        StringBuilder uri = new StringBuilder(this.xdgHarvesterURI);
        boolean hasParam = false;
        if (result.deploymentInitiativeUrn != null && !result.deploymentInitiativeUrn.isEmpty()) {
            uri.append("?");
            uri.append("initiativeUrn=" + URLEncoder.encode(result.deploymentInitiativeUrn, StandardCharsets.UTF_8));
            hasParam = true;
        } else if (this.initiativeURN != null && !this.initiativeURN.isEmpty()) {
            uri.append("?");
            uri.append("initiativeUrn=" + URLEncoder.encode(this.initiativeURN, StandardCharsets.UTF_8));
            hasParam = true;
        }
        if (!hasParam) {
            uri.append("?");
        } else {
            uri.append("&");
        }
        try {
            uri.append("xdiSourceId=" + URLEncoder.encode(result.createSourceId(), StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Failed to generate xdg harvester URI", (Throwable)e);
        }
        return URI.create(uri.toString());
    }

    protected void sendToXDG(Supplier<InputStream> is, URI uri) {
        HttpRequest request = HttpRequest.newBuilder(uri).header("Authorization", "Bearer " + this.authorizationToken).header("accept", "text/plain").header("Content-Type", "application/xml").header("X-Client-Version", EngineServerI.getEngineBrandingVersion()).header("X-Client-Name", "xDI Runtime").POST(HttpRequest.BodyPublishers.ofInputStream(is)).build();
        try {
            HttpResponse<String> resp = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            HttpStatus responseStatus = HttpStatus.valueOf((int)resp.statusCode());
            if (!responseStatus.is2xxSuccessful()) {
                org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[2];
                supplierArray[0] = () -> responseStatus.name();
                supplierArray[1] = resp::body;
                this.logger.error("Failed to send xDG extraction: Http Status code :{}\n Http Body :{}", supplierArray);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("xDG extraction interrupted", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Failed to send xDG extraction", (Throwable)e);
        }
    }

    public MainEngineI.EngineHandler createSessionHandler() {
        return new MainEngineI.EngineHandler(){

            @Override
            public void beforeStarting(MainEngineI mainEngine) {
            }

            @Override
            public void beforeStoping(MainEngineI mainEngine) {
                try {
                    XdgHarvestingPublisher.this.handleSession(mainEngine);
                }
                catch (DisabledException e) {
                    if (XdgHarvestingPublisher.this.logger.isDebugEnabled()) {
                        XdgHarvestingPublisher.this.logger.debug("Skipped xdg extraction from deliv {} metainf ", (Object)mainEngine.getDeliveryName());
                    }
                }
                catch (Exception e) {
                    XdgHarvestingPublisher.this.logger.error("Failed to generate xdg harvester model from session {}", (Object)mainEngine.getSessionID(), (Object)e);
                }
            }
        };
    }

    public class DisabledException
    extends Exception {
        private static final long serialVersionUID = -8802430375248801128L;
    }

    public record Result(Document xdgModel, String deploymentInitiativeUrn, String xdiSourcePorcessId, String configurationCode) {
        String createSourceId() throws NoSuchAlgorithmException {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            String toChecksum = this.xdiSourcePorcessId + ":" + this.configurationCode;
            byte[] bytes = digest.digest(toChecksum.getBytes());
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < bytes.length) {
                sb.append(Integer.toHexString(bytes[i] & 0xFF | 0x100).substring(1, 3));
                ++i;
            }
            return sb.toString();
        }
    }
}

