/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import java.util.Map;

public class OAuth2Authentication
extends AuthenticationInfo {
    private OAuth2Metadata md = new OAuth2Metadata(){

        @Override
        public OAuth2Metadata.Logger getLogger() {
            return null;
        }
    };

    public OAuth2Authentication(String accessToken, String refreshToken, String tokenEndpoint, String clientId, String clientSecret, Integer expiresIn, Integer numberOfAttempts, Integer connectionTimeout, String flowType, String authenticationEndpoint, String login, String password, String redirectionEndpoint, String scope, OAuth2.CredentialMode credentialMode, String tokenEndpointHttpMethod, Map<String, String> additionalParameters, Boolean enableHostnameVerification, Boolean enableCertificateVerification) {
        this(accessToken, refreshToken, tokenEndpoint, clientId, clientSecret, expiresIn, numberOfAttempts, connectionTimeout, flowType, authenticationEndpoint, login, password, redirectionEndpoint, scope, credentialMode, tokenEndpointHttpMethod, additionalParameters, enableHostnameVerification, enableCertificateVerification, null, null, null, null, null);
    }

    public OAuth2Authentication(String accessToken, String refreshToken, String tokenEndpoint, String clientId, String clientSecret, Integer expiresIn, Integer numberOfAttempts, Integer connectionTimeout, String flowType, String authenticationEndpoint, String login, String password, String redirectionEndpoint, String scope, OAuth2.CredentialMode credentialMode, String tokenEndpointHttpMethod, Map<String, String> additionalParameters, Boolean enableHostnameVerification, Boolean enableCertificateVerification, Map<String, String> additionalHttpHeaders) {
        this(accessToken, refreshToken, tokenEndpoint, clientId, clientSecret, expiresIn, numberOfAttempts, connectionTimeout, flowType, authenticationEndpoint, login, password, redirectionEndpoint, scope, credentialMode, tokenEndpointHttpMethod, additionalParameters, enableHostnameVerification, enableCertificateVerification, additionalHttpHeaders, null, null, null, null);
    }

    public OAuth2Authentication(String accessToken, String refreshToken, String tokenEndpoint, String clientId, String clientSecret, Integer expiresIn, Integer numberOfAttempts, Integer connectionTimeout, String flowType, String authenticationEndpoint, String login, String password, String redirectionEndpoint, String scope, OAuth2.CredentialMode credentialMode, String tokenEndpointHttpMethod, Map<String, String> additionalParameters, Boolean enableHostnameVerification, Boolean enableCertificateVerification, Map<String, String> additionalHttpHeaders, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this.md.accessToken = accessToken;
        this.md.additionnalParameters = additionalParameters;
        this.md.additionnalHttpHeaders = additionalHttpHeaders;
        this.md.authEndpoint = authenticationEndpoint;
        this.md.clientId = clientId;
        this.md.clientSecret = clientSecret;
        if (connectionTimeout != null) {
            this.md.connectionTimeout = connectionTimeout;
        }
        if (expiresIn != null) {
            this.md.expiresIn = expiresIn.intValue();
        }
        this.md.flowType = flowType;
        this.md.login = login;
        if (numberOfAttempts != null) {
            this.md.numberOfAttempts = numberOfAttempts;
        }
        this.md.password = password;
        this.md.redirectEndpoint = redirectionEndpoint;
        this.md.refreshToken = refreshToken;
        this.md.scope = scope;
        this.md.securityToken = null;
        this.md.clientCredentialPolicy = credentialMode;
        this.md.tokenEndpoint = tokenEndpoint;
        this.md.tokenEndpointHttpMethod = tokenEndpointHttpMethod;
        this.md.enableCertificateVerification = enableCertificateVerification;
        this.md.enableHostnameVerification = enableHostnameVerification;
        this.md.proxyHost = proxyHost;
        if (proxyPort != null) {
            this.md.proxyPort = proxyPort;
        }
        this.md.proxyUser = proxyUser;
        this.md.proxyPassword = proxyPassword;
    }

    @Override
    public String getAuthenticationHeaderValue(String serverAuthenticationHeader) throws Exception {
        try {
            String authorizationHeaderValue = "Bearer " + this.getOAuth2Token();
            return authorizationHeaderValue;
        }
        catch (Exception ex) {
            throw new Exception("Failed to generate OAuth 2 Authorization Header. Check error logs for more information.", ex);
        }
    }

    public String getOAuth2Token() throws Exception {
        try {
            return OAuth2.getToken(this.md);
        }
        catch (Exception ex) {
            throw new Exception("Failed to generate OAuth 2 Token. Check error logs for more information.", ex);
        }
    }
}

