/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ftp.commands;

import com.stambia.ftp.commands.FtpCommand;
import com.stambia.ftp.commands.FtpCommand_STOR;
import com.stambia.ftp.commands.Messages;
import com.stambia.ftp.exceptions.BadSyntaxException;
import com.stambia.ftp.exceptions.FtpCommandException;
import com.stambia.ftp.exceptions.WrongPathException;
import com.stambia.ftp.utils.FtpCommandHandler;
import com.stambia.ftp.utils.FtpCommandResponses;
import com.stambia.ftp.utils.FtpStatisticListener;
import com.stambia.ftp.utils.FtpUtils;
import com.stambia.ftp.utils.SystemFilesFilter;
import com.stambia.ftp.utils.SystemFilesOnlyFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public class FtpCommand_STOR_MULTIPLEFILES
extends FtpCommand<FTPClient> {
    public FtpCommand_STOR_MULTIPLEFILES(String command, String[] parameters) {
        super(command, parameters);
    }

    public FtpCommand_STOR_MULTIPLEFILES(FtpCommand<FTPClient> ftpCmd) {
        super(ftpCmd);
    }

    @Override
    public void executeCommand(FTPClient ftpCli, String localPath, boolean verbose, FtpCommandHandler commandHandler, List<FtpStatisticListener> statisticsListeners) throws IOException, FtpCommandException {
        StringBuilder response = new StringBuilder();
        String parameter0 = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[0]);
        String parameter1 = FtpUtils.removeFirstAndLastQuotes(this.getParameters()[1]);
        if (parameter0 != null) {
            if (parameter0.contains("*") || parameter0.contains("?") || parameter0.endsWith("/") || parameter0.endsWith("\\") || parameter0.equals("./")) {
                String serverSeparator = parameter0.contains("/") ? "/" : "\\";
                int serverSeparatorLastIndex = parameter0.lastIndexOf(serverSeparator);
                String filePath = localPath;
                if (serverSeparatorLastIndex > 0) {
                    filePath = FtpUtils.retrievePath(parameter0, localPath);
                }
                Object filePathToSend = parameter1 == null ? "./" : (parameter1.endsWith("/") ? parameter1 : parameter1 + "/");
                File sourceFolder = new File(FtpUtils.buildPath(filePath, localPath));
                if (sourceFolder.isDirectory()) {
                    if (parameter0.endsWith("/") || parameter0.endsWith("\\")) {
                        this.appendResponse(ftpCli, verbose, commandHandler, response, (String)filePathToSend, sourceFolder, statisticsListeners, new SystemFilesOnlyFilter(), parameter0);
                    } else if (parameter0.contains("*") || parameter0.contains("?")) {
                        String filePattern = parameter0.substring(serverSeparatorLastIndex + 1);
                        this.appendResponse(ftpCli, verbose, commandHandler, response, (String)filePathToSend, sourceFolder, statisticsListeners, new SystemFilesFilter(filePattern), parameter0);
                    } else {
                        BadSyntaxException e = new BadSyntaxException(parameter0);
                        commandHandler.handleError(parameter0, e);
                    }
                } else {
                    WrongPathException e = new WrongPathException(sourceFolder.getAbsolutePath());
                    commandHandler.handleError("", e);
                }
            } else {
                FtpCommand_STOR ftpCmd = new FtpCommand_STOR(this);
                ((FtpCommand)ftpCmd).executeCommand(ftpCli, localPath, verbose, commandHandler, statisticsListeners);
            }
        } else {
            BadSyntaxException exception = new BadSyntaxException(FtpCommandResponses.MISSING_PARAMETER);
            commandHandler.handleError("", exception);
        }
    }

    private void appendResponse(FTPClient ftpCli, boolean verbose, FtpCommandHandler commandHandler, StringBuilder response, String filePathToSend, File sourceFolder, List<FtpStatisticListener> statisticsListeners, FileFilter fileFilter, String remotePath) throws IOException, FtpCommandException {
        File[] fileList = sourceFolder.listFiles(fileFilter);
        if (fileList == null || fileList.length == 0) {
            throw new IOException(Messages.getString("FtpCommand_STOR_MULTIPLEFILES.0") + remotePath);
        }
        this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.STORED_FILES_NUMBER, fileList.length);
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.fireStatiscitEvent(statisticsListeners, FtpStatisticListener.Statistic.STORED_FILES_SIZE, file.length());
            FileInputStream ism = new FileInputStream(file);
            ftpCli.storeFile(filePathToSend + file.getName(), (InputStream)ism);
            ((InputStream)ism).close();
            this.defaultResponseManager(ftpCli, verbose, commandHandler);
            ++n2;
        }
    }
}

