/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ui;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public final class DefaultResourcesFilter
extends GenericFilterBean {
    private final RequestMatcher matcher;
    private final ClassPathResource resource;
    private final MediaType mediaType;

    private DefaultResourcesFilter(RequestMatcher matcher, ClassPathResource resource, MediaType mediaType) {
        Assert.isTrue((boolean)resource.exists(), (String)"classpath resource must exist");
        this.matcher = matcher;
        this.resource = resource;
        this.mediaType = mediaType;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest)) {
            filterChain.doFilter(request, response);
            return;
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        if (this.matcher.matches(servletRequest)) {
            response.setContentType(this.mediaType.toString());
            response.getWriter().write(this.resource.getContentAsString(StandardCharsets.UTF_8));
            return;
        }
        filterChain.doFilter(request, response);
    }

    public String toString() {
        return "%s [matcher=%s, resource=%s]".formatted(((Object)((Object)this)).getClass().getSimpleName(), this.matcher.toString(), this.resource.getPath());
    }

    public static DefaultResourcesFilter css() {
        return new DefaultResourcesFilter(PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/default-ui.css"), new ClassPathResource("org/springframework/security/default-ui.css"), new MediaType("text", "css", StandardCharsets.UTF_8));
    }

    public static DefaultResourcesFilter webauthn() {
        return new DefaultResourcesFilter(PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/login/webauthn.js"), new ClassPathResource("org/springframework/security/spring-security-webauthn.js"), new MediaType("text", "javascript", StandardCharsets.UTF_8));
    }
}

