/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.net.proxy;

import com.stambia.net.proxy.Messages;
import com.stambia.net.proxy.StambiaProxySelector;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StambiaProxySelectorWrapper
extends ProxySelector {
    private static StambiaProxySelectorWrapper spsw = new StambiaProxySelectorWrapper(ProxySelector.getDefault());
    ProxySelector defsel = null;
    Map<Object, IStambiaProxySelector> map;

    public static StambiaProxySelectorWrapper getDefault() {
        return spsw;
    }

    StambiaProxySelectorWrapper(ProxySelector def) {
        this.defsel = def;
        this.map = Collections.synchronizedMap(new HashMap());
        ProxySelector.setDefault(this);
    }

    @Override
    public List<Proxy> select(URI arg0) {
        ArrayList<IStambiaProxySelector> _list = new ArrayList<IStambiaProxySelector>(this.map.values());
        ArrayList<Proxy> proxies = null;
        for (IStambiaProxySelector selector : _list) {
            Proxy proxy = selector.getProxy(arg0);
            if (proxy == null) continue;
            proxies = new ArrayList<Proxy>();
            proxies.add(proxy);
        }
        if (proxies != null) {
            return proxies;
        }
        return this.defsel.select(arg0);
    }

    @Override
    public void connectFailed(URI arg0, SocketAddress arg1, IOException arg2) {
        this.defsel.connectFailed(arg0, arg1, arg2);
    }

    public void addProxySelector(StambiaProxySelector selector, boolean replace) {
        IStambiaProxySelector proxySel = this.map.get(selector.getId());
        if (replace || proxySel == null || !proxySel.getSelector().equals(selector)) {
            this.map.put(selector.getId(), new Selector(selector, selector.createProxy()));
        }
    }

    public void removeProxySelector(String id) {
        this.map.remove(id);
    }

    public void clearAll() {
        this.map.clear();
    }

    private static interface IStambiaProxySelector {
        public Proxy getProxy(URI var1);

        public StambiaProxySelector getSelector();
    }

    private class Selector
    implements IStambiaProxySelector {
        StambiaProxySelector selector;
        Proxy proxy;
        private int distance = 3;

        public Selector(StambiaProxySelector selector, Proxy proxy) {
            this.selector = selector;
            this.proxy = proxy;
        }

        @Override
        public Proxy getProxy(URI uri) {
            if (uri == null) {
                throw new IllegalArgumentException(Messages.getString("StambiaProxySelectorWrapper.0"));
            }
            if (this.selector == null) {
                return null;
            }
            if (!this.selector.select(uri)) {
                return null;
            }
            StackTraceElement trace = null;
            if (this.selector.getPackageName() != null || this.selector.getParentClassName() != null) {
                StackTraceElement[] astacktraceelement = Thread.currentThread().getStackTrace();
                int j = astacktraceelement.length;
                boolean ok = false;
                if (j > this.distance) {
                    int i = this.distance;
                    while (i < j) {
                        trace = astacktraceelement[i];
                        if (this.selector.getPackageName() != null && trace.getClassName().startsWith(this.selector.getPackageName() + ".")) {
                            ok = true;
                            break;
                        }
                        if (this.selector.getParentClassName() != null && trace.getClassName().equals(this.selector.getParentClassName())) {
                            ok = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!ok) {
                    return null;
                }
            }
            return this.proxy;
        }

        @Override
        public StambiaProxySelector getSelector() {
            return this.selector;
        }
    }
}

