/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.tools;

import com.indy.engine.common.tools.Messages;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessWrapper {
    Thread threadIn;
    Thread threadError;
    private Process process;
    private Charset charset = Charset.defaultCharset();
    private final Logger logger = LogManager.getLogger(this.getClass());
    private int inputLimitSize;
    private int errorLimitSize;
    @Deprecated
    private StringBuffer inputStringBuffer;
    @Deprecated
    private StringBuffer errorStringBuffer;
    private StringBuilder inputStringBuilder;
    private StringBuilder errorStringBuilder;
    private OutputStream outputStream;
    private OutputStream errorOutputStream;
    private String inputReaderThreadName;
    private String errorReaderThreadName;
    private long timeout = -1L;
    private Thread timeoutThread;
    boolean isAlive = false;
    boolean isTimeout = false;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setInputReaderThreadName(String name) {
        this.inputReaderThreadName = name;
    }

    public void setErrorReaderThreadName(String name) {
        this.errorReaderThreadName = name;
    }

    protected ProcessWrapper(Process proc) {
        this.process = proc;
    }

    public static ProcessWrapper wrap(Process proc) {
        return new ProcessWrapper(proc);
    }

    @Deprecated
    public void setInputStringBuffer(StringBuffer input, int limit) {
        this.inputLimitSize = limit;
        this.inputStringBuffer = input;
    }

    public void setInputStringBuilder(StringBuilder input, int limit) {
        this.inputLimitSize = limit;
        this.inputStringBuilder = input;
    }

    @Deprecated
    public void setErrorStringBuffer(StringBuffer error, int limit) {
        this.errorStringBuffer = error;
        this.errorLimitSize = limit;
    }

    public void setErrorStringBuilder(StringBuilder error, int limit) {
        this.errorStringBuilder = error;
        this.errorLimitSize = limit;
    }

    public void setInputOutputStream(OutputStream output, int limit) {
        this.inputLimitSize = limit;
        this.outputStream = output;
    }

    public void setErrorOutputStream(OutputStream output, int limit) {
        this.errorLimitSize = limit;
        this.errorOutputStream = output;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public int waitFor() throws InterruptedException {
        this.startTimeoutThread();
        this.startReaderThreads();
        return this.waitForAndEndThreads();
    }

    public void startTimeoutThread() {
        this.isAlive = true;
        if (this.timeout > -1L) {
            this.timeoutThread = new Thread(() -> {
                try {
                    Thread.sleep(this.timeout);
                    if (this.isAlive) {
                        this.process.destroy();
                        this.isTimeout = true;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.warn(e.getMessage(), (Throwable)e);
                }
            });
            this.timeoutThread.setName("ProcessWrapper Timeout Thread");
            this.timeoutThread.start();
        }
    }

    public void startReaderThreads() {
        this.threadError = null;
        this.threadIn = null;
        if (this.inputStringBuffer != null || this.inputStringBuilder != null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        if (this.errorStringBuffer != null || this.errorStringBuilder != null) {
            this.errorOutputStream = new ByteArrayOutputStream();
        }
        this.threadIn = new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), this.charset));){
                    int data = reader.read();
                    long l = 0L;
                    while (data != -1) {
                        if ((this.inputLimitSize == -1 || ++l <= (long)this.inputLimitSize) && this.outputStream != null) {
                            OutputStream outputStream = this.outputStream;
                            synchronized (outputStream) {
                                this.outputStream.write(data);
                            }
                        }
                        data = reader.read();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        });
        if (this.inputReaderThreadName != null) {
            this.threadIn.setName(this.inputReaderThreadName);
        }
        this.threadIn.start();
        this.threadError = new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), this.charset));){
                    int data = reader.read();
                    long l = 0L;
                    while (data != -1) {
                        if ((this.errorLimitSize == -1 || ++l <= (long)this.errorLimitSize) && this.errorOutputStream != null) {
                            OutputStream outputStream = this.errorOutputStream;
                            synchronized (outputStream) {
                                this.errorOutputStream.write(data);
                            }
                        }
                        data = reader.read();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        });
        if (this.errorReaderThreadName != null) {
            this.threadError.setName(this.errorReaderThreadName);
        }
        this.threadError.start();
    }

    public int waitForAndEndThreads() throws InterruptedException {
        try {
            int ret = this.process.waitFor();
            this.threadError.join();
            this.threadIn.join();
            if (this.isTimeout) {
                throw new InterruptedException(Messages.getString("ProcessWrapper.0") + this.timeout + Messages.getString("ProcessWrapper.1"));
            }
            if (this.inputStringBuffer != null) {
                this.inputStringBuffer.append(this.outputStream.toString());
            }
            if (this.inputStringBuilder != null) {
                this.inputStringBuilder.append(this.outputStream.toString());
            }
            if (this.errorStringBuffer != null) {
                this.errorStringBuffer.append(this.errorOutputStream.toString());
            }
            if (this.errorStringBuilder != null) {
                this.errorStringBuilder.append(this.errorOutputStream.toString());
            }
            int n = ret;
            return n;
        }
        finally {
            try {
                if (this.threadError != null && this.threadError.isAlive()) {
                    this.threadError.interrupt();
                }
                if (this.threadIn != null && this.threadIn.isAlive()) {
                    this.threadIn.interrupt();
                }
                this.isAlive = false;
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.errorOutputStream != null) {
                    this.errorOutputStream.close();
                }
                if (this.timeoutThread != null) {
                    this.timeoutThread.interrupt();
                    this.timeoutThread = null;
                }
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.process.destroy();
    }

    public boolean isProcessAlive() {
        return this.process != null && this.process.isAlive();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public OutputStream getErrorOutputStream() {
        return this.errorOutputStream;
    }
}

