/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class RemoteSessionInfo {
    private String clientHost;
    private Date startDate;
    private Date lastAccess;
    private String remoteSessionId;
    private String user;

    public RemoteSessionInfo(String remoteSessionId, String clientHost, String user) {
        this.remoteSessionId = remoteSessionId;
        this.clientHost = clientHost;
        this.user = user != null && !user.isEmpty() ? user : null;
        this.startDate = new Date();
        this.lastAccess = null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getRemoteSessionId() {
        return this.remoteSessionId;
    }

    public String getUser() {
        return this.user;
    }

    public void updateLastAccess() {
        this.lastAccess = new Date();
    }

    public String toString() {
        return "RemoteSessionInfo [startDate=" + String.valueOf(this.startDate) + ", remoteSessionId=" + this.remoteSessionId + ", user=" + (this.user != null ? this.user : "anonymous") + "]";
    }

    public static RemoteSessionInfo parse(Map map) throws ParseException {
        SimpleDateFormat df;
        String dt;
        RemoteSessionInfo rsi = new RemoteSessionInfo((String)map.get("remoteSessionId"), (String)map.get("clientHost"), (String)map.get("user"));
        if (map.get("startDate") != null) {
            if (map.get("startDate") instanceof String) {
                dt = (String)map.get("startDate");
                df = new SimpleDateFormat();
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                rsi.startDate = df.parse(dt);
            } else if (map.get("startDate") instanceof Date) {
                rsi.startDate = (Date)map.get("startDate");
            }
        }
        if (map.get("lastAccess") != null) {
            if (map.get("lastAccess") instanceof String) {
                dt = (String)map.get("lastAccess");
                df = new SimpleDateFormat();
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                rsi.lastAccess = df.parse(dt);
            } else if (map.get("lastAccess") instanceof Date) {
                rsi.lastAccess = (Date)map.get("lastAccess");
            }
        }
        return rsi;
    }

    public Map toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", this.user);
        map.put("remoteSessionId", this.remoteSessionId);
        SimpleDateFormat df = new SimpleDateFormat();
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        map.put("startDate", df.format(this.startDate));
        if (this.lastAccess != null) {
            map.put("lastAccess", df.format(this.lastAccess));
        }
        map.put("clientHost", this.clientHost);
        return map;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public String getClientHost() {
        return this.clientHost;
    }
}

