/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.hierarchy;

import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.Messages;
import com.indy.runtime.hierarchy.event.EndDocumentEvent;
import com.indy.runtime.hierarchy.event.EndElementEvent;
import com.indy.runtime.hierarchy.event.StartDocumentEvent;
import com.indy.runtime.hierarchy.event.StartElementEvent;

public class HierarchyEventFactory {
    public static HierarchyEventFactory newFactory() {
        return new HierarchyEventFactory();
    }

    public StartElementEvent createStartElement(String name, int dt) {
        StartElementEvent sce = new StartElementEvent();
        sce.eventType = HierarchyEvent.EventType.startElement;
        sce.name = name;
        sce.setType(dt);
        return sce;
    }

    public EndElementEvent createEndElement(String name) {
        EndElementEvent ece = new EndElementEvent();
        ece.eventType = HierarchyEvent.EventType.endElement;
        ece.name = name;
        return ece;
    }

    public StartElementEvent createData(String name, int type, Object data) {
        StartElementEvent de = new StartElementEvent();
        de.eventType = HierarchyEvent.EventType.startDataElement;
        de.name = name;
        de.setType(type);
        if (de.getType() == Integer.MIN_VALUE) {
            throw new RuntimeException(Messages.getString("HierarchyEventFactory.0"));
        }
        de.setData(data);
        return de;
    }

    public StartElementEvent createNullData(String name) {
        StartElementEvent de = new StartElementEvent();
        de.eventType = HierarchyEvent.EventType.startDataElement;
        de.name = name;
        de.setIsNull(true);
        return de;
    }

    public StartDocumentEvent createStartDocument() {
        StartDocumentEvent sde = new StartDocumentEvent();
        sde.eventType = HierarchyEvent.EventType.startDocument;
        return sde;
    }

    public EndDocumentEvent createEndDocument() {
        EndDocumentEvent ede = new EndDocumentEvent();
        ede.eventType = HierarchyEvent.EventType.endDocument;
        return ede;
    }
}

