/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.compiler.impl;

import com.indy.engine.common.compiler.impl.StambiaJavaCompilerImpl;
import com.indy.engine.common.compiler.impl.StambiaJavaCompilerTools;
import com.indy.engine.core.common.compiler.StambiaJavaCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;

public class StambiaJavaCompilerClassLoaderImpl
extends StambiaJavaCompiler.CompilerClassLoader {
    Map<String, List<JavaFileObject>> map = new HashMap<String, List<JavaFileObject>>();
    Map<String, JavaFileObject> classeFiles = new HashMap<String, JavaFileObject>();
    Map<String, Class<?>> _classes = new HashMap();

    public StambiaJavaCompilerClassLoaderImpl(ClassLoader parentClassLoader) {
        super(new ClassLoader(parentClassLoader){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return super.findClass(name);
            }
        });
    }

    public void addClassFile(String qualifiedName, JavaFileObject file) {
        List<JavaFileObject> list;
        String[] ret = StambiaJavaCompilerTools.extractPackageAndClassName(qualifiedName);
        String packageName = ret[0];
        if (packageName == null) {
            packageName = "";
        }
        if ((list = this.map.get(packageName)) == null) {
            list = new ArrayList<JavaFileObject>();
            this.map.put(packageName, list);
        }
        list.add(file);
        this.classeFiles.put(qualifiedName, file);
    }

    public Iterable<JavaFileObject> getClassFiles(String packageName) {
        return this.map.get(packageName);
    }

    public Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
        Class clazz = this._classes.get(qualifiedClassName);
        if (clazz != null) {
            return clazz;
        }
        JavaFileObject file = this.classeFiles.get(qualifiedClassName);
        if (file != null) {
            byte[] bytes = ((StambiaJavaCompilerImpl.JavaCompiledFile)file).getBytes();
            clazz = this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
            this._classes.put(qualifiedClassName, clazz);
            return clazz;
        }
        clazz = super.findClass(qualifiedClassName);
        this._classes.put(qualifiedClassName, clazz);
        return clazz;
    }
}

