/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.delivery;

import com.indy.engine.common.xml.XmlUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeliveryBuilderUtil {
    public static String computeChecksum(InputStream in) throws Exception {
        TextualDelivery td = DeliveryBuilderUtil.getTextualDelivery(new BufferedInputStream(in));
        String str = td.text;
        MessageDigest m = MessageDigest.getInstance("SHA1");
        byte[] thedigest = m.digest(str.getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printHexBinary((byte[])thedigest);
    }

    public static TextualDelivery getTextualDelivery(InputStream is) throws Exception {
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("delivery/@id");
        filter.add("delivery/@buildDate");
        filter.add("delivery/@buildUser");
        filter.add("delivery/@checksum");
        filter.add("delivery/@checksumVersion");
        filter.add("delivery/@exportDate");
        filter.add("delivery/@exportUser");
        filter.add("delivery/@packageId");
        filter.add("delivery/@regex");
        filter.add("delivery/@version");
        filter.add("delivery/@processId");
        filter.add("delivery/@description");
        filter.add("delivery/@externalized");
        filter.add("delivery/@configurationCode");
        filter.add("delivery/@allowedScriptErrors");
        filter.add("delivery/@allowedVariableErrors");
        final TextualDelivery td = new TextualDelivery();
        td.text = XmlUtils.getTextualXml(is, filter, new XmlUtils.AttributeListener(){

            @Override
            public void attribute(String nodePath, String value) {
                if (nodePath.equals("delivery/@id")) {
                    td.id = value;
                } else if (nodePath.equals("delivery/@buildUser")) {
                    td.buildUser = value;
                } else if (nodePath.equals("delivery/@checksum")) {
                    td.checksum = value;
                } else if (nodePath.equals("delivery/@checksumVersion")) {
                    td.checksumVersion = value;
                } else if (nodePath.equals("delivery/@exportDate")) {
                    td.exportDate = value;
                } else if (nodePath.equals("delivery/@exportUser")) {
                    td.exportUser = value;
                } else if (nodePath.equals("delivery/@packageId")) {
                    td.packageId = value;
                } else if (nodePath.equals("delivery/@processId")) {
                    td.processId = value;
                }
            }
        });
        return td;
    }

    static class Node
    implements Comparable<Node> {
        String name;
        List<Node> list = new ArrayList<Node>();
        List<String> attributes = new ArrayList<String>();
        String text;
        public Node parent;
        private String path;

        Node() {
        }

        void setName(String name) {
            this.name = name;
            Node current = this;
            StringBuilder sb = new StringBuilder();
            while (current != null && current.name != null) {
                if (sb.length() == 0) {
                    sb.insert(0, current.name);
                } else {
                    sb.insert(0, current.name + "/");
                }
                current = current.parent;
            }
            this.path = sb.toString();
        }

        String getRowId() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.path);
            if (this.attributes.size() > 0) {
                Collections.sort(this.attributes);
                for (String str : this.attributes) {
                    sb.append(" ");
                    sb.append(str);
                }
            }
            return sb.toString();
        }

        @Override
        public int compareTo(Node paramT) {
            return this.getRowId().compareTo(paramT.getRowId());
        }
    }

    public static class TextualDelivery {
        String text;
        String buildDate;
        String buildUser;
        String checksum;
        String checksumVersion;
        String exportDate;
        String exportUser;
        String id;
        String packageId;
        protected String processId;

        public String getText() {
            return this.text;
        }

        public String getBuildDate() {
            return this.buildDate;
        }

        public String getBuildUser() {
            return this.buildUser;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public String getChecksumVersion() {
            return this.checksumVersion;
        }

        public String getExportDate() {
            return this.exportDate;
        }

        public String getExportUser() {
            return this.exportUser;
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getId() {
            return this.id;
        }

        public String getPackageId() {
            return this.packageId;
        }
    }
}

