/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.swagger2;

import com.indy.engine.common.swagger2.IOpenAPI;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenAPIDefinition303
implements IOpenAPI {
    @IOpenAPI.ToSerialize(name="openapi")
    String version = "3.0.3";
    @IOpenAPI.ToSerialize(name="info")
    Info info;
    @IOpenAPI.ToSerialize(name="servers")
    List<Server> servers = new ArrayList<Server>();
    @IOpenAPI.ToSerialize(name="security")
    List<SecurityRef> security = null;
    @IOpenAPI.ToSerialize(name="components")
    Component components = new Component();
    @IOpenAPI.ToSerialize(name="paths")
    Map<String, Path> paths = new TreeMap<String, Path>();

    public OpenAPIDefinition303(String baseURL, boolean httpAuthentication) {
        Server server = new Server();
        server.url = baseURL;
        this.servers.add(server);
        this.info = new Info();
        this.info.version = "1.0";
        this.info.title = "Deliveries Rest API";
        if (httpAuthentication) {
            this.components.security.put("httpBasic", new Security());
            this.security = new ArrayList<SecurityRef>();
            this.security.add(new SecurityRef());
        }
    }

    public Path newPath(String path) {
        Path _path = this.paths.get(path);
        if (_path == null) {
            _path = new Path();
            this.paths.put(path, _path);
        }
        return _path;
    }

    public void writeFile(String sTAMBIA_SWAGGER_20_PATH) throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, XMLStreamException {
        Object o = IOpenAPI.serialize(this);
        JsonNode.serialize((Object)o, (OutputStream)new FileOutputStream(sTAMBIA_SWAGGER_20_PATH), (String)"UTF-8");
    }

    public Info getInfo() {
        return this.info;
    }

    public Definition newRawDefinition(String name, String checksum, String raw) throws Exception {
        Object o = JsonUtils.jsonNodeToObject((String)raw);
        Definition def = this.newDefinition(name, checksum, o);
        def.raw = raw;
        return def;
    }

    private Definition newDefinition(String prefix, String checksum, Object object) throws Exception {
        Definition def = null;
        String _prefix = IOpenAPI.computeName(prefix);
        Object computeName = _prefix;
        int index = 1;
        do {
            Definition _def;
            if ((_def = this.components.schemas.get(computeName)) != null && _def.checkSum != null && _def.checkSum.equals(checksum)) {
                def = _def;
                continue;
            }
            if (_def != null) {
                computeName = _prefix + "_" + ++index;
                continue;
            }
            def = new Definition();
            def.object = object;
            def.checkSum = checksum;
            def.name = computeName;
            this.components.schemas.put((String)computeName, def);
        } while (def == null);
        return def;
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Component {
        @IOpenAPI.ToSerialize(name="securitySchemes")
        Map<String, Security> security = new TreeMap<String, Security>();
        @IOpenAPI.ToSerialize(name="schemas")
        Map<String, Definition> schemas = new TreeMap<String, Definition>();
    }

    public static class Definition
    implements IOpenAPI.Serialize {
        public String name;
        String raw;
        String checkSum;
        Object object;

        @Override
        public Object serialize() {
            return this.object;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Header {
        @IOpenAPI.ToSerialize(name="schema")
        Object schema;

        public void setType(String type) throws Exception {
            this.schema = JsonUtils.jsonNodeToObject((String)("{\"type\":\"" + type + "\"}"));
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Info {
        @IOpenAPI.ToSerialize(name="description")
        public String description;
        @IOpenAPI.ToSerialize(name="version")
        public String version;
        @IOpenAPI.ToSerialize(name="title")
        public String title;
        @IOpenAPI.ToSerialize(name="termsOfService")
        public String termsOfService;

        public String getTitle() {
            return this.title;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Method {
        @IOpenAPI.ToSerialize(name="operationId")
        String operationId;
        @IOpenAPI.ToSerialize(name="parameters")
        List<Parameter> parameters = new ArrayList<Parameter>();
        @IOpenAPI.ToSerialize(name="tags")
        Set<String> tags = new TreeSet<String>();
        @IOpenAPI.ToSerialize(name="requestBody")
        Request request;
        @IOpenAPI.ToSerialize(name="responses")
        Map<String, Response> responses = new TreeMap<String, Response>();

        public Response newResponse(String code) {
            Response response = new Response();
            this.responses.put(code, response);
            return response;
        }

        public Parameter newParameter(String string) {
            Parameter parameter = new Parameter(string);
            this.parameters.add(parameter);
            return parameter;
        }

        public void setOperationId(String name) {
            this.operationId = name;
        }

        public Request getRequest() {
            if (this.request == null) {
                this.request = new Request();
            }
            return this.request;
        }

        public void addTags(Set<String> tags) {
            this.tags.addAll(tags);
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Parameter {
        @IOpenAPI.ToSerialize(name="name")
        String name;
        @IOpenAPI.ToSerialize(name="in")
        String in;
        String enumValues;
        @IOpenAPI.ToSerialize(name="schema")
        Object schema;
        @IOpenAPI.ToSerialize(name="required")
        public boolean required;

        public Parameter(String string) {
            this.name = string;
        }

        public void setIn(String in) {
            this.in = in;
        }

        public void setType(String type) throws Exception {
            this.schema = JsonUtils.jsonNodeToObject((String)("{\"type\":\"" + type + "\"" + (String)(this.enumValues == null ? "" : ", \"enum\":[" + this.enumValues + "]") + "}"));
        }

        public void setEnumValues(List<String> values) throws Exception {
            StringBuilder b = new StringBuilder();
            if (values != null && !values.isEmpty()) {
                for (String s : values) {
                    if (b.length() != 0) {
                        b.append(",");
                    }
                    b.append("\"" + s + "\"");
                }
                this.enumValues = b.toString();
            }
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Path
    implements IOpenAPI.Serialize {
        @IOpenAPI.ToSerialize(name="")
        Map<String, Method> methods = new TreeMap<String, Method>();

        public Method newMethod(String method) {
            Method _method = new Method();
            this.methods.put(method, _method);
            return _method;
        }

        @Override
        public Object serialize() {
            return this.methods;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Request {
        @IOpenAPI.ToSerialize(name="content")
        HashMap<String, Schema> map = new HashMap();
        @IOpenAPI.ToSerialize(name="required")
        boolean required;

        public void addMediaType(String mediaType, String schemaRefName) {
            Schema sc = new Schema();
            sc.schemaRef = new SchemaRef(schemaRefName);
            this.map.put(mediaType, sc);
        }

        public void addMediaType(String mediaType) {
            UndefinedSchema sc = new UndefinedSchema();
            this.map.put(mediaType, sc);
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Response {
        @IOpenAPI.ToSerialize(name="description")
        public String description;
        @IOpenAPI.ToSerialize(name="headers")
        HashMap<String, Header> headers;
        @IOpenAPI.ToSerialize(name="content")
        HashMap<String, Schema> map = new HashMap();

        public void newSchemaRef(String mediaType, String schemaRefName) {
            Schema sc = new Schema();
            sc.schemaRef = new SchemaRef(schemaRefName);
            this.map.put(mediaType, sc);
        }

        public void newSchema(String mediaType) {
            UndefinedSchema sc = new UndefinedSchema();
            this.map.put(mediaType, sc);
        }

        public void addHeader(String headerName, String type) throws Exception {
            if (this.headers == null) {
                this.headers = new HashMap();
            }
            Header h = new Header();
            if (type == null) {
                type = "string";
            }
            h.schema = JsonUtils.jsonNodeToObject((String)("{\"type\":\"" + type + "\"}"));
            this.headers.put(headerName, h);
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Schema {
        @IOpenAPI.ToSerialize(name="schema")
        SchemaRef schemaRef;
    }

    static class SchemaRef
    implements IOpenAPI.Serialize {
        String ref;

        public SchemaRef(String string) {
            this.ref = string;
        }

        @Override
        public Object serialize() {
            TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
            map.put("$ref", (CallSite)((Object)("#/components/schemas/" + this.ref)));
            return map;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Security {
        @IOpenAPI.ToSerialize(name="type")
        public String type = "http";
        @IOpenAPI.ToSerialize(name="scheme")
        public String scheme = "basic";
    }

    @IOpenAPI.ToSerialize(name="")
    static class SecurityRef {
        @IOpenAPI.ToSerialize(name="httpBasic", keepEmptyArray=true)
        List l = new ArrayList();
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Server {
        @IOpenAPI.ToSerialize(name="url")
        String url;
    }

    public static class UndefinedSchema
    extends Schema
    implements IOpenAPI.Serialize {
        private final Logger logger = LogManager.getLogger(this.getClass());

        @Override
        public Object serialize() {
            try {
                return JsonUtils.jsonNodeToObject((String)"{\"schema\":{\"type\":\"string\", \"format\":\"binary\", \"description\":\"The Json schema is not available for this media-type.\"}}");
            }
            catch (Exception ex) {
                this.logger.warn("unexpected", (Throwable)ex);
                return null;
            }
        }
    }
}

