/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc.fifo;

import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.indy.runtime.api.impl.jdbc.fifo.BlockingQueueWithWait;
import com.indy.runtime.api.impl.jdbc.fifo.FifoRow;
import com.indy.runtime.api.impl.jdbc.fifo.Messages;
import com.indy.runtime.api.impl.jdbc.fifo.ResultSetImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.util.ReaderInputStream;

public abstract class FifoResultSet
extends ResultSetImpl {
    private BlockingQueueWithWait<FifoRow> queue;
    private static final Logger LOGGER = LogManager.getLogger(FifoResultSet.class);
    private boolean wasNull = false;
    private final Map<String, Integer> index = new HashMap<String, Integer>();
    private Function<String, Integer> columnIndexFunction = null;
    FifoRow currentRow = null;
    boolean isClosed = false;

    public FifoResultSet(BlockingQueueWithWait<FifoRow> queue) {
        this.queue = queue;
    }

    private Function<String, Integer> getColumnIndexFunction() throws SQLException {
        if (this.columnIndexFunction == null) {
            this.columnIndexFunction = new JdbcPreparedStatementToResultSet.ColumnIndexFunction(this.getMetaData());
        }
        return this.columnIndexFunction;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            return this.index.computeIfAbsent(columnLabel, this.getColumnIndexFunction());
        }
        catch (IllegalArgumentException e) {
            throw new SQLDataException(Messages.getString("FifoResultSet.0") + columnLabel + Messages.getString("FifoResultSet.1"));
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int type = this.getMetaData().getColumnType(columnIndex);
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -7: 
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case -6: {
                return this.getByte(columnIndex);
            }
            case 5: {
                return this.getShort(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 7: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return this.getDouble(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 1111: 
            case 2000: {
                return this.doGetObject(columnIndex);
            }
            case -8: {
                return this.getRowId(columnIndex);
            }
            case 2009: {
                return this.getSQLXML(columnIndex);
            }
        }
        throw new SQLDataException(Messages.getString("FifoResultSet.2") + this.getMetaData().getColumnType(columnIndex) + Messages.getString("FifoResultSet.3"));
    }

    private Object doGetObject(int columnIndex) throws SQLException {
        this.checkRow();
        Object object = this.currentRow.getObject(columnIndex);
        boolean bl = this.wasNull = object == null;
        if (object instanceof InetAddress) {
            return ((InetAddress)object).getHostAddress();
        }
        return object;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(this.getString(columnIndex));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as int", e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(this.getString(columnIndex));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as int", e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof InputStream) {
            try {
                return IOUtils.toByteArray((InputStream)((InputStream)object));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (object instanceof Reader) {
            try {
                return IOUtils.toByteArray((Reader)((Reader)object), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (object instanceof Clob) {
            try {
                Throwable e = null;
                Object var4_11 = null;
                try (InputStream stream = ((Clob)object).getAsciiStream();){
                    return IOUtils.toByteArray((InputStream)stream);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (object instanceof Blob) {
            try {
                Throwable e = null;
                Object var4_13 = null;
                try (InputStream stream = ((Blob)object).getBinaryStream();){
                    return IOUtils.toByteArray((InputStream)stream);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return object.toString().getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    private void checkRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException(Messages.getString("FifoResultSet.4"));
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof Reader) {
            try {
                return IOUtils.toString((Reader)((Reader)object));
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (object instanceof InputStream) {
            try {
                return IOUtils.toString((InputStream)((InputStream)object), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (object instanceof Clob) {
            try {
                Throwable e = null;
                Object var4_11 = null;
                try (Reader reader = ((Clob)object).getCharacterStream();){
                    return IOUtils.toString((Reader)reader);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (object instanceof Blob) {
            try {
                Throwable e = null;
                Object var4_13 = null;
                try (InputStream stream = ((Blob)object).getBinaryStream();){
                    return IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        return object.toString();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
        this.currentRow = null;
        this.queue = null;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        try {
            this.currentRow = this.queue.take();
        }
        catch (Exception e1) {
            throw new SQLException(e1);
        }
        return this.currentRow != null;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public double getDouble(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(this.getString(index));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as double", e);
        }
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String valAsString = this.getString(index);
        if ("0".equals(valAsString)) {
            return false;
        }
        if ("1".equals(valAsString)) {
            return true;
        }
        throw new SQLDataException(String.valueOf(object) + " cannot be converted as boolean");
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        try {
            return new BigDecimal(this.getString(index));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as number", e);
        }
    }

    @Override
    public Time getTime(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return null;
        }
        if (object instanceof LocalTime) {
            return Time.valueOf((LocalTime)object);
        }
        if (object instanceof OffsetTime) {
            return Time.valueOf(((OffsetTime)object).withOffsetSameInstant(OffsetTime.now().getOffset()).toLocalTime());
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        try {
            return Time.valueOf(this.getString(index));
        }
        catch (IllegalArgumentException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as Time", e);
        }
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return null;
        }
        if (object instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)object);
        }
        if (object instanceof ZonedDateTime) {
            return Timestamp.valueOf(((ZonedDateTime)object).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
        }
        if (object instanceof Instant) {
            return Timestamp.from((Instant)object);
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        if (object instanceof LocalDate) {
            return Timestamp.valueOf(((LocalDate)object).atStartOfDay());
        }
        try {
            return Timestamp.valueOf(this.getString(index));
        }
        catch (IllegalArgumentException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as Timestamp", e);
        }
    }

    @Override
    public Date getDate(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return null;
        }
        if (object instanceof LocalDate) {
            return Date.valueOf((LocalDate)object);
        }
        if (object instanceof Instant) {
            return new Date(java.util.Date.from((Instant)object).getTime());
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof java.util.Date) {
            return new Date(((java.util.Date)object).getTime());
        }
        if (object instanceof LocalDateTime) {
            return Date.valueOf(((LocalDateTime)object).toLocalDate());
        }
        try {
            return Date.valueOf(this.getString(index));
        }
        catch (IllegalArgumentException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as Date", e);
        }
    }

    @Override
    public InputStream getBinaryStream(int index) throws SQLException {
        Object object = this.doGetObject(index);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof Clob) {
            return ((Clob)object).getAsciiStream();
        }
        if (object instanceof Reader) {
            return new ReaderInputStream((Reader)object);
        }
        return IOUtils.toInputStream((String)object.toString(), (Charset)Charset.defaultCharset());
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object instanceof Blob) {
            return (Blob)object;
        }
        throw new SQLDataException(String.valueOf(object) + " cannot be converted as Blob");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof Reader) {
            return (Reader)object;
        }
        if (object instanceof byte[]) {
            return new StringReader(new String((byte[])object));
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof InputStream) {
            return new InputStreamReader((InputStream)object);
        }
        if (object instanceof Blob) {
            return new InputStreamReader(((Blob)object).getBinaryStream());
        }
        return new StringReader(object.toString());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        throw new SQLDataException(String.valueOf(object) + " cannot be converted as Clob");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getTime(columnIndex);
        }
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof OffsetTime) {
            return Time.valueOf(((OffsetTime)object).withOffsetSameInstant(cal.getTimeZone().toZoneId().getRules().getOffset(Instant.now())).toLocalTime());
        }
        return Time.valueOf(this.getTime(1).toLocalTime().atOffset(OffsetTime.now().getOffset()).withOffsetSameInstant(cal.getTimeZone().toZoneId().getRules().getOffset(Instant.now())).toLocalTime());
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (cal == null) {
            return this.getTimestamp(columnIndex);
        }
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof ZonedDateTime) {
            return Timestamp.valueOf(((ZonedDateTime)object).withZoneSameInstant(cal.getTimeZone().toZoneId()).toLocalDateTime());
        }
        return Timestamp.valueOf(this.getTimestamp(columnIndex).toLocalDateTime().atZone(ZoneId.systemDefault()).withZoneSameInstant(cal.getTimeZone().toZoneId()).toLocalDateTime());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    public boolean isEndMessage() {
        return this.currentRow == JdbcPreparedStatementToResultSet.endMessage;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        try {
            return Byte.parseByte(this.getString(columnIndex));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as byte", e);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        try {
            return Short.parseShort(this.getString(columnIndex));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as short", e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object object = this.doGetObject(columnIndex);
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.parseFloat(this.getString(columnIndex));
        }
        catch (NumberFormatException e) {
            throw new SQLDataException(String.valueOf(object) + " cannot be converted as float", e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }
}

