/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.wsdl;

import com.indy.runtime.wsdl.Messages;
import com.semarchy.xdi.engine.common.CommonUtils;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;

@XmlRootElement(name="httpRestWebServiceProperties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class HttpRestDeliveryProperties {
    private static Logger logger = LogManager.getLogger(HttpRestDeliveryProperties.class);
    Map<Integer, String> staticParts = new HashMap<Integer, String>();
    @XmlElement(name="urlPartMapper")
    private List<ParameterReplacement> parameterReplacements;
    @XmlElement(name="requestBodyMapper", required=false)
    private BodyMapper requestBodyMapper;
    @XmlElement(name="responseBodyMapper", required=false)
    private BodyMapper responseBodyMapper;
    @XmlElement(name="responseHeaderMapper")
    private List<ResponseParameterHeader> outputHeaderMapper;
    @XmlElement(name="requestHeaderMapper")
    private List<RequestParameterHeader> inputHeaderMapper;
    @XmlAttribute(name="extractRequestInfo", required=false)
    boolean extractRequestInf = false;
    @XmlAttribute(name="methods", required=false)
    List<String> methods;
    @XmlAttribute(name="path", required=false)
    String urlPathTemplate;
    boolean urlPathTemplateNotSet;
    @XmlAttribute(name="tags", required=false)
    Set<String> tags;
    @XmlAttribute(name="requestContentType", required=false)
    String requestContentType;
    @XmlElement(name="responseCodeMapper", required=false)
    private BodyMapper responseCodeMapper;

    public static HttpRestDeliveryProperties getHttpRestDeliveryProperties(Node node, String delivName) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        HttpRestDeliveryProperties hrdp = (HttpRestDeliveryProperties)JAXB.unmarshal((Reader)isr, HttpRestDeliveryProperties.class);
        if (hrdp.urlPathTemplate == null) {
            hrdp.urlPathTemplate = delivName;
            hrdp.urlPathTemplateNotSet = true;
        }
        if (!hrdp.urlPathTemplateNotSet && hrdp.parameterReplacements != null && !hrdp.parameterReplacements.isEmpty()) {
            throw new TransformerException(Messages.getString("HttpRestDeliveryProperties.0") + delivName + Messages.getString("HttpRestDeliveryProperties.1"));
        }
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        List<String> list = Arrays.asList(hrdp.urlPathTemplate.split("/"));
        int position = -1;
        for (String part : list) {
            ++position;
            if (part.startsWith("{") && part.endsWith("}")) {
                String current = part.substring(1, part.length() - 1);
                if (!current.startsWith("{") && !current.endsWith("}")) {
                    params.put(position, current);
                    ParameterReplacement pr = hrdp.getParameterReplacementName(position);
                    if (pr != null) continue;
                    pr = new ParameterReplacement();
                    pr.name = current;
                    pr.position = position;
                    if (hrdp.parameterReplacements == null) {
                        hrdp.parameterReplacements = new ArrayList<ParameterReplacement>();
                    }
                    hrdp.parameterReplacements.add(pr);
                    continue;
                }
                hrdp.staticParts.put(position, current);
                continue;
            }
            hrdp.staticParts.put(position, part);
        }
        return hrdp;
    }

    public boolean testRequest(List<String> parts) {
        if (parts.size() != this.staticParts.size() + this.getParameterReplacementsSize()) {
            return false;
        }
        int position = -1;
        for (String part : parts) {
            ParameterReplacement pr;
            String str;
            if ((str = this.staticParts.get(++position)) != null && str.equals(part) || (pr = this.getParameterReplacementName(position)) != null) continue;
            return false;
        }
        return true;
    }

    public boolean testRequestContentType(String contentType) {
        if (this.requestContentType == null) {
            return true;
        }
        if (contentType == null) {
            return false;
        }
        return contentType.equalsIgnoreCase(this.requestContentType);
    }

    public boolean testMethod(String method) {
        if (this.methods == null) {
            return true;
        }
        if (this.methods.isEmpty()) {
            return true;
        }
        return this.methods.contains(method.toLowerCase());
    }

    public ParameterReplacement getParameterReplacementName(int position) {
        if (this.parameterReplacements != null) {
            for (ParameterReplacement pr : this.parameterReplacements) {
                if (pr.position != position) continue;
                return pr;
            }
        }
        return null;
    }

    public List<ParameterReplacement> getParameterReplacement() {
        return this.parameterReplacements;
    }

    public ParameterReplacement getParameterReplacement(String name) {
        if (this.parameterReplacements == null) {
            return null;
        }
        for (ParameterReplacement pr : this.parameterReplacements) {
            if (pr.name == null || !pr.name.equals(name)) continue;
            return pr;
        }
        return null;
    }

    int getParameterReplacementsSize() {
        return this.parameterReplacements == null ? 0 : this.parameterReplacements.size();
    }

    public BodyMapper getRequestBodyMapper() {
        return this.requestBodyMapper;
    }

    public BodyMapper getResponseBodyMapper() {
        return this.responseBodyMapper;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public boolean extractRequestInf() {
        return this.extractRequestInf;
    }

    public boolean isUrlPathTemplateNotSet() {
        return this.urlPathTemplateNotSet;
    }

    public RequestParameterHeader getInputHeaderParameterName(String key) {
        if (key != null && this.inputHeaderMapper != null) {
            for (RequestParameterHeader pr : this.inputHeaderMapper) {
                if (pr.getParameterName() == null || !pr.getParameterName().equals(key)) continue;
                return pr;
            }
        }
        return null;
    }

    public List<RequestParameterHeader> getInputHeaderMapper() {
        return this.inputHeaderMapper;
    }

    public List<ResponseParameterHeader> getOutputHeaderMapper() {
        return this.outputHeaderMapper;
    }

    public BodyMapper getResponseCodeMapper() {
        return this.responseCodeMapper;
    }

    public Collection<String> getMethods() {
        if (this.methods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.methods;
    }

    public Set<String> getTags() {
        if (this.tags == null) {
            return Collections.EMPTY_SET;
        }
        return this.tags;
    }

    public String getPathTemplate() {
        return this.urlPathTemplate;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class BodyMapper {
        @XmlAttribute(name="parameterName", required=false)
        private String parameterName;
        @XmlAttribute(name="defaultValue", required=false)
        private String value;
        @XmlAttribute(name="charset", required=false)
        private String charset;

        public String getValue() {
            return this.value;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getCharset() {
            return this.charset;
        }

        public byte[] getValueBytes() throws UnsupportedEncodingException {
            if (this.value != null) {
                if (this.charset != null) {
                    return this.value.getBytes(this.charset);
                }
                return this.value.getBytes();
            }
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ParameterReplacement {
        @XmlAttribute(name="parameterName", required=true)
        private String name;
        @XmlAttribute(name="urlPartPosition", required=true)
        private int position;
        @XmlAttribute(name="defaultValue", required=false)
        private String value;

        public int getPosition() {
            return this.position;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RequestParameterHeader {
        @XmlAttribute(name="headerName", required=true)
        private String headerName;
        @XmlAttribute(name="parameterName", required=true)
        private String parameterName;
        @XmlAttribute(name="caseSensitive", required=false)
        private boolean caseSensitive = false;
        @XmlAttribute(name="defaultValue", required=false)
        private String value;

        public String getHeaderName() {
            return this.headerName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                String key = (String)obj;
                return this.headerName != null && (this.caseSensitive && this.headerName.equals(key) || !this.caseSensitive && this.headerName.equalsIgnoreCase(key));
            }
            return super.equals(obj);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ResponseParameterHeader {
        @XmlAttribute(name="headerName", required=true)
        private String headerName;
        @XmlAttribute(name="parameterName", required=false)
        private String parameterName;
        @XmlAttribute(name="defaultValue", required=false)
        private String value;

        public String getHeaderName() {
            return this.headerName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getValue() {
            return this.value;
        }
    }
}

