/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;
import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceWrapperImpl;
import com.semarchy.xdi.runtime.connection.jdbc.JdbcParameters;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiConsumer;
import javax.sql.DataSource;

public class HikariDataSourceImpl
extends AbstractDataSourceWrapperImpl {
    private HikariDataSource dataSource = null;

    public HikariDataSourceImpl(JdbcParameters jdbcParameters) {
        super(jdbcParameters);
    }

    private HikariConfig getHikariConfig() throws IExternalValueResolverPlugin.ExternalValueResolverException {
        JdbcParameters jdbcParameters = this.getJdbcParameters();
        HikariConfig config = new HikariConfig();
        config.setAutoCommit(jdbcParameters.isAutocommit());
        config.setDriverClassName(jdbcParameters.getDriver());
        config.setMaximumPoolSize(jdbcParameters.getMaximumPoolSize());
        config.setMinimumIdle(jdbcParameters.getMinimumIdle());
        config.setJdbcUrl(jdbcParameters.getUrl());
        config.setUsername(jdbcParameters.evaluateSecuredExternalValues(jdbcParameters.getUsername()));
        config.setPassword(jdbcParameters.evaluateSecuredExternalValues(jdbcParameters.getPassword()));
        config.setConnectionTimeout((long)jdbcParameters.getConnectionTimeout());
        List<String> connectionInitSqlsList = jdbcParameters.getConnectionInitSqls();
        if (!connectionInitSqlsList.isEmpty()) {
            config.setConnectionInitSql(String.join((CharSequence)";", connectionInitSqlsList));
        }
        config.setValidationTimeout((long)jdbcParameters.getValidationTimeout());
        config.setIdleTimeout((long)jdbcParameters.getIdleTimeout());
        config.setMaxLifetime((long)jdbcParameters.getMaxLifetime());
        if (jdbcParameters.getValidationQuery() != null) {
            config.setConnectionTestQuery(jdbcParameters.getValidationQuery());
        }
        jdbcParameters.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> config.addDataSourceProperty(k.toString(), (Object)v.toString())));
        return config;
    }

    @Override
    protected DataSource doGetDataSource() throws SQLException {
        if (this.dataSource == null) {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getJDBCClassLoader());
                    this.dataSource = new HikariDataSource(this.getHikariConfig());
                }
                catch (Exception e) {
                    if (this.getJdbcParameters().hasSecrets()) {
                        throw new SQLException((Throwable)new SecretStatementException());
                    }
                    if (e instanceof SQLException) {
                        SQLException sqlException = (SQLException)e;
                        throw sqlException;
                    }
                    throw new SQLException(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        return this.dataSource;
    }

    @Override
    public void close() throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @Override
    protected void refreshCredentials() throws IExternalValueResolverPlugin.ExternalValueResolverException {
        if (this.dataSource == null) {
            return;
        }
        JdbcParameters jdbcParameters = this.getJdbcParameters();
        this.dataSource.getHikariConfigMXBean().setUsername(this.getJdbcParameters().evaluateSecuredExternalValues(jdbcParameters.getUsername()));
        this.dataSource.getHikariConfigMXBean().setPassword(this.getJdbcParameters().evaluateSecuredExternalValues(jdbcParameters.getPassword()));
    }
}

