/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry.internal;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.AbstractRegistry;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.services.registry.ReferencableObject;
import com.semarchy.xdi.designer.core.services.registry.RegistrationDescriptor;
import com.semarchy.xdi.designer.core.services.registry.RuntimeEngine;
import com.semarchy.xdi.designer.core.services.registry.StagingAreaDescriptor;
import com.semarchy.xdi.designer.core.services.registry.TechExtension;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.services.registry.internal.Messages;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryLevelCodeImage;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryProcessToolDescriptor;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryReferencableObject;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryRuntimeEngine;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryStagingAreaProvider;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryTech;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryTechExtension;
import com.semarchy.xdi.designer.core.services.registry.internal.RegistryUDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.log.LoggerFactory;

@Component(service={IRegistryService.class}, scope=ServiceScope.SINGLETON)
public class RegistryService
implements IRegistryService {
    private Map<Class<?>, IRegistryService.IRegistry<?>> registries = Collections.synchronizedMap(new HashMap());
    @Reference
    private LoggerFactory logService;

    @Activate
    public void activate() {
        this.registries.put(LevelCodeInfo.class, new RegistryLevelCodeImage());
        this.registries.put(RegistrationDescriptor.class, new RegistryTech());
        this.registries.put(UDF.class, new RegistryUDF());
        this.registries.put(ProcessToolDescriptor.class, new RegistryProcessToolDescriptor());
        this.registries.put(RuntimeEngine.class, new RegistryRuntimeEngine());
        this.registries.put(TechExtension.class, new RegistryTechExtension());
        this.registries.put(ReferencableObject.class, new RegistryReferencableObject());
        this.registries.put(StagingAreaDescriptor.class, new RegistryStagingAreaProvider());
    }

    @Reference(service=IRegistryService.IRegistry.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bind(IRegistryService.IRegistry registry) {
        Class objectsClass = registry.getType();
        if (this.registries.get(objectsClass) == null) {
            this.registries.put(objectsClass, registry);
        }
    }

    public void unbind(IRegistryService.IRegistry registry) {
        Class<?> c = registry.getClass();
        this.registries.remove(c);
    }

    @Override
    public <T> IRegistryService.IRegistry<T> getRegistry(Class<T> type) {
        IRegistryService.IRegistry<?> reg = this.registries.get(type);
        return reg;
    }

    @Override
    public synchronized void updateObjectsFrom(IRegistryService.IRegistrationContribution resource) throws Exception {
        ICacheService cacheService = E4InjectorHelper.getService(ICacheService.class);
        String id = cacheService.getSourceId(resource.getURI());
        for (Class c : resource.getContributedRegistries()) {
            IRegistryService.IRegistry reg = this.getRegistry(c);
            if (reg == null) continue;
            reg.registerFrom(id, resource);
        }
    }

    @Override
    public synchronized void clear() {
        for (IRegistryService.IRegistry<?> r : this.registries.values()) {
            r.clear();
        }
    }

    @Override
    public synchronized void unregisterObjectsFrom(String sourceID) {
        for (IRegistryService.IRegistry<?> r : this.registries.values()) {
            r.unregisterFrom(sourceID);
        }
    }

    @Override
    @Deactivate
    public void persist() {
        for (IRegistryService.IRegistry<?> r : this.registries.values()) {
            if (!(r instanceof AbstractRegistry)) continue;
            try {
                ((AbstractRegistry)r).save();
            }
            catch (Throwable t) {
                this.logService.getLogger(RegistryService.class).error(String.format(Messages.RegistryService_0, ((AbstractRegistry)r).getRegistredClass().getName()), (Object)t);
            }
        }
    }
}

