/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class OSCommandWrapper {
    private Charset charset;
    private Process process;
    private String[] cmd;
    private File workingDir;
    private Logger logger = LogManager.getLogger(OSCommandWrapper.class);
    private int exitCode = -1;

    public static OSCommandWrapper build(Charset charset, String command, File workingDir) {
        return new OSCommandWrapper(charset, new String[]{command}, workingDir);
    }

    public static OSCommandWrapper build(Charset charset, String[] command, File workingDir) {
        return new OSCommandWrapper(charset, command, workingDir);
    }

    private OSCommandWrapper(Charset charset, String[] cmd, File workingDir) {
        this.charset = charset;
        this.cmd = cmd;
        this.workingDir = workingDir;
    }

    public void waitForProcess(long timeout) throws TimeoutException, InterruptedException, IllegalArgumentException, IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.workingDir);
        builder.command(this.cmd);
        this.process = builder.start();
        Task task = null;
        if (timeout > 0L) {
            Timer timer = new Timer("Timer");
            task = new Task();
            timer.schedule((TimerTask)task, timeout);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created process for {}", (Object[])this.cmd);
        }
        this.exitCode = this.process.waitFor();
        if (task != null && task.interrupted) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Process interrupted");
            }
            throw new TimeoutException(String.format("Specified timeout %s exceeded", timeout));
        }
    }

    public int getExitValue() {
        return this.exitCode;
    }

    public String getErrorOutput(int limit) throws IOException {
        return this.readStream(limit, this.process.getErrorStream());
    }

    public String getStandardOutput(int limit) throws IOException {
        return this.readStream(limit, this.process.getInputStream());
    }

    public boolean interrupt() {
        if (this.process != null && this.process.isAlive()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("interruping");
            }
            this.process.destroyForcibly();
            return true;
        }
        return false;
    }

    private String readStream(int limit, InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            byte[] buffer = new byte[2048];
            int l = is.read(buffer);
            int curSz = 0;
            while (l != -1) {
                if (limit == -1 || (curSz += l) <= limit) {
                    bos.write(buffer, 0, l);
                    l = is.read(buffer);
                    continue;
                }
                l = -1;
            }
            return bos.toString(this.charset);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class Task
    extends TimerTask {
        boolean interrupted = false;

        private Task() {
        }

        @Override
        public void run() {
            this.interrupted = OSCommandWrapper.this.interrupt();
        }
    }
}

